/*
 * Decompiled with CFR 0.152.
 */
package pedersen.debug;

import java.awt.Color;
import java.awt.Graphics2D;
import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.debug.GraphicalDebugger;
import pedersen.debug.TracerBank;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import robocode.Bullet;

public class Tracer
implements Debuggable {
    private final Bullet bullet;

    public Tracer(Bullet newBullet) {
        this.bullet = newBullet;
        TracerBank.singleton.add(this);
    }

    public StaticPosition getStaticPosition() {
        return new StaticPositionImpl(this.bullet.getX(), this.bullet.getY());
    }

    public StaticVector getStaticVector() {
        return new StaticVectorImpl(this.bullet.getHeadingRadians(), this.bullet.getVelocity());
    }

    public boolean isActive() {
        return this.bullet.isActive();
    }

    public void onPaint(Graphics2D console) {
        if (this.isActive()) {
            console.setColor(Color.yellow);
            StaticPosition center = this.getStaticPosition();
            double radius = this.getStaticVector().getVelocity();
            GraphicalDebugger.singleton.drawRing(console, center, radius);
        }
    }

    public void debug() {
        Debug.debug("Tracer:");
        this.getStaticPosition().debug();
        this.getStaticVector().debug();
    }
}

