/*
 * Decompiled with CFR 0.152.
 */
package wiki;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class WaveRammer
extends AdvancedRobot {
    private static double[][][] _surfStats = new double[4][5][47];
    public static Point2D.Double _myLocation;
    public static Point2D.Double _enemyLocation;
    public static LinkedList<Wave> _enemyWaves;
    private static double _oppEnergy;
    private static Wave _surfWave;
    private static Wave _nextSurfWave;
    private static double _lastDistance;
    private static double _lastLatVel;
    private static double _lastAbsBearingRadians;
    private static double _goAngle;
    private static int _ramCounter;
    private static Rectangle2D.Double _fieldRect;
    static final double SURFING_CONSTANT = 2.25;
    static final double RAM_SURFING = 2.7;
    static final double WALL_STICK = 140.0;
    static final int GF_ZERO = 23;
    static final int GF_ONE = 46;
    private static double _enemyAbsoluteBearing;
    private static int _lastGunOrientation;
    private int mode = 3;
    private boolean first = true;
    private ArrayList<Point2D.Double> point;
    private ArrayList<Wave> _myWaves;
    static double lastVChangeTime;
    static int enemyVelocity;
    static double[][][][][][] _gunStats;
    static final double LOG_BASE_E_TO_2_CONVERSION_CONSTANT = 1.4427;

    static {
        _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        _gunStats = new double[6][4][4][2][3][47];
    }

    public void run() {
        this.setColors(Color.black, Color.black, Color.white);
        _enemyWaves = new LinkedList();
        this._myWaves = new ArrayList();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.out.println("WaveRammer Ready");
        this.out.println("Finding enemy...");
        this.point = new ArrayList();
        while (true) {
            if (this.getRadarTurnRemaining() == 0.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            this.scan();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double enemyAbsoluteBearing;
        int direction;
        Wave w;
        double d;
        if (this.first) {
            this.first = false;
            this.out.println("Found bot " + e.getName() + ", going to ram it!");
            this.out.println("Start ramming...");
        }
        double bulletPower = _oppEnergy - e.getEnergy();
        if (d <= 3.0 && bulletPower > 0.0) {
            w = _nextSurfWave;
            _nextSurfWave.bulletSpeed = Rules.getBulletSpeed((double)bulletPower);
            this.addCustomEvent(w);
            _enemyWaves.addLast(w);
            w.enemyWave = true;
        }
        _nextSurfWave = w = new Wave();
        w.directAngle = _lastAbsBearingRadians;
        w.waveGuessFactors = _surfStats[(int)Math.min((_lastDistance + 50.0) / 200.0, 3.0)][(int)((Math.abs(_lastLatVel) + 1.0) / 2.0)];
        w.orientation = direction = WaveRammer.sign(_lastLatVel);
        _myLocation = new Point2D.Double(this.getX(), this.getY());
        _enemyAbsoluteBearing = enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        _lastDistance = e.getDistance();
        w.sourceLocation = _enemyLocation = WaveRammer.project(_myLocation, enemyAbsoluteBearing, _lastDistance);
        w = new Wave();
        new Wave().sourceLocation = _myLocation;
        this._myWaves.add(w);
        this.addCustomEvent(w);
        w.directAngle = enemyAbsoluteBearing;
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(w.directAngle - this.getRadarHeadingRadians())) * 2.0);
        try {
            _surfWave = _enemyWaves.getFirst();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int lastMode = this.mode;
        if (_surfWave != null) {
            if (e.getDistance() > 130.0) {
                direction = WaveRammer.sign(this.checkDanger(-1) - this.checkDanger(1));
                _goAngle = _surfWave.absoluteBearing(_myLocation) + 2.25 * (double)direction;
                this.mode = 0;
            } else if (e.getDistance() > 50.0) {
                direction = WaveRammer.sign(this.checkDanger(-1) - this.checkDanger(1));
                _goAngle = _surfWave.absoluteBearing(_myLocation) + 2.7 * (double)direction;
                this.mode = 1;
            } else {
                _goAngle = _enemyAbsoluteBearing;
                this.mode = 2;
            }
        } else {
            _goAngle = _enemyAbsoluteBearing;
            this.mode = 3;
        }
        if (this.mode != lastMode) {
            switch (this.mode) {
                case 0: {
                    this.out.println("Changing to Wave Surfing");
                    break;
                }
                case 1: {
                    this.out.println("Changing to Ram Surfing");
                    break;
                }
                case 2: {
                    this.out.println("Changing to Ramming");
                    break;
                }
                case 3: {
                    this.out.println("No Waves, ramming!");
                }
            }
        }
        double angle = WaveRammer.wallSmoothing(_myLocation, _goAngle, direction) - this.getHeadingRadians();
        this.setTurnRightRadians(Math.tan(angle));
        this.setAhead(Math.cos(angle) * Double.POSITIVE_INFINITY);
        double enemyLatVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing);
        _lastGunOrientation = w.orientation = WaveRammer.sign(enemyLatVel);
        double d2 = lastVChangeTime;
        lastVChangeTime = d2 + 1.0;
        int bestGF = Math.min(3, (int)Math.pow(280.0 * d2 / _lastDistance, 0.7));
        enemyLatVel = Math.abs(enemyLatVel);
        int newVelocity = (int)enemyLatVel;
        if (enemyVelocity != newVelocity) {
            lastVChangeTime = 0.0;
            bestGF = 4;
            if (enemyVelocity > newVelocity) {
                bestGF = 5;
            }
        }
        enemyVelocity = newVelocity;
        w.waveGuessFactors = _gunStats[bestGF][(int)(1.4427 * Math.log(enemyLatVel + 1.5))][WaveRammer.gunWallDistance(0.18247367367) ? (WaveRammer.gunWallDistance(0.36494734735) ? (WaveRammer.gunWallDistance(0.63865785787) ? 3 : 2) : 1) : 0][WaveRammer.gunWallDistance(-0.36494734735) ? 0 : 1][(int)WaveRammer.limit(0.0, (_lastDistance - 75.0) / 200.0, 2.0)];
        bestGF = 23;
        int gf = 46;
        while (gf >= 0 && (_oppEnergy = e.getEnergy()) > 0.0) {
            if (w.waveGuessFactors[gf] > w.waveGuessFactors[bestGF]) {
                bestGF = gf;
            }
            --gf;
        }
        double power = 2.0 - Math.max(0.0, (30.0 - this.getEnergy()) / 16.0);
        if (e.getDistance() < 130.0) {
            power = 3.0;
        }
        w.bulletSpeed = Rules.getBulletSpeed((double)power);
        w.distance = -1.5 * w.bulletSpeed;
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getGunHeadingRadians() + (double)_lastGunOrientation * (Math.asin(8.0 / w.bulletSpeed) / 23.0) * (double)(bestGF - 23))));
        if (this.setFireBullet(power) != null) {
            w.weight = 4;
            w.firingWave = true;
        }
        _lastLatVel = this.getVelocity() * Math.sin(e.getBearingRadians());
        _goAngle = _lastAbsBearingRadians = enemyAbsoluteBearing + Math.PI;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Wave surfWave = _surfWave;
        if (surfWave == null) {
            return;
        }
        _oppEnergy += e.getBullet().getPower() * 3.0;
        if (surfWave.distanceToPoint(_myLocation) - surfWave.distance < 100.0) {
            WaveRammer.logHit(surfWave, _myLocation, 0.7);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Point2D.Double bulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        int x = 0;
        while (x < _enemyWaves.size()) {
            Wave w = _enemyWaves.get(x);
            if (Math.abs(w.distanceToPoint(bulletLocation) - w.distance) < 50.0) {
                WaveRammer.logHit(w, bulletLocation, 0.7);
            }
            ++x;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        _oppEnergy -= Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    public void onHitRobot(HitRobotEvent event) {
        if (!event.isMyFault()) {
            ++_ramCounter;
        }
    }

    public void onCustomEvent(CustomEvent e) {
        this.removeCustomEvent(e.getCondition());
        if (!((Wave)e.getCondition()).enemyWave) {
            this._myWaves.remove(e.getCondition());
        }
    }

    public static void logHit(Wave w, Point2D.Double targetLocation, double rollingDepth) {
        int x = 46;
        while (x >= 0) {
            w.waveGuessFactors[x] = (w.waveGuessFactors[x] * rollingDepth + (double)(1 + w.weight) / (Math.pow(x - WaveRammer.getFactorIndex(w, targetLocation), 2.0) + 1.0)) / (rollingDepth + 1.0 + (double)w.weight);
            --x;
        }
    }

    private static int getFactorIndex(Wave w, Point2D.Double botLocation) {
        return (int)WaveRammer.limit(0.0, Utils.normalRelativeAngle((double)(w.absoluteBearing(botLocation) - w.directAngle)) * (double)w.orientation / Math.asin(8.0 / w.bulletSpeed) * 23.0 + 23.0, 46.0);
    }

    private double checkDanger(int direction) {
        double lastPredictedDistance;
        Wave surfWave = _surfWave;
        Point2D.Double predictedPosition = _myLocation;
        double predictedHeading = this.getHeadingRadians();
        double predictedVelocity = this.getVelocity();
        int counter = 3;
        do {
            double d;
            double moveDir = 1.0;
            double moveAngle = WaveRammer.wallSmoothing(predictedPosition, surfWave.absoluteBearing(predictedPosition) + (double)direction * 2.25, direction) - predictedHeading;
            if (Math.cos(d) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            double maxTurning = Rules.getTurnRateRadians((double)Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + WaveRammer.limit(-maxTurning, Utils.normalRelativeAngle((double)moveAngle), maxTurning)));
            predictedVelocity = WaveRammer.limit(-8.0, predictedVelocity + (predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir), 8.0);
            predictedPosition = WaveRammer.project(predictedPosition, predictedHeading, predictedVelocity);
            this.point.add(predictedPosition);
        } while ((lastPredictedDistance = surfWave.distanceToPoint(predictedPosition)) >= surfWave.distance + (double)(++counter) * surfWave.bulletSpeed);
        int index = WaveRammer.getFactorIndex(surfWave, predictedPosition);
        return (surfWave.waveGuessFactors[index] + 0.01 / (double)(Math.abs(index - 23) + 1)) / 1.0;
    }

    private static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    private static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    private static int sign(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    private static double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(WaveRammer.project(botLocation, angle, 140.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    private static boolean gunWallDistance(double wallDistance) {
        return _fieldRect.contains(WaveRammer.project(_myLocation, _enemyAbsoluteBearing + (double)_lastGunOrientation * wallDistance, _lastDistance));
    }

    public void onPaint(Graphics2D g) {
        Point2D.Double start;
        int r;
        g.setColor(Color.pink);
        for (Point2D.Double p : this.point) {
            g.fillOval((int)Math.round(p.x - 2.0), (int)Math.round(p.y - 2.0), 4, 4);
        }
        this.point.clear();
        for (Wave w : _enemyWaves) {
            r = (int)Math.round(w.distance + w.bulletSpeed);
            g.setColor(Color.red);
            start = w.sourceLocation;
            g.drawOval((int)Math.round(start.x - (double)r), (int)Math.round(start.y - (double)r), r * 2, r * 2);
        }
        for (Wave w : this._myWaves) {
            if (!w.firingWave) continue;
            r = (int)Math.round(w.distance + w.bulletSpeed * 1.5);
            g.setColor(Color.green);
            start = w.sourceLocation;
            g.drawOval((int)Math.round(start.x - (double)r), (int)Math.round(start.y - (double)r), r * 2, r * 2);
        }
    }

    static class Wave
    extends Condition {
        Point2D.Double sourceLocation;
        double[] waveGuessFactors;
        double bulletSpeed;
        double directAngle;
        double distance;
        int orientation;
        int weight;
        boolean enemyWave = false;
        boolean firingWave = false;

        Wave() {
        }

        public double distanceToPoint(Point2D.Double p) {
            return this.sourceLocation.distance(p);
        }

        public double absoluteBearing(Point2D.Double target) {
            return Math.atan2(target.x - this.sourceLocation.x, target.y - this.sourceLocation.y);
        }

        public boolean test() {
            double d;
            Point2D.Double double_ = this.enemyWave ? _myLocation : _enemyLocation;
            this.distance += this.bulletSpeed;
            if (this.distanceToPoint(double_) <= d + 2.0 * this.bulletSpeed) {
                if (!_enemyWaves.remove((Object)this)) {
                    WaveRammer.logHit(this, _enemyLocation, 600.0);
                }
                return true;
            }
            return false;
        }
    }
}

