/*
 * Decompiled with CFR 0.152.
 */
package xander.core.track;

import java.awt.geom.Point2D;
import xander.core.drive.Direction;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.core.track.XBullet;

public class XBulletWave
extends Wave {
    private XBullet xbullet;
    private String gunName;

    public XBulletWave(Point2D.Double origin, long originTime, double originDistance, XBullet bullet, String gunName, double initialDefenderBearing, Direction surfDirection) {
        super(origin, originTime, originDistance, bullet.getPower(), initialDefenderBearing, surfDirection);
        this.xbullet = bullet;
        this.gunName = gunName;
    }

    public XBulletWave(Snapshot defenderSnapshot, Snapshot attackerSnapshot, XBullet bullet, String gunName, long bulletFiredTime) {
        super(defenderSnapshot, attackerSnapshot, bullet.getPower(), bulletFiredTime);
        this.xbullet = bullet;
        this.gunName = gunName;
    }

    public XBullet getXBullet() {
        return this.xbullet;
    }

    public String getGunName() {
        return this.gunName;
    }

    public Point2D.Double getBulletLocation(long time) {
        return RCMath.getLocation(this.getOriginX(), this.getOriginY(), this.getBulletTravelDistance(time), this.xbullet.getAim());
    }
}

