/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems;

import java.util.Iterator;
import java.util.List;
import pedersen.core.Snapshot;
import pedersen.physics.DynamicPositionImpl;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import pedersen.systems.DrivingMethod;
import pedersen.tactics.movement.MovementMethod;
import pedersen.tactics.movement.MovementMethodSet;

public class DrivingMethodStandardImpl
implements DrivingMethod {
    private List ambientMovementMethods;
    private MovementMethod dynamicMovementMethod;
    private boolean performanceStatisticsTracking = false;

    public DrivingMethodStandardImpl(MovementMethodSet movementMethods) {
        this.ambientMovementMethods = movementMethods.getAmbientMovementMethods();
        this.dynamicMovementMethod = movementMethods.getOptimalMovementMethod(0);
        if (this.dynamicMovementMethod != null) {
            this.dynamicMovementMethod.activate();
        }
    }

    public DrivingMethodStandardImpl(MovementMethodSet movementMethods, int gracePeriod) {
        this.ambientMovementMethods = movementMethods.getAmbientMovementMethods();
        this.dynamicMovementMethod = movementMethods.getOptimalMovementMethod(gracePeriod);
        if (this.dynamicMovementMethod != null) {
            this.dynamicMovementMethod.activate();
        }
    }

    public StaticVector operate(Snapshot combatant, Snapshot target, long time) {
        DynamicPositionImpl compositePosition = new DynamicPositionImpl();
        boolean isExclusive = false;
        if (this.dynamicMovementMethod != null) {
            compositePosition.add(this.dynamicMovementMethod.getRelativePositionTarget(combatant, target, time));
            isExclusive = this.dynamicMovementMethod.isExclusive();
        }
        if (!isExclusive) {
            Iterator iterator = this.ambientMovementMethods.iterator();
            while (iterator.hasNext()) {
                MovementMethod movementMethod = (MovementMethod)iterator.next();
                compositePosition.add(movementMethod.getRelativePositionTarget(combatant, target, time));
            }
        }
        StaticVector movementVector = compositePosition.getVector();
        movementVector = this.adjustForAnglesToRear(combatant, movementVector);
        return movementVector;
    }

    private StaticVector adjustForAnglesToRear(StaticVector presentVector, StaticVector movementVector) {
        double totalRelativeHeadingChange = movementVector.getRelativeAngle(presentVector);
        if (Math.abs(totalRelativeHeadingChange) > 1.5707963267948966) {
            movementVector = new StaticVectorImpl(movementVector.getHeading() + Math.PI, -movementVector.getVelocity());
        }
        return presentVector.compareVector(movementVector);
    }

    public void setPerformanceStatisticsTracking(boolean on) {
        this.performanceStatisticsTracking = on;
    }

    public void recordTime() {
        if (this.performanceStatisticsTracking && this.dynamicMovementMethod != null) {
            this.dynamicMovementMethod.recordTime();
        }
    }

    public void recordHit() {
        if (this.performanceStatisticsTracking && this.dynamicMovementMethod != null) {
            this.dynamicMovementMethod.recordHit();
        }
    }

    public void onEnemyFire() {
        if (this.performanceStatisticsTracking && this.dynamicMovementMethod != null) {
            this.dynamicMovementMethod.onEnemyFire();
        }
    }
}

