/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.robot;

import dmh.robocode.geo.Bearing;
import dmh.robocode.geo.Point;
import dmh.robocode.geo.Wave;
import dmh.robocode.patterns.ShotWave;
import dmh.robocode.patterns.StartingCondition;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class PinkPanther
extends AdvancedRobot {
    private Point shootingTargetLocation;
    private Point enemyLocation;
    private Point myLocation;
    private ArrayList<ShotWave> shotWaves = new ArrayList();
    private static ArrayList<ShotWave> shotWaveResults = new ArrayList();
    private double radarDirection = 2000.0;
    private StartingCondition startingConditionNow;
    private boolean usingJiggleMovementStrategy = false;
    private ScannedRobotEvent enemyScanInfo;
    private double enemyChangeOfHeading;
    private int moveDirection = 22;
    private boolean haveFired = false;
    private Point battlefieldCentre;

    public void onScannedRobot(ScannedRobotEvent event) {
        this.enemyLocation = this.myLocation.getRelativePoint(this.getHeading() + event.getBearing(), event.getDistance());
        this.radarDirection = -this.radarDirection;
        if (this.enemyScanInfo != null) {
            this.enemyChangeOfHeading = Bearing.getRightTurnBetween(this.enemyScanInfo.getHeading(), event.getHeading());
        }
        this.enemyScanInfo = event;
    }

    public void onHitByBullet(HitByBulletEvent event) {
        if (this.enemyScanInfo.getDistance() < 200.0) {
            this.usingJiggleMovementStrategy = true;
        }
    }

    public void onHitWall(HitWallEvent event) {
        this.moveDirection = -this.moveDirection;
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAllColors(Color.PINK);
        this.battlefieldCentre = new Point(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
        while (true) {
            this.myLocation = new Point(this.getX(), this.getY());
            if (this.enemyScanInfo != null) {
                this.startingConditionNow = new StartingCondition(this.myLocation, this.enemyLocation, this.enemyScanInfo.getHeading(), this.enemyScanInfo.getVelocity(), this.enemyChangeOfHeading);
                this.fireGunIfPointingAtEnemy();
                this.sendFullPowerShotWave();
                this.processWavesHittingAnEnemy();
                this.pointGunAtEnemy();
                if (this.usingJiggleMovementStrategy) {
                    this.moveRobotInJiggles();
                } else {
                    this.moveRobotCopyingEnemy();
                }
            } else {
                this.moveRobotToPosition(this.battlefieldCentre);
            }
            this.operateRadar();
            this.execute();
        }
    }

    private void moveRobotInJiggles() {
        if (this.getTime() < 25L) {
            this.moveRobotToPosition(this.battlefieldCentre);
        } else {
            if (this.getTime() % 30L == 0L) {
                this.moveDirection = -this.moveDirection;
            }
            this.setTurnRight(Bearing.getRightTurnBetween(this.getHeading(), this.enemyLocation.getBearingTowards(this.myLocation) + 90.0));
            this.setAhead(this.moveDirection);
        }
    }

    private void moveRobotCopyingEnemy() {
        double distance = 0.9 * this.battlefieldCentre.getDistanceFrom(this.enemyLocation);
        double bearing = this.battlefieldCentre.getBearingTowards(this.enemyLocation) + 180.0;
        this.moveRobotToPosition(this.battlefieldCentre.getRelativePoint(bearing, distance));
    }

    private void moveRobotToPosition(Point position) {
        double forwardTurn = Bearing.getRightTurnBetween(this.getHeading(), this.myLocation.getBearingTowards(position));
        if (Math.abs(forwardTurn) <= 90.0) {
            this.setTurnRight(forwardTurn);
            this.setAhead(100.0);
        } else {
            this.setTurnRight(Utils.normalRelativeAngleDegrees((double)(forwardTurn + 180.0)));
            this.setAhead(-100.0);
        }
    }

    private void operateRadar() {
        this.setTurnRadarRight(this.radarDirection);
    }

    private void processWavesHittingAnEnemy() {
        Iterator<ShotWave> shotWaveIter = this.shotWaves.iterator();
        while (shotWaveIter.hasNext()) {
            ShotWave shotWave = shotWaveIter.next();
            shotWave.getWave().setCurrentTime(this.getTime() + 1L);
            if (!shotWave.getWave().hasReached(this.enemyLocation, 10.0)) continue;
            shotWaveIter.remove();
            shotWave.setHitPoint(this.enemyLocation);
            shotWaveResults.add(shotWave);
        }
    }

    private void fireGunIfPointingAtEnemy() {
        this.haveFired = this.getGunTurnRemaining() == 0.0 && this.getGunHeat() == 0.0;
        if (this.haveFired) {
            this.setFire(this.enemyScanInfo.getEnergy() == 0.0 || this.getEnergy() < 3.75 ? 0.1 : 3.0);
        }
    }

    private void sendFullPowerShotWave() {
        if (this.haveFired || this.getTime() % (long)(this.getRoundNum() + 1) == 0L) {
            this.shotWaves.add(new ShotWave(this.startingConditionNow, new Wave(this.myLocation, Rules.getBulletSpeed((double)3.0), this.getTime())));
        }
    }

    private void pointGunAtEnemy() {
        this.shootingTargetLocation = this.enemyLocation;
        if (this.enemyScanInfo.getEnergy() > 0.0) {
            this.predictShootingTargetFromHistory();
        }
        this.setTurnGunRight(Bearing.getRightTurnBetween(this.getGunHeading(), this.myLocation.getBearingTowards(this.shootingTargetLocation)));
    }

    private void predictShootingTargetFromHistory() {
        double bestScore = 10.0;
        ShotWave bestShotWave = null;
        for (ShotWave shotWave : shotWaveResults) {
            double score = this.startingConditionNow.compareWith(shotWave.getStartingCondition());
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestShotWave = shotWave;
        }
        if (bestShotWave != null) {
            this.shootingTargetLocation = bestShotWave.getRelativeHitPoint(this.enemyLocation);
        }
    }
}

