/*
 * Decompiled with CFR 0.152.
 */
package xander.core.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.util.List;
import xander.core.Resources;
import xander.core.event.Painter;
import xander.core.math.RCMath;
import xander.core.track.BulletShadow;
import xander.core.track.Wave;

public abstract class WavePainter
implements Painter {
    private Color waveLeadingColor;
    private Color wavePassingColor;
    private Color bulletShadowColor;

    public WavePainter(Color waveLeadingColor, Color wavePassingColor, Color bulletShadowColor) {
        this.waveLeadingColor = waveLeadingColor;
        this.wavePassingColor = wavePassingColor;
        this.bulletShadowColor = bulletShadowColor;
    }

    protected abstract List<? extends Wave> getWaves();

    @Override
    public void onPaint(Graphics2D g) {
        long time = Resources.getTime();
        List<? extends Wave> waves = this.getWaves();
        for (Wave wave : waves) {
            if (wave.isPassed()) continue;
            Color color = wave.isLeading() ? this.waveLeadingColor : this.wavePassingColor;
            g.setColor(color);
            double r = wave.getBulletTravelDistance(time);
            double x = wave.getOriginX() - r;
            double y = wave.getOriginY() - r;
            double d = 2.0 * r;
            Ellipse2D.Double waveCircle = new Ellipse2D.Double(x, y, d, d);
            g.draw(waveCircle);
            g.setColor(this.bulletShadowColor);
            Stroke s = g.getStroke();
            g.setStroke(new BasicStroke(2.0f));
            for (BulletShadow shadow : wave.getBulletShadows()) {
                double cwa = RCMath.convertDegrees(shadow.getClockwiseAngle());
                double extent = Math.abs(RCMath.getTurnAngle(shadow.getClockwiseAngle(), shadow.getCounterClockwiseAngle()));
                Arc2D.Double shadowArc = RCMath.getYAxisInvertedArc(x, y, d, d, cwa, extent, 0);
                g.draw(shadowArc);
            }
            if (s == null) continue;
            g.setStroke(s);
        }
    }
}

