/*
 * Decompiled with CFR 0.152.
 */
package apc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class LeeroyJenkins2
extends AdvancedRobot {
    private int radarDirection = 1;
    Hashtable<String, EnemyList> enemiesHash = new Hashtable();
    private int ACTIVITY_AREA_MARGIN = 40;
    private int FIELD_OF_VISION = 80;
    private int DANGER_DISTANCE = this.FIELD_OF_VISION * 2;
    private Rectangle activityArea;
    private int direction = 1;
    private int fireX = 0;
    private int fireY = 0;
    private int currentEnemyX = 0;
    private int currentEnemyY = 0;
    private String currentEnemyName = null;
    private int scannedCount = 0;
    private static final int Min = 15;
    private static final int Max = 130;
    private Collection<Point2D.Double> enemies;
    private boolean hitWall = false;

    public void run() {
        this.setBodyColor(new Color(30, 44, 50));
        this.setGunColor(new Color(50, 100, 20));
        this.setRadarColor(new Color(200, 100, 70));
        this.setScanColor(Color.white);
        this.setBulletColor(Color.yellow);
        this.activityArea = new Rectangle(this.ACTIVITY_AREA_MARGIN, this.ACTIVITY_AREA_MARGIN, (int)this.getBattleFieldWidth() - this.ACTIVITY_AREA_MARGIN * 2, (int)this.getBattleFieldHeight() - this.ACTIVITY_AREA_MARGIN * 2);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        this.setTurnRadarRight(360.0);
        this.setTurnGunRight(360.0);
        while (true) {
            if (this.getGunHeat() / this.getGunCoolingRate() < 4.0) {
                this.fireAtEnemy();
            }
            this.Move();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy enemy = new Enemy();
        double absBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyX = this.getX() + e.getDistance() * Math.sin(absBearing);
        double enemyY = this.getY() + e.getDistance() * Math.cos(absBearing);
        enemy.setBearing(e.getBearing());
        enemy.setBearingRadians(e.getBearingRadians());
        enemy.setX(enemyX);
        enemy.setY(enemyY);
        enemy.setAbsBearing(absBearing);
        enemy.setVelocity(e.getVelocity());
        enemy.setDistance(e.getDistance());
        enemy.setHeadingRadians(e.getHeadingRadians());
        enemy.setTime(this.getTime());
        enemy.setHeading(e.getHeading());
        enemy.setName(e.getName());
        enemy.setEnergy(e.getEnergy());
        double movement = e.getVelocity() * Math.sin(e.getHeadingRadians() - (e.getBearingRadians() + this.getHeadingRadians()));
        EnemyList enemyList = this.enemiesHash.get(e.getName());
        if (enemyList != null) {
            enemyList.addEnemy(enemy);
        } else {
            enemyList = new EnemyList();
            enemyList.addEnemy(enemy);
            enemyList.setListName(e.getName());
        }
        enemyList.addToPatternMatcher(movement);
        enemyList.setArcLengthValue(movement);
        this.enemiesHash.put(e.getName(), enemyList);
        if (this.currentEnemyName != null && this.getGunHeat() / this.getGunCoolingRate() < 4.0 && this.getOthers() > 1) {
            double sweepAngle;
            Enemy targetEnemy = this.enemiesHash.get(this.currentEnemyName).getPositions().peekFirst();
            double relAngle = Utils.normalRelativeAngle((double)(targetEnemy.getAbsBearing() - this.getRadarHeadingRadians()));
            double d = sweepAngle = this.getOthers() == 0 ? 0.7853981633974483 : 0.3490658503988659;
            relAngle = relAngle >= 0.0 ? (relAngle += sweepAngle) : (relAngle -= sweepAngle);
            this.setTurnRadarRightRadians(relAngle);
            this.setScanColor(Color.red);
        }
    }

    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition() instanceof RadarTurnCompleteCondition) {
            this.sweep();
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        this.out.println("Hit another robot called " + e.getName());
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.out.println("Enemy has died name=" + e.getName());
        this.enemiesHash.remove(e.getName());
        if (e.getName().equals(this.currentEnemyName)) {
            this.currentEnemyName = null;
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.hitWall = true;
        this.out.println("Hit the wall");
    }

    public void onPaint(Graphics2D g) {
        for (EnemyList lastSeenEnemyList : this.enemiesHash.values()) {
            Enemy LatestSeen = lastSeenEnemyList.getPositions().peekFirst();
            g.setColor(Color.green);
            if (LatestSeen != null) {
                g.drawRect((int)LatestSeen.getX() - 16, (int)LatestSeen.getY() - 16, 36, 36);
            }
            ListIterator itr = lastSeenEnemyList.getPositions().listIterator();
            g.setColor(Color.yellow);
            while (itr.hasNext()) {
                Enemy tmp = (Enemy)itr.next();
                if (tmp == null) continue;
                g.drawRect((int)tmp.getX() - 2, (int)tmp.getY() - 2, 3, 3);
            }
        }
        g.setColor(Color.yellow);
        g.drawOval(this.fireX - 10, this.fireY - 10, 20, 20);
        g.setColor(Color.white);
        g.drawRect(this.currentEnemyX - 5, this.currentEnemyY - 5, 10, 10);
        Collection<EDMPoint> points = this.getPoints(this.FIELD_OF_VISION, this.enemies);
        double maxAvgDist = 0.0;
        double minAvgDist = 9999999.0;
        for (EDMPoint p : points) {
            if (p.avgDistance < minAvgDist) {
                minAvgDist = p.avgDistance;
            }
            if (!(p.avgDistance > maxAvgDist)) continue;
            maxAvgDist = p.avgDistance;
        }
        for (EDMPoint rp : points) {
            int radius = 4;
            int gb = (int)(255.0 * (rp.avgDistance - minAvgDist) / (maxAvgDist - minAvgDist));
            if (gb < 0) {
                gb = 0;
            } else if (gb > 255) {
                gb = 255;
            }
            g.setColor(new Color(255, gb, gb));
            g.fillOval((int)Math.round(rp.x - (double)(radius / 2)), (int)Math.round(rp.y - (double)(radius / 2)), radius, radius);
            if (rp.avgDistance != maxAvgDist) continue;
            radius = 6;
            g.drawOval((int)Math.round(rp.x - (double)(radius / 2)), (int)Math.round(rp.y - (double)(radius / 2)), radius, radius);
        }
        g.setColor(Color.BLUE);
        int fieldOfVisionRadius = this.DANGER_DISTANCE * 2;
        g.drawOval((int)this.getX() - fieldOfVisionRadius / 2, (int)this.getY() - fieldOfVisionRadius / 2, fieldOfVisionRadius, fieldOfVisionRadius);
    }

    private void Move() {
        Point2D.Double gotoPoint;
        Iterator<EnemyList> iterator = this.enemiesHash.values().iterator();
        ArrayList<Point2D.Double> list = new ArrayList<Point2D.Double>();
        Enemy closestEnemy = null;
        double closestDist = 1000000.0;
        if (this.currentEnemyName != null) {
            closestEnemy = this.enemiesHash.get(this.currentEnemyName).getPositions().peekFirst();
        }
        while (iterator.hasNext()) {
            EnemyList lastSeenEnemy = iterator.next();
            Enemy tmp = lastSeenEnemy.getPositions().peekFirst();
            if (tmp == null) continue;
            double enemyX = tmp.getX();
            double enemyY = tmp.getY();
            list.add(new Point2D.Double(enemyX, enemyY));
        }
        this.enemies = list;
        if (this.getOthers() == 1) {
            this.FIELD_OF_VISION = 100;
            this.ACTIVITY_AREA_MARGIN = 100;
            this.DANGER_DISTANCE = this.FIELD_OF_VISION * 3;
        }
        if ((gotoPoint = this.getDestination(list)) == null) {
            if (closestEnemy != null && this.getTime() - closestEnemy.getTime() < 25L) {
                ++this.scannedCount;
                if (this.scannedCount > 15 + (int)(Math.random() * 116.0) || this.hitWall) {
                    this.direction = this.direction == 1 ? -1 : 1;
                    this.scannedCount = 0;
                    this.hitWall = false;
                }
                double absBearing = closestEnemy.absBearing;
                double goalDirection = 0.5 + absBearing - 1.5707963267948966 * (double)this.direction;
                Rectangle2D.Double fieldRect = new Rectangle2D.Double(36.0, 36.0, this.getBattleFieldWidth() - 54.0, this.getBattleFieldHeight() - 54.0);
                while (!fieldRect.contains(this.getX() + Math.sin(goalDirection) * 220.0, this.getY() + Math.cos(goalDirection) * 220.0)) {
                    goalDirection += (double)this.direction * (-Math.random() / 2.0);
                }
                double turn = Utils.normalRelativeAngle((double)(goalDirection - this.getHeadingRadians()));
                if (Math.abs(turn) > 1.5707963267948966) {
                    turn = Utils.normalRelativeAngle((double)(turn + Math.PI));
                    this.setBack(100.0);
                } else {
                    this.setAhead(100.0);
                }
                this.setTurnRightRadians(turn);
                if (this.getTime() - closestEnemy.getTime() >= 23L) {
                    this.currentEnemyName = null;
                }
            } else if (this.getOthers() == 1) {
                this.goTo(36.0 + (this.getBattleFieldWidth() - 54.0) / 2.0, 36.0 + (this.getBattleFieldHeight() - 54.0) / 2.0);
            }
        } else {
            this.goTo(gotoPoint.x, gotoPoint.y);
        }
    }

    private void goTo(double destinationX, double destinationY) {
        double angle = Utils.normalRelativeAngle((double)(Math.atan2(destinationX -= this.getX(), destinationY -= this.getY()) - this.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.setTurnRightRadians(turnAngle);
        this.setAhead(Math.hypot(destinationX, destinationY) * (double)(angle == turnAngle ? 1 : -1));
    }

    public Point2D.Double getDestination(Collection<Point2D.Double> enemies) {
        Collection<EDMPoint> points = this.getPoints(this.FIELD_OF_VISION, enemies);
        double maxAvgDist = 0.0;
        EDMPoint destination = null;
        for (EDMPoint p : points) {
            double avgDist = this.calculateAvgDistance(p, enemies);
            if (!(avgDist > maxAvgDist)) continue;
            maxAvgDist = avgDist;
            destination = p;
        }
        return destination;
    }

    private Collection<EDMPoint> getPoints(double dist, Collection<Point2D.Double> enemies) {
        LinkedList<EDMPoint> points = new LinkedList<EDMPoint>();
        Point2D.Double myPos = new Point2D.Double(this.getX(), this.getY());
        double angle = 0.0;
        while (angle < Math.PI * 2) {
            EDMPoint p = new EDMPoint(myPos.x + Math.sin(angle) * dist, myPos.y + Math.cos(angle) * dist);
            if (this.activityArea.contains(p)) {
                p.avgDistance = this.calculateAvgDistance(p, enemies);
                points.add(p);
            }
            angle += 0.3490658503988659;
        }
        return points;
    }

    private double calculateAvgDistance(Point2D.Double point, Collection<Point2D.Double> enemies) {
        double distanceSum = 0.0;
        int closeEnemyCount = 0;
        for (Point2D.Double p : enemies) {
            double distance = p.distance(point);
            if (p.distance(this.getX(), this.getY()) > (double)this.DANGER_DISTANCE) continue;
            distanceSum += distance;
            ++closeEnemyCount;
        }
        return distanceSum / (double)(closeEnemyCount > 0 ? closeEnemyCount : 1);
    }

    private void fireAtEnemy() {
        Enemy closestEnemy = this.getClosestEnemy();
        if (closestEnemy == null) {
            closestEnemy = this.getWeakestEnemy();
        }
        if (closestEnemy != null) {
            double energy = this.getEnergy();
            double distance = closestEnemy.getDistance();
            double bulletPower = 3.0;
            if (distance > 110.0) {
                bulletPower = 2.5;
            }
            if (energy < 55.0 || distance > 180.0) {
                bulletPower = 2.0;
            }
            if (energy < 25.0 || distance > 500.0) {
                bulletPower = 1.4;
            }
            if (energy < 10.0 || distance > 800.0) {
                bulletPower = 0.8;
            }
            if (energy < 7.0) {
                bulletPower = 0.3;
            }
            this.currentEnemyName = closestEnemy.getName();
            if (this.getOthers() < 2) {
                EnemyList enemyList = this.enemiesHash.get(this.currentEnemyName);
                StringBuffer patternMatcher = enemyList.getPatternMatcher();
                double[] arcLength = enemyList.getArcLength();
                int matchIndex = 0;
                int historyIndex = patternMatcher.length();
                int searchDepth = 20;
                double targetBearing = closestEnemy.getBearingRadians() + this.getHeadingRadians();
                while ((matchIndex = patternMatcher.lastIndexOf(patternMatcher.substring(historyIndex - --searchDepth), historyIndex - 80)) < 0) {
                }
                this.setTurnGunRightRadians(Math.sin((arcLength[(matchIndex += searchDepth) + (int)(closestEnemy.getDistance() / (20.0 - 3.0 * bulletPower))] - arcLength[matchIndex]) / closestEnemy.getDistance() + targetBearing - this.getGunHeadingRadians()));
                if (this.getGunHeat() == 0.0 && this.getEnergy() > bulletPower + 0.1 && this.getTime() - closestEnemy.getTime() < 10L) {
                    this.setFire(bulletPower);
                }
            } else {
                EnemyList enemyList = this.enemiesHash.get(closestEnemy.getName());
                double absBearing = closestEnemy.getBearingRadians() + this.getHeadingRadians();
                double myX = this.getX();
                double myY = this.getY();
                double enemyX = this.getX() + closestEnemy.getDistance() * Math.sin(absBearing);
                double enemyY = this.getY() + closestEnemy.getDistance() * Math.cos(absBearing);
                double enemyHeading = closestEnemy.getHeadingRadians();
                double gunHeading = this.getGunHeadingRadians();
                double enemyVelocity = closestEnemy.getVelocity();
                double oldEnemyHeading = enemyHeading;
                try {
                    oldEnemyHeading = enemyList.getPositions().get(1).getHeadingRadians();
                }
                catch (Exception e) {
                    this.out.println("Doh " + e.getMessage());
                }
                double enemyHeadingChange = enemyHeading - oldEnemyHeading;
                double deltaTime = 0.0;
                double battleFieldHeight = this.getBattleFieldHeight();
                double battleFieldWidth = this.getBattleFieldWidth();
                double predictedX = enemyX;
                double predictedY = enemyY;
                while ((deltaTime += 1.0) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
                    predictedY += Math.cos(enemyHeading) * enemyVelocity;
                    if (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
                    predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
                    predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
                    break;
                }
                this.fireX = (int)predictedX;
                this.fireY = (int)predictedY;
                this.currentEnemyX = (int)enemyX;
                this.currentEnemyY = (int)enemyY;
                double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
                if (this.getGunHeat() == 0.0 && this.getEnergy() > bulletPower + 0.1 && Math.abs(theta - gunHeading) < 0.12) {
                    this.setFire(bulletPower);
                    this.currentEnemyName = null;
                }
            }
        }
    }

    private Enemy getClosestEnemy() {
        Iterator<EnemyList> iterator = this.enemiesHash.values().iterator();
        Enemy closestEnemy = null;
        double closestDist = 1000000.0;
        while (iterator.hasNext()) {
            EnemyList lastSeenEnemy = iterator.next();
            Enemy tmp = lastSeenEnemy.getPositions().peekFirst();
            if (tmp == null) continue;
            if (closestEnemy == null) {
                closestDist = tmp.getDistance();
                closestEnemy = tmp;
                continue;
            }
            if (!(closestDist > tmp.getDistance())) continue;
            closestDist = tmp.getDistance();
            closestEnemy = tmp;
        }
        if (closestDist > 1000.0) {
            return null;
        }
        return closestEnemy;
    }

    private Enemy getWeakestEnemy() {
        Iterator<EnemyList> iterator = this.enemiesHash.values().iterator();
        Enemy weakestEnemy = null;
        double lowestEnergy = 1000000.0;
        while (iterator.hasNext()) {
            EnemyList lastSeenEnemy = iterator.next();
            Enemy tmp = lastSeenEnemy.getPositions().peekFirst();
            if (tmp == null) continue;
            if (weakestEnemy == null) {
                lowestEnergy = tmp.getEnergy();
                weakestEnemy = tmp;
                continue;
            }
            if (!(lowestEnergy > tmp.getEnergy())) continue;
            lowestEnergy = tmp.getEnergy();
            weakestEnemy = tmp;
        }
        return weakestEnemy;
    }

    private void sweep() {
        int scannedBots = 0;
        Enemy oldestEnemy = null;
        long oldestTime = 1000000L;
        double relAngle = 0.0;
        this.setScanColor(Color.white);
        for (EnemyList lastSeenEnemy : this.enemiesHash.values()) {
            Enemy tmp = lastSeenEnemy.getPositions().peekFirst();
            if (tmp == null) continue;
            if (oldestEnemy == null) {
                oldestEnemy = tmp;
                oldestTime = tmp.getTime();
            } else if (oldestTime > tmp.getTime()) {
                oldestTime = tmp.getTime();
                oldestEnemy = tmp;
            }
            ++scannedBots;
        }
        if (scannedBots == this.getOthers() && oldestEnemy != null && oldestEnemy.isUpdated(this.getTime())) {
            double sweepAngle;
            relAngle = Utils.normalRelativeAngle((double)(oldestEnemy.getAbsBearing() - this.getRadarHeadingRadians()));
            double d = sweepAngle = this.getOthers() == 0 ? 0.7853981633974483 : 0.3490658503988659;
            relAngle = relAngle >= 0.0 ? (relAngle += sweepAngle) : (relAngle -= sweepAngle);
            this.setTurnRadarRightRadians(relAngle);
        } else {
            this.setTurnRadarRight(180 * this.radarDirection);
        }
        this.radarDirection = this.sign(relAngle);
    }

    private int sign(double bearing) {
        return bearing > 0.0 ? 1 : -1;
    }

    public class EDMPoint
    extends Point2D.Double {
        private static final long serialVersionUID = -7459563255893588792L;
        public double avgDistance;
        public double absBearing;
        public double getHeadingRadians;
        public double getVelocity;

        public EDMPoint(double x, double y) {
            super(x, y);
        }
    }

    public class Enemy {
        private static final long serialVersionUID = -7459563255893588792L;
        public double distance;
        public double bearing;
        public double bearingRadians;
        public double absBearing;
        public double headingRadians;
        public double heading;
        public double velocity;
        public long time;
        public double x;
        public double y;
        public String name;
        public double energy;

        public Enemy(double x, double y) {
            this.setX(x);
            this.setY(y);
        }

        public Enemy() {
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double distance) {
            this.distance = distance;
        }

        public double getBearing() {
            return this.bearing;
        }

        public void setBearing(double bearing) {
            this.bearing = bearing;
        }

        public double getBearingRadians() {
            return this.bearingRadians;
        }

        public void setBearingRadians(double bearingRadians) {
            this.bearingRadians = bearingRadians;
        }

        public double getAbsBearing() {
            return this.absBearing;
        }

        public void setAbsBearing(double absBearing) {
            this.absBearing = absBearing;
        }

        public double getHeadingRadians() {
            return this.headingRadians;
        }

        public void setHeadingRadians(double headingRadians) {
            this.headingRadians = headingRadians;
        }

        public double getHeading() {
            return this.heading;
        }

        public void setHeading(double heading) {
            this.heading = heading;
        }

        public double getVelocity() {
            return this.velocity;
        }

        public void setVelocity(double velocity) {
            this.velocity = velocity;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getEnergy() {
            return this.energy;
        }

        public void setEnergy(double energy) {
            this.energy = energy;
        }

        public boolean isUpdated(long robotTime) {
            return robotTime - this.time <= 10L;
        }
    }

    public class EnemyList
    extends LinkedList<Enemy> {
        private static final long serialVersionUID = 1L;
        private LinkedList<Enemy> positions = new LinkedList();
        private StringBuffer patternMatcher = new StringBuffer("\u0000\u0003\u0006\u0001\u0004\u0007\u0002\u0005\b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
        double[] arcLength = new double[100000];
        private String listName;

        public String getListName() {
            return this.listName;
        }

        public void setListName(String listName) {
            this.listName = listName;
        }

        public LinkedList<Enemy> getPositions() {
            return this.positions;
        }

        public boolean addEnemy(Enemy e) {
            if (e != null) {
                this.positions.push(e);
                if (this.positions.size() > 10) {
                    this.positions.removeLast();
                }
            }
            return false;
        }

        public void addToPatternMatcher(double movement) {
            this.patternMatcher.append((char)movement);
        }

        public StringBuffer getPatternMatcher() {
            return this.patternMatcher;
        }

        public double[] getArcLength() {
            return this.arcLength;
        }

        public void setArcLengthValue(double movement) {
            int historyIndex = this.patternMatcher.length();
            this.arcLength[historyIndex + 1] = this.arcLength[historyIndex] + movement;
        }
    }
}

