/*
 * Decompiled with CFR 0.152.
 */
package jaybot.guns;

import java.awt.geom.Point2D;
import jaybot.bots.BaseBot;
import jaybot.guns.BaseGun;
import jaybot.guns.FiringSolution;
import jaybot.guns.Gun;
import jaybot.guns.TargetFocus;
import jaybot.intel.Enemy;

public class LagTargetting
extends BaseGun {
    public static final String GUN_NAME = "Lag";
    private static LagTargetting _$2133 = new LagTargetting();

    public String getGunName() {
        return GUN_NAME;
    }

    public static Gun getInternalInstance() {
        return _$2133;
    }

    public FiringSolution buildFiringSolution(BaseBot myBot, Enemy badGuy, double powerOverride) {
        if (!(myBot instanceof TargetFocus)) {
            throw new RuntimeException("Cannot use the " + this.getClass().getName() + " gun with a bot that does not implement TargetFocus");
        }
        TargetFocus focus = (TargetFocus)((Object)myBot);
        Enemy currentTarget = badGuy;
        double minShotPower = 0.0;
        double shotPower = 0.0;
        Point2D meetingSpot = currentTarget.getLastPosition();
        double d = minShotPower = focus.getAimingPosition().distance(meetingSpot) < focus.getSweetSpotForDistance() + 15.0 ? 2.5 : 1.5;
        if (currentTarget.getMovementReliability() > 1 || focus.getAimingPosition().distance(meetingSpot) < 100.0) {
            minShotPower = 3.0;
        }
        minShotPower = Math.min(currentTarget.getLastKnownEnergy() / 4.0, minShotPower);
        if (powerOverride != Double.NEGATIVE_INFINITY) {
            minShotPower = powerOverride;
        }
        double trackTime = 0.0;
        double gunTurnAmount = 0.0;
        double shotBearing = 0.0;
        do {
            meetingSpot = BaseBot.projectPointInSpace(meetingSpot, currentTarget.getLastKnownHeading() + (trackTime += 1.0) * currentTarget.getEstimatedTurnPerTickDegrees(), currentTarget.getEstimatedMovementPerTick());
            shotBearing = myBot.headingToBearingDegrees(BaseBot.getAngleBetweenPointsInDegrees(focus.getAimingPosition(), meetingSpot));
            gunTurnAmount = myBot.getGunTraversalNeededInDegreesToBearing(shotBearing);
            double gunTurnTime = Math.round(Math.abs(gunTurnAmount) / 20.0);
            shotPower = (20.0 - focus.getAimingPosition().distance(meetingSpot) / Math.max(1.0, trackTime - gunTurnTime)) / 3.0;
            if (currentTarget.getEstimatedMovementPerTick() < 0.1 && currentTarget.getMovementReliability() > 0) {
                shotPower = 3.0;
            }
            if (myBot.nearWall(meetingSpot, 0.0)) {
                shotPower += 1.0;
                break;
            }
            if (!(myBot.getEnergy() < shotPower + 0.1)) continue;
            shotPower = myBot.getEnergy() - 0.1;
            break;
        } while (shotPower < minShotPower);
        if (powerOverride != Double.NEGATIVE_INFINITY) {
            shotPower = powerOverride;
        }
        if (shotPower > -5.0) {
            FiringSolution solution = new FiringSolution(this.getGunName(), currentTarget.getName(), shotBearing, focus.getAimingPosition().distance(meetingSpot), shotPower);
            solution.setAimPoint(meetingSpot);
            return solution;
        }
        return null;
    }

    public FiringSolution buildFiringSolution(BaseBot myBot, Enemy badGuy) {
        return this.buildFiringSolution(myBot, badGuy, Double.NEGATIVE_INFINITY);
    }
}

