/*
 * Decompiled with CFR 0.152.
 */
package dk;

import dk.Base;
import dk.BattleField;
import dk.Histogram;
import dk.Point;
import dk.Util;
import dk.predict.EnemyPositionPredictor;
import dk.predict.Predictor;
import java.io.PrintStream;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class Enemy {
    private transient boolean alive;
    private transient double energy;
    private transient double heading;
    private transient double headingChange;
    private transient double acceleration;
    private transient long lastDirectionChange;
    private transient int lastDirection;
    private transient double velocity;
    private transient long lastHit;
    private transient long lastFired;
    private transient double damaged;
    private static final double decayRate = Util.halfLifeDecayRate(4L);
    private transient double averageHeading;
    private transient double averageVelocity;
    private transient double averageAcceleration;
    private transient double averageHeadingChange;
    static final int velocityBuckets = 10;
    static final int headingChangeBuckets = 5;
    static final int directionChangeBuckets = 40;
    static final int directionChangeMaxTime = 200;
    private Histogram accelerationStats = new Histogram(3);
    private Histogram velocityStats = new Histogram(10);
    private Histogram headingChangeStats = new Histogram(5);
    private Histogram directionChangeStats = new Histogram(40);
    private int hitByCount;
    private int shotsAttempted;
    private int shotsHit;
    private int diedFirstCount;
    private transient long lastSeen;
    private transient Point position;
    private String name_;
    private EnemyPositionPredictor positionPredictor;
    public Histogram meleeConfigHistogram;

    public Enemy(String name) {
        this.name_ = name;
    }

    public void countFireAttempt() {
        ++this.shotsAttempted;
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public double getDamaged() {
        return this.damaged;
    }

    public int getDiedFirstCount() {
        return this.diedFirstCount;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getEstimatedHitRate() {
        if (this.shotsAttempted < 10) {
            return 0.5;
        }
        return (double)this.shotsHit / (double)this.shotsAttempted;
    }

    public Point getEstimatedPosition(long time) {
        if (this.position == null) {
            return null;
        }
        return Util.applyHeading(this.getPosition(), this.getHeading(), this.getVelocity() * (double)(time - this.getLastSeen()));
    }

    public double getHeading() {
        return this.heading;
    }

    public double getHeadingChange() {
        return this.headingChange;
    }

    public int getHitByCount() {
        return this.hitByCount;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public String getName() {
        return this.name_;
    }

    public Point getPosition() {
        if (this.position == null) {
            return Point.ZERO;
        }
        return this.position;
    }

    public EnemyPositionPredictor getPositionPredictor() {
        return this.positionPredictor;
    }

    public Predictor getPositionPredictor(Base r, double power) {
        if (this.positionPredictor == null) {
            return null;
        }
        return this.positionPredictor.getBestPredictor(r, this, power);
    }

    public Histogram.Bucket getPositionPredictorBucket(Base r, double power) {
        if (this.positionPredictor == null) {
            return null;
        }
        return this.positionPredictor.getBestPredictorBucket(r, this, power);
    }

    public int getShotsAttempted() {
        return this.shotsAttempted;
    }

    public int getShotsHit() {
        return this.shotsHit;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public boolean isAlive() {
        if (this.position == null) {
            return false;
        }
        return this.alive;
    }

    public void onBulletHit(Base robot, BulletHitEvent e) {
        double power = e.getBullet().getPower();
        double damage = Util.bulletDamage(power);
        this.damaged += damage;
        ++this.shotsHit;
        this.lastHit = robot.getTime();
    }

    public void onHitByBullet(Base robot, HitByBulletEvent e) {
        ++this.hitByCount;
    }

    public void onRobotDeathEvent(Base robot, RobotDeathEvent e) {
        this.alive = false;
        ++this.diedFirstCount;
    }

    public void onRobotScannedEvent(Base robot, ScannedRobotEvent e) {
        double energyDifference;
        Base r = BattleField.r;
        long now = r.getTime();
        long time = now - this.lastSeen;
        if (time < 10L && time > 0L) {
            this.acceleration = (e.getVelocity() - this.velocity) / (double)time;
            this.headingChange = Util.normalizeBearing((e.getHeadingRadians() - this.heading) / (double)time);
            if (this.velocity != 0.0 && Util.sign(e.getVelocity()) != Util.sign(this.lastDirection)) {
                if (this.lastDirectionChange != 0L && now - this.lastDirectionChange > 5L) {
                    long directionTime = now - this.lastDirectionChange;
                    this.directionChangeStats.recordSuccess(Util.indexFromValue(directionTime, 40, 0.0, 200.0));
                }
                this.lastDirectionChange = now;
                this.lastDirection = Util.sign(e.getVelocity());
            }
        } else {
            this.acceleration = 0.0;
            this.headingChange = 0.0;
            this.lastDirectionChange = 0L;
            this.lastDirection = 1;
        }
        if ((energyDifference = this.energy - e.getEnergy()) > 0.0 && energyDifference <= 3.0) {
            this.lastFired = now;
            robot.onEnemyBulletFired(this, energyDifference);
        } else if (energyDifference > 3.0) {
            this.lastHit = now;
        }
        this.lastSeen = now;
        this.alive = true;
        this.position = Util.applyHeading(r.getPosition(), e.getBearingRadians() + r.getHeadingRadians(), e.getDistance());
        this.heading = e.getHeadingRadians();
        this.velocity = e.getVelocity();
        this.energy = e.getEnergy();
        this.accelerationStats.recordSuccess(1 + Util.sign(this.acceleration));
        this.velocityStats.recordSuccess(Util.indexFromValue(this.velocity, 10, -8.0, 8.0));
        this.headingChangeStats.recordSuccess(Util.indexFromValue(this.headingChange, 5, -Base.MAX_TURN_RATE, Base.MAX_TURN_RATE));
        this.averageHeading = Util.timeWeightedAverage(this.heading, this.averageHeading, time, decayRate);
        this.averageVelocity = Util.timeWeightedAverage(this.velocity, this.averageVelocity, time, decayRate);
        this.averageAcceleration = Util.timeWeightedAverage(this.acceleration, this.averageAcceleration, time, decayRate);
        this.averageHeadingChange = Util.timeWeightedAverage(this.headingChange, this.averageHeadingChange, time, decayRate);
    }

    public void printStats(PrintStream out) {
        out.println("name = " + this.name_);
        out.println("hitByCount = " + this.hitByCount);
        out.println("diedFirst = " + this.diedFirstCount);
        out.println("shotAttempted = " + this.shotsAttempted);
        out.println("shotsHit = " + this.shotsHit + " (" + this.getEstimatedHitRate() + ")");
        out.println("damaged = " + this.damaged);
        if (this.positionPredictor != null && Base.dumpPrediction) {
            this.positionPredictor.printBuckets(out);
        }
    }

    public void reset() {
        this.alive = true;
        this.lastHit = this.lastSeen = -100000L;
        this.lastFired = this.lastSeen;
        this.position = null;
        this.heading = 0.0;
        this.velocity = 0.0;
        this.damaged = 0.0;
        this.acceleration = 0.0;
        this.headingChange = 0.0;
        this.lastDirectionChange = 0L;
        this.lastDirection = 1;
    }

    public void setAlive(boolean b) {
        this.alive = b;
    }

    public void setPositionPredictor(EnemyPositionPredictor predictor) {
        this.positionPredictor = predictor;
    }

    public String toString() {
        return this.name_;
    }

    public long getLastDirectionChange() {
        return this.lastDirectionChange;
    }

    public long getRandomChangeDirectionTimestamp() {
        long estimatedTimeBetweenChanges = this.getRandomChangeDirectionInterval();
        long howLongSinceLastChange = this.lastSeen - this.lastDirectionChange;
        return this.lastSeen + estimatedTimeBetweenChanges - howLongSinceLastChange;
    }

    public long getRandomChangeDirectionInterval() {
        int estimatedTimeBetweenChanges = (int)Util.valueFromIndex(this.directionChangeStats.getRandomIndex(), 40, 0.0, 200.0);
        return estimatedTimeBetweenChanges;
    }

    public double getRandomAcceleration() {
        return (double)this.accelerationStats.getRandomIndex() - 1.0;
    }

    public double getRandomVelocity() {
        return Util.valueFromIndex(this.velocityStats.getRandomIndex(), 10, -8.0, 8.0);
    }

    public double getRandomHeadingChange() {
        return Util.valueFromIndex(this.headingChangeStats.getRandomIndex(), 5, -Base.MAX_TURN_RATE, Base.MAX_TURN_RATE);
    }

    public double getAverageAcceleration() {
        return this.averageAcceleration;
    }

    public double getAverageHeading() {
        return this.averageHeading;
    }

    public double getAverageHeadingChange() {
        return this.averageHeadingChange;
    }

    public double getAverageVelocity() {
        return this.averageVelocity;
    }

    public long getLastFired() {
        return this.lastFired;
    }

    public long getLastHit() {
        return this.lastHit;
    }
}

