/*
 * Decompiled with CFR 0.152.
 */
package dk.predict.buckets;

import dk.Enemy;
import dk.Histogram;
import dk.Util;
import dk.predict.Buckets;
import dk.predict.Factors;
import java.io.PrintStream;
import java.util.List;

public class BucketsBulletRLVH
extends Buckets {
    protected int rangeBuckets = 10;
    protected int velocityBuckets = 8;
    protected int timeBuckets = 6;
    protected double maxRange = 100.0;
    protected double maxVelocity = 8.0;
    protected double maxTime = 30.0;
    protected Histogram[][][] buckets;

    public BucketsBulletRLVH(Enemy enemy, List predictorFactories) {
        super(enemy, predictorFactories);
        this.setupBuckets(predictorFactories);
    }

    public static Buckets.Factory factory() {
        return new Buckets.Factory(){

            public Buckets newInstance(Enemy enemy, List predictorFactories) {
                return new BucketsBulletRLVH(enemy, predictorFactories);
            }
        };
    }

    protected void setupBuckets(List predictorFactories) {
        this.buckets = new Histogram[this.rangeBuckets][this.velocityBuckets][this.timeBuckets];
        int r = 0;
        while (r < this.rangeBuckets) {
            int v = 0;
            while (v < this.velocityBuckets) {
                int t = 0;
                while (t < this.timeBuckets) {
                    this.buckets[r][v][t] = this.createHistogram(predictorFactories);
                    String name = "bucket br < " + Util.valueFromIndex(r, this.rangeBuckets, 0.0, this.maxRange) + " v < " + Util.valueFromIndex(v, this.velocityBuckets, -this.maxVelocity, this.maxVelocity) + " hit time < " + Util.valueFromIndex(t, this.timeBuckets, 0.0, this.maxTime);
                    this.buckets[r][v][t].setName(name);
                    ++t;
                }
                ++v;
            }
            ++r;
        }
    }

    public Histogram getHistogram(Factors f) {
        int r = Util.indexFromValue(f.getDistance(), this.rangeBuckets, 0.0, this.maxRange);
        double lateralVelocity = Util.lateralVelocity(f.getVelocity(), f.getHeading(), Util.bearing(f.getRobotPosition(), f.getPosition()));
        int v = Util.indexFromValue(lateralVelocity, this.velocityBuckets, -this.maxVelocity, this.maxVelocity);
        int t = Util.indexFromValue(f.getTimeSinceHit(), this.timeBuckets, 0.0, this.maxTime);
        return this.buckets[r][v][t];
    }

    public void printStats(PrintStream out) {
        super.printStats(out);
        int r = 0;
        while (r < this.rangeBuckets) {
            int v = 0;
            while (v < this.velocityBuckets) {
                int t = 0;
                while (t < this.timeBuckets) {
                    this.buckets[r][v][t].printStats(out);
                    ++t;
                }
                ++v;
            }
            ++r;
        }
    }
}

