/*
 * Decompiled with CFR 0.152.
 */
package origin;

import gun.BulletVector;
import gun.VirtualBullet;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import origin.EnemyData;
import origin.Util;

public class Enemy {
    private static final int BOT = 36;
    private static final int HALF_BOT = 18;
    private ArrayList<EnemyData> data = new ArrayList();
    private int currentIndex;
    private int bestGun = -1;
    private int[][] gunStats;
    private double energyLostThisTurn;
    private double energyGainedThisTurn;
    private LinkedList<VirtualBullet> virtualPointBullets = new LinkedList();
    private LinkedList<BulletVector> angleBullets = new LinkedList();
    private int numAddedID;
    private double closestDist;
    private boolean updatedWaves;

    public Enemy(EnemyData initialData, int[][] gunStats, int numAdded) {
        this.gunStats = gunStats;
        this.energyLostThisTurn = 0.0;
        this.energyGainedThisTurn = 0.0;
        this.numAddedID = numAdded;
        this.currentIndex = 0;
        this.data.add(this.currentIndex, initialData);
        this.closestDist = 2.147483647E9;
        this.updatedWaves = false;
    }

    public EnemyData getLatest() {
        return this.data.get(this.currentIndex);
    }

    public ArrayList<EnemyData> getDataSet() {
        return this.data;
    }

    public double getEnergy() {
        return this.data.get(this.currentIndex).getEnergy();
    }

    public double getBearing() {
        return this.data.get(this.currentIndex).getBearing();
    }

    public double getDistance() {
        return this.data.get(this.currentIndex).getDistance();
    }

    public double getHeading() {
        return this.data.get(this.currentIndex).getHeading();
    }

    public double getVelocity() {
        return this.data.get(this.currentIndex).getVelocity();
    }

    public long getTime() {
        return this.data.get(this.currentIndex).getTime();
    }

    public long timeSinceUpdate(long currentTime) {
        return this.getLatest().getAge(currentTime);
    }

    public double getX() {
        return this.data.get(this.currentIndex).getX();
    }

    public double getY() {
        return this.data.get(this.currentIndex).getY();
    }

    public Point2D.Double getLocation() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public double getLatestTurnRate() {
        if (this.data.size() > 1) {
            return this.data.get(this.currentIndex).getHeading() - this.data.get(this.currentIndex - 1).getHeading();
        }
        return 0.0;
    }

    public int getNumAddedID() {
        return this.numAddedID;
    }

    public void newRound(EnemyData initialData) {
        this.data = new ArrayList();
        this.virtualPointBullets = new LinkedList();
        this.angleBullets = new LinkedList();
        this.currentIndex = 0;
        this.data.add(this.currentIndex, initialData);
        this.energyLostThisTurn = 0.0;
        this.energyGainedThisTurn = 0.0;
    }

    public synchronized void addEnemyData(EnemyData newData) {
        ++this.currentIndex;
        this.data.add(this.currentIndex, newData);
    }

    public LinkedList<VirtualBullet> getVirtualPointBulletsSet() {
        return this.virtualPointBullets;
    }

    public double getCurrentBearing(Point2D.Double referencePoint) {
        double relX = this.getX() - referencePoint.getX();
        double relY = this.getY() - referencePoint.getY();
        return Math.atan(relX / relY);
    }

    public void updateGunStat(boolean hitOrMiss, int gunID) {
        int[] nArray = this.gunStats[gunID];
        nArray[1] = nArray[1] + 1;
        int[] nArray2 = this.gunStats[gunID];
        nArray2[0] = nArray2[0] + (hitOrMiss ? 1 : 0);
    }

    public int getBestGun() {
        this.bestGun = -1;
        double bestHitRate = -1.0;
        int i = 0;
        while (i < this.gunStats.length) {
            double currentHitRate = (double)this.gunStats[i][0] / (double)this.gunStats[i][1];
            if (currentHitRate > bestHitRate) {
                bestHitRate = currentHitRate;
                this.bestGun = i;
            }
            ++i;
        }
        return this.bestGun;
    }

    public int numEntries() {
        return this.data.size();
    }

    public EnemyData getPreviousData() {
        EnemyData output = null;
        output = this.currentIndex > 1 ? this.data.get(this.currentIndex - 1) : this.data.get(this.currentIndex);
        return output;
    }

    public void setEnergyLost(double power) {
        this.energyLostThisTurn = power;
    }

    public void setEnergyGained(double eGain) {
        this.energyGainedThisTurn = eGain;
    }

    public double getEnergyLostThisTurn() {
        return this.energyLostThisTurn;
    }

    public double getEnergyGainedThisTurn() {
        return this.energyGainedThisTurn;
    }

    public long getTimeSinceDecel() {
        return this.getLatest().getTimeSinceDecel();
    }

    public double getBestGunHitRate() {
        double bestHitRate = 0.0;
        int i = 0;
        while (i < this.gunStats.length) {
            double currentHitRate = (double)this.gunStats[i][0] / (double)this.gunStats[i][1];
            if (currentHitRate > bestHitRate) {
                bestHitRate = currentHitRate;
            }
            ++i;
        }
        return bestHitRate;
    }

    public Point2D.Double getPosition() {
        EnemyData latest = this.getLatest();
        return new Point2D.Double(this.getX(), this.getY());
    }

    public int getScanOrder() {
        return this.getLatest().getScanOrder();
    }

    public LinkedList<BulletVector> getVirtualAngleBulletsSet() {
        return this.angleBullets;
    }

    public long getRelativeAge(long time) {
        long relativeAge = this.getLatest().getAge(time) + (long)this.getScanOrder();
        return relativeAge;
    }

    public void setClosestDist(double diameter) {
        this.closestDist = diameter;
    }

    public double getClosestDist() {
        return this.closestDist;
    }

    public double getDistFromWall() {
        double[] bounds = Util.getAbsoluteFieldBoundsxXyY();
        double x = this.getX();
        double y = this.getY();
        double shortestDistance = Math.min(Math.min(Math.min(Point2D.distance(x, 0.0, bounds[0], 0.0), Point2D.distance(x, bounds[2], bounds[1], bounds[2])), Point2D.distance(0.0, y, 0.0, bounds[2])), Point2D.distance(bounds[1], y, bounds[1], bounds[3]));
        return shortestDistance;
    }

    public void setUpdatedWaves(boolean b) {
        this.updatedWaves = b;
    }

    public boolean getUpdatedWaves() {
        return this.updatedWaves;
    }
}

