/*
 * Decompiled with CFR 0.152.
 */
package brainfade.melee.utils;

import brainfade.melee.utils.PatternMatcher;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Enemy {
    public String name = "";
    public double energy = 100.0;
    public double heading = 0.0;
    public double velocity = 0.0;
    public double bearing = 0.0;
    public double distance = 1000.0;
    public Point2D position = new Point2D.Double(0.0, 0.0);
    public long scantime = 0L;
    public boolean isAlive = true;
    public double bulletVelocity = 16.5;
    public double firepower = 3.0;
    public long firetime = -150L;
    public double changehead = 0.0;
    public double last1 = 0.0;
    public double last2 = 0.0;
    public double last3 = 0.0;
    public double last4 = 0.0;
    public double last5 = 0.0;
    public double maxvelocity = 0.0;
    public double lastvelocity = 0.0;
    public long oscillatevelocity = 0L;
    public long[] oscillatevelocityhistory = new long[6];
    public long averageoscillate = 0L;
    Point2D.Double oTop = new Point2D.Double(0.0, 0.0);
    Point2D.Double oBottom = new Point2D.Double(0.0, 0.0);
    public long lastchange = 0L;
    public int lastsystem = 0;
    public PatternMatcher pm = null;
    AdvancedRobot AR;

    public void update(ScannedRobotEvent e, AdvancedRobot AR) {
        this.name = e.getName();
        this.AR = AR;
        this.distance = e.getDistance();
        this.changehead = Utils.normalAbsoluteAngle((double)(e.getHeadingRadians() - this.heading)) / (double)(AR.getTime() - this.scantime);
        this.heading = e.getHeadingRadians();
        this.lastvelocity = this.velocity;
        this.velocity = e.getVelocity();
        this.bearing = Utils.normalAbsoluteAngle((double)(e.getBearingRadians() + AR.getHeadingRadians()));
        this.scantime = AR.getTime();
        this.energy = e.getEnergy();
        this.position = this.vectorToLocation(this.bearing, this.distance, new Point2D.Double(AR.getX(), AR.getY()));
        double oldaverage = (this.last1 + this.last2 + this.last3 + this.last4 + this.last5) / 5.0;
        this.last5 = this.last4;
        this.last4 = this.last3;
        this.last3 = this.last2;
        this.last2 = this.last1;
        this.last1 = this.lastvelocity;
        double newaverage = (this.last1 + this.last2 + this.last3 + this.last4 + this.last5) / 5.0;
        if (oldaverage < 0.0 && newaverage > 0.0 || oldaverage > 0.0 && newaverage < 0.0) {
            if (oldaverage < 0.0 && newaverage > 0.0) {
                this.oTop = new Point2D.Double(this.position.getX(), this.position.getY());
            } else {
                this.oBottom = new Point2D.Double(this.position.getX(), this.position.getY());
            }
            long total = 0L;
            for (int i = 3; i > 1; --i) {
                this.oscillatevelocityhistory[i] = this.oscillatevelocityhistory[i - 1];
                total += this.oscillatevelocityhistory[i];
            }
            this.oscillatevelocityhistory[1] = this.oscillatevelocity;
            this.averageoscillate = (total += this.oscillatevelocityhistory[1]) / 3L;
            this.oscillatevelocity = AR.getTime() - this.lastchange;
            this.lastchange = AR.getTime();
        }
        if (this.velocity > this.maxvelocity) {
            this.maxvelocity = this.velocity;
        }
    }

    public double getMyAdvancingVelocity(Point2D source, Point2D destination) {
        Point2D enPos = this.position;
        double heading = this.absoluteBearing(source, destination);
        double absBearing = this.absoluteBearing(enPos, destination);
        return -Math.cos(heading - absBearing);
    }

    public double getTheirAdvancingVelocity(Point2D destination) {
        double absBearing = this.absoluteBearing(this.position, destination);
        return -Math.cos(this.heading - absBearing) * (double)this.sign(this.velocity);
    }

    public double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public double getGunHeat(long ctime) {
        double gunHeat = this.firepower * 0.2 + 1.0;
        return Math.max(gunHeat - (double)(ctime - this.scantime) * 0.1, 0.0);
    }

    public Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    public int sign(double value) {
        return value >= 0.0 ? 1 : -1;
    }

    public boolean whosClosest(Hashtable targets) {
        Enumeration e = targets.elements();
        double myDistance = this.distance;
        boolean counter = false;
        while (e.hasMoreElements()) {
            Enemy en = (Enemy)e.nextElement();
            if (!(en.position.distance(this.position) * 1.1 < myDistance) || !en.isAlive) continue;
            return false;
        }
        return true;
    }

    public double estimateX(long attime) {
        long timedifference = attime - this.scantime;
        return this.position.getX() + Math.sin(this.heading) * this.velocity * (double)timedifference;
    }

    public double estimateY(long attime) {
        long timedifference = attime - this.scantime;
        return this.position.getY() + Math.cos(this.heading) * this.velocity * (double)timedifference;
    }

    public double estimateDistance(double currX, double currY, long attime) {
        long timedifference = attime - this.scantime;
        return Math.sqrt((long)this.estimateX(attime) - (long)currX ^ 2L + ((long)this.estimateY(attime) - (long)currY) ^ 2L);
    }

    public Point2D.Double guessPosition(long when) {
        double newY;
        double newX;
        double diff = when - this.scantime;
        if (this.averageoscillate > 0L && this.averageoscillate > this.oscillatevelocity - 2L && this.averageoscillate < this.oscillatevelocity + 2L) {
            Point2D.Double pDepart;
            Point2D.Double pArrive;
            if (this.lastsystem != 3) {
                this.lastsystem = 3;
            }
            long timetoaccelerate = (long)this.maxvelocity;
            long timeatvelocity = this.averageoscillate - timetoaccelerate * 2L;
            double distanceAcc = 0.5 * (double)timetoaccelerate * (double)timetoaccelerate;
            double distanceTop = this.maxvelocity * (double)timeatvelocity;
            Double WhichOscillationAreWeIn = new Double(diff / (double)this.averageoscillate);
            double WhichOscillationBulletArrives = WhichOscillationAreWeIn.intValue();
            double direction = 0.0;
            direction = WhichOscillationBulletArrives > 0.0 ? (this.velocity > 0.0 ? WhichOscillationBulletArrives * -1.0 : -1.0 * (WhichOscillationBulletArrives * -1.0)) : (this.velocity > 0.0 ? 1.0 : -1.0);
            if (direction > 0.0) {
                pArrive = new Point2D.Double(this.oTop.x, this.oTop.y);
                pDepart = new Point2D.Double(this.oBottom.x, this.oBottom.y);
            } else {
                pArrive = new Point2D.Double(this.oBottom.x, this.oBottom.y);
                pDepart = new Point2D.Double(this.oTop.x, this.oTop.y);
            }
            long TimeIntoOscillation = (long)diff - (long)(WhichOscillationBulletArrives * (double)this.averageoscillate);
            double distanceTravelled = TimeIntoOscillation < timetoaccelerate ? 0.5 * (double)(TimeIntoOscillation ^ 2L) : (TimeIntoOscillation > this.averageoscillate - timetoaccelerate ? distanceAcc + distanceTop + -0.5 * (double)(TimeIntoOscillation - timeatvelocity - timetoaccelerate ^ 2L) : distanceAcc + this.maxvelocity * (double)(TimeIntoOscillation - timetoaccelerate));
            newX = pDepart.x + Math.sin(this.absoluteBearing(pDepart, pArrive)) * distanceTravelled;
            newY = pDepart.y + Math.cos(this.absoluteBearing(pDepart, pArrive)) * distanceTravelled;
        } else if (Math.abs(this.changehead) > 1.0E-5) {
            double radius = this.velocity / this.changehead;
            double tothead = diff * this.changehead;
            newY = this.position.getY() + Math.sin(this.heading + tothead) * radius - Math.sin(this.heading) * radius;
            newX = this.position.getX() + Math.cos(this.heading) * radius - Math.cos(this.heading + tothead) * radius;
            if (this.lastsystem != 1) {
                this.lastsystem = 1;
            }
        } else {
            newY = this.position.getY() + Math.cos(this.heading) * this.velocity * diff;
            newX = this.position.getX() + Math.sin(this.heading) * this.velocity * diff;
            if (this.lastsystem != 2) {
                this.lastsystem = 2;
            }
        }
        return new Point2D.Double(newX, newY);
    }
}

