/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.AdvancedRobotAdapter;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Navigation;
import agd.util.NavigationStrategy;
import agd.util.Navigator;
import agd.util.RobotInformation;
import agd.util.World;
import java.util.Random;
import robocode.HitRobotEvent;

public class DiverseGoto
extends AdvancedRobotAdapter
implements NavigationStrategy {
    Coord destination = null;
    RobotInformation robot = null;
    boolean finished = false;
    NavigationStrategy nextStrategy = null;
    Navigator navigator = null;
    Coord via = null;
    final int LEG_LENGTH = 150;
    final int MARGIN = 55;
    Random random = new Random();

    public DiverseGoto(RobotInformation r, Coord destination) {
        this.robot = r;
        this.destination = destination;
    }

    public DiverseGoto(RobotInformation r, Coord destination, Navigator n, NavigationStrategy strat) {
        this.robot = r;
        this.destination = destination;
        this.navigator = n;
        this.nextStrategy = strat;
    }

    public void discard() {
    }

    public void onHitRobot(HitRobotEvent hre) {
    }

    public Navigation navigate() {
        Navigation navinfo = new Navigation();
        Coord ourPos = this.robot.getPosition();
        if (this.via == null) {
            this.via = this.nextWaypoint();
        }
        if (!this.finished && ourPos.distanceTo(this.via) < 20.0) {
            if (this.via == this.destination) {
                this.finished = true;
            } else {
                this.via = this.nextWaypoint();
            }
        }
        if (!this.finished) {
            Compass ourHeading = new Compass(this.robot.getAdvancedRobot().getHeading());
            Compass requiredHeading = ourPos.headingTo(this.via);
            double bearing = ourHeading.bearingTo(requiredHeading);
            double direction = 1.0;
            if (Math.abs(bearing) > 90.0) {
                direction = -1.0;
                bearing = new Compass(bearing - 180.0).getDegrees();
            }
            double distance = ourPos.distanceTo(this.destination);
            navinfo = new Navigation(new Double(direction * distance), new Double(bearing));
            if (distance < 200.0 && Math.abs(bearing) > 45.0) {
                navinfo.setMaxVelocity(1.0 + distance / 28.0);
            } else {
                navinfo.setMaxVelocity(8.0);
            }
        } else if (this.navigator != null && this.nextStrategy != null) {
            this.navigator.setNavigationStrategy(this.nextStrategy);
            navinfo = this.nextStrategy.navigate();
        }
        return navinfo;
    }

    Coord nextWaypoint() {
        Coord wp;
        Coord ourPos = this.robot.getPosition();
        if (ourPos.distanceTo(this.destination) < 150.0) {
            wp = this.destination;
        } else {
            Compass heading = new Compass(ourPos.headingTo(this.destination).getDegrees() + (this.random.nextDouble() * 140.0 - 70.0));
            wp = ourPos.applyVector(heading, 150.0);
            Coord size = World.getBattleFieldSize();
            if (wp.getX() < 55.0) {
                wp = new Coord(55.0, wp.getY());
            }
            if (wp.getY() < 55.0) {
                wp = new Coord(wp.getX(), 55.0);
            }
            if (wp.getX() > size.getX() - 55.0) {
                wp = new Coord(size.getX() - 55.0, wp.getY());
            }
            if (wp.getY() > size.getY() - 55.0) {
                wp = new Coord(wp.getX(), size.getY() - 55.0);
            }
        }
        return wp;
    }

    public boolean isDone() {
        return this.finished;
    }
}

