/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.AdvancedRobotAdapter;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Navigation;
import agd.util.NavigationStrategy;
import agd.util.Navigator;
import agd.util.RobotInformation;

public abstract class GotoMethod
extends AdvancedRobotAdapter
implements NavigationStrategy {
    Coord destination = null;
    RobotInformation robot = null;
    boolean finished = false;
    NavigationStrategy nextStrategy = null;
    Navigator navigator = null;
    double acceptableRange = 20.0;

    public GotoMethod(RobotInformation r, Coord destination) {
        this.robot = r;
        this.destination = destination;
    }

    public void setDestination(Coord dest) {
        this.finished = false;
        this.destination = dest;
    }

    public String toString() {
        return "Goto " + this.destination + ", within " + this.acceptableRange + ";";
    }

    public void setAcceptableRange(double r) {
        this.acceptableRange = r;
    }

    public boolean isDone() {
        return this.finished;
    }

    void setDone(boolean done) {
        this.finished = done;
    }

    public Navigation navigate() {
        Navigation navinfo = new Navigation();
        Coord ourPos = this.robot.getPosition();
        System.out.println("FastGoto: navigate: finished = " + this.finished);
        if (!this.finished && ourPos.distanceTo(this.destination) < this.acceptableRange) {
            this.finished = true;
            System.out.println("Goto: navigate: reached destination, distance is " + ourPos.distanceTo(this.destination));
        }
        if (!this.finished) {
            Compass ourHeading = new Compass(this.robot.getAdvancedRobot().getHeading());
            Compass requiredHeading = ourPos.headingTo(this.destination);
            double bearing = ourHeading.bearingTo(requiredHeading);
            double direction = 1.0;
            if (bearing > 90.0) {
                direction = -1.0;
                bearing -= 180.0;
            } else if (bearing < -90.0) {
                direction = -1.0;
                bearing += 180.0;
            }
            double distance = ourPos.distanceTo(this.destination);
            System.out.println("FastGoto: navigate: distance = " + distance);
            System.out.println("FastGoto: navigate: bearing = " + bearing);
            navinfo = new Navigation(new Double(direction * distance), new Double(bearing));
            if (distance < 200.0 && Math.abs(bearing) > 45.0) {
                navinfo.setMaxVelocity(1.0 + distance / 28.0);
            } else {
                navinfo.setMaxVelocity(8.0);
            }
        } else if (this.navigator != null && this.nextStrategy != null) {
            this.navigator.setNavigationStrategy(this.nextStrategy);
            navinfo = this.nextStrategy.navigate();
        }
        return navinfo;
    }
}

