/*
 * Decompiled with CFR 0.152.
 */
package synapse;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Rules;
import robocode.WinEvent;
import robocode.util.Utils;
import synapse.BaseBot;
import synapse.BotState;
import synapse.BulletCondition;
import synapse.Drive;
import synapse.Module;
import synapse.Segmentation;
import synapse.Util;
import synapse.Wave;
import synapse.segmentation.Acceleration;
import synapse.segmentation.Axis;
import synapse.segmentation.LastStopped;
import synapse.segmentation.Orthogonality;
import synapse.segmentation.Velocity;

public class MovementAutoSegmented
extends Module
implements Drive {
    private final BaseBot bot;
    private final TreeSet<Wave> waves = new TreeSet();
    private static final double INITIAL_PREFERRED_DISTANCE = 400.0;
    private static double normalPreferredDistance = 400.0;
    private static double currentPreferredDistance;
    private static boolean flattenerEnabled;
    private static final float BIN_SMOOTHING_VALUE = 1.75f;
    private int clockwise = 1;
    private static final double HALF_PI = 1.5707963267948966;
    private static final double WALKING_STICK = 160.0;
    private static final double WALL_MARGIN = 20.0;
    private static double S;
    private static double W;
    private static double N;
    private static double E;
    private static LinkedList<Axis> axes;
    private static Segmentation[] segments;
    private static final int NUM_WAVEBUCKETS = 32;
    private static int[] indices;

    static {
        flattenerEnabled = false;
    }

    public MovementAutoSegmented(BaseBot bot) {
        this.bot = bot;
        S = 20.0;
        W = 20.0;
        N = bot.getBattleFieldHeight() - 20.0;
        E = bot.getBattleFieldWidth() - 20.0;
        currentPreferredDistance = normalPreferredDistance;
        bot.preferredDistance = normalPreferredDistance;
        if (segments == null) {
            axes = new LinkedList();
            axes.add(new Velocity(12));
            axes.add(new LastStopped(6));
            axes.add(new Orthogonality(6));
            axes.add(new Acceleration());
            segments = new Segmentation[1 << axes.size()];
            int i = 0;
            while (i < segments.length) {
                LinkedList<Axis> segAx = new LinkedList<Axis>();
                int j = 0;
                while (j < axes.size()) {
                    if ((i & 1 << j) > 0) {
                        segAx.add(axes.get(j));
                    }
                    ++j;
                }
                float depth = 5.0f - 4.5f * (float)(segAx.size() / axes.size());
                MovementAutoSegmented.segments[i] = new Segmentation(32, segAx.toArray(new Axis[0]), depth, true);
                ++i;
            }
            segments[0].registerHit(0.0f, 0, false, 0.1f, 1.0f);
        }
        indices = new int[segments.length];
        System.out.println("Flattener " + (flattenerEnabled ? "on." : "off."));
    }

    @Override
    public String toString() {
        return "AutoSurfer";
    }

    @Override
    public void doTick() {
        this.manageWaves();
        if (!this.active) {
            return;
        }
        this.adjustParameters();
        Wave w = null;
        if (this.waves.isEmpty()) {
            if (this.bot.getOthers() == 1 && this.bot.target != null) {
                if (Utils.isNear((double)this.bot.target.energy, (double)0.0)) {
                    this.bot.goTo(this.bot.target.location.x, this.bot.target.location.y);
                    return;
                }
                if (this.bot.target.energy + 0.1 < this.bot.getEnergy() / 2.0 && this.bot.getEnergy() > 0.1) {
                    currentPreferredDistance = 150.0;
                } else if (this.bot.getEnergy() < 0.1) {
                    currentPreferredDistance = 700.0;
                }
            } else if (this.bot.getOthers() == 0) {
                this.bot.setAhead(0.0);
                return;
            }
        } else {
            currentPreferredDistance = normalPreferredDistance;
            w = this.waves.first();
            if (w.getHit() == BulletCondition.HIT_BULLET || w.velocity * (double)(this.bot.time - w.ctime) > this.bot.location.distance(w.origin)) {
                w = this.waves.higher(w);
            }
        }
        BotState hereNow = new BotState(this.bot);
        hereNow.clockwise = this.clockwise;
        hereNow.danger = this.getDanger(w, hereNow.location, this.bot.time);
        BotState safest = this.pathDanger(hereNow, this.waves, 2, w);
        this.clockwise = safest.clockwise;
        double heading = this.smoothHeading(this.bot.location, w, safest.clockwise);
        double relativeHeading = Utils.normalRelativeAngle((double)(heading - this.bot.getHeadingRadians()));
        this.bot.setTurnRightRadians(Util.backAsFrontTurn(relativeHeading));
        if (safest == hereNow) {
            this.bot.setAhead(0.0);
        } else {
            this.bot.setAhead(200 * Util.backAsFrontAhead(relativeHeading));
        }
    }

    private BotState pathDanger(BotState startingState, TreeSet<Wave> waves, int limit, Wave startingWave) {
        BotState safest = (BotState)startingState.clone();
        Wave next = null;
        if (limit > 0 && startingWave != null || waves.isEmpty()) {
            if (!waves.isEmpty()) {
                next = startingWave;
                while ((next = waves.higher(next)) != null && next.velocity * (double)(startingState.time - next.ctime) < startingState.location.distance(this.bot.target.location)) {
                }
            }
            if (next != null && limit > 1) {
                safest.danger += this.pathDanger((BotState)safest, waves, (int)(limit - 1), (Wave)next).danger;
            }
            double minDanger = safest.danger;
            int clockwise = -1;
            while (clockwise < 2) {
                BotState b = startingState;
                while (true) {
                    b = b.iterate(this.smoothHeading(b.location, startingWave, clockwise));
                    b.clockwise = clockwise;
                    b.danger = this.getDanger(startingWave, b.location, b.time);
                    if (-1.0 == b.danger || waves.isEmpty() && b.time - startingState.time > 20L) break;
                    if (next != null && limit > 1 && b.danger < minDanger) {
                        b.danger += this.pathDanger((BotState)b, waves, (int)(limit - 1), (Wave)next).danger;
                    }
                    if (!(b.danger < minDanger)) continue;
                    minDanger = b.danger;
                    safest = b;
                }
                clockwise += 2;
            }
        }
        return safest;
    }

    private double getDanger(Wave w, Point2D.Double location, long t) {
        double distance = location.distance(this.bot.target.location);
        if (distance <= 36.0) {
            return -1.0;
        }
        if (w == null) {
            if (t - this.bot.time > 25L || Math.abs(distance - currentPreferredDistance) < 15.0 || !this.bot.target.live) {
                return -1.0;
            }
            return Math.abs(distance - currentPreferredDistance);
        }
        distance = w.origin.distance(location);
        if (w.velocity * (double)(t - w.ctime) < distance) {
            double dangerMod;
            double danger = 0.0;
            double measuredDangerWidth = 0.0;
            double angle = (Util.absoluteBearing(w.origin, location) + Math.PI) % 1.5707963267948966;
            if (angle > 0.7853981633974483) {
                angle = 1.5707963267948966 - angle;
            }
            double angularBotWidth = Math.atan(18.0 / Math.cos(angle) / distance) * 2.0;
            angle = Wave.getGuessFactor(w, location.x, location.y);
            int startingBin = (int)Math.max(32.0 * (angle + 1.0 - angularBotWidth / w.extent) / 2.0 - 1.0, 0.0);
            int endingBin = (int)Math.min(32.0 * (angle + 1.0 + angularBotWidth / w.extent) / 2.0 + 1.0, 31.0);
            angle = angle * w.extent / 2.0 + w.heading;
            danger = 0.0;
            double startingAngle = angle - angularBotWidth / 2.0;
            double endingAngle = angle + angularBotWidth / 2.0;
            float[] buckets = segments[w.segmentation].getBuckets(w.bestSegment);
            double bucketMax = segments[w.segmentation].getMaximum(w.bestSegment);
            int i = startingBin;
            while (i < endingBin) {
                double bucketLeft = w.heading + w.extent * ((double)i / 32.0 - 0.5);
                if (bucketLeft + w.extent / 32.0 > startingAngle && bucketLeft < endingAngle) {
                    double fraction;
                    dangerMod = (double)buckets[i] / bucketMax;
                    if (bucketLeft < startingAngle) {
                        fraction = 1.0 - 32.0 / w.extent * (startingAngle - bucketLeft);
                        danger += dangerMod * fraction;
                        measuredDangerWidth += fraction;
                    } else if (bucketLeft + w.extent / 32.0 > endingAngle) {
                        fraction = (endingAngle - bucketLeft) * 32.0 / w.extent;
                        danger += dangerMod * fraction;
                        measuredDangerWidth += fraction;
                    } else {
                        danger += dangerMod;
                        measuredDangerWidth += 1.0;
                    }
                }
                ++i;
            }
            if (distance < currentPreferredDistance) {
                dangerMod = 1.0 - distance / currentPreferredDistance;
                dangerMod *= dangerMod;
                danger = danger * (1.0 - dangerMod) + dangerMod;
            }
            return Rules.getBulletDamage((double)w.power) * danger / measuredDangerWidth;
        }
        return -1.0;
    }

    private double smoothHeading(Point2D.Double location, Wave w, int clockwise) {
        if (w != null) {
            clockwise *= w.clockwise;
        }
        double distance = this.bot.target.location.distance(location);
        double h = Util.absoluteBearing(w != null ? w.origin : this.bot.target.location, location) + 1.5707963267948966 * (double)clockwise * (this.bot.target.live ? Util.limit(0.5, distance / currentPreferredDistance, this.waves.isEmpty() ? 1.5 : 1.25) : 1.0);
        h = this.smoothAngle(location.x, location.y, h, clockwise);
        return h;
    }

    private double smoothAngle(double x, double y, double angle, int oDir) {
        angle = this.smoothWest(N - y, angle - 1.5707963267948966, oDir) + 1.5707963267948966;
        angle = this.smoothWest(E - x, angle + Math.PI, oDir) - Math.PI;
        angle = this.smoothWest(y - S, angle + 1.5707963267948966, oDir) - 1.5707963267948966;
        angle = this.smoothWest(x - W, angle, oDir);
        angle = this.smoothWest(y - S, angle + 1.5707963267948966, oDir) - 1.5707963267948966;
        angle = this.smoothWest(E - x, angle + Math.PI, oDir) - Math.PI;
        angle = this.smoothWest(N - y, angle - 1.5707963267948966, oDir) + 1.5707963267948966;
        return angle;
    }

    private double smoothWest(double dist, double angle, int oDir) {
        if (dist < 160.0 && dist < -160.0 * Math.sin(angle)) {
            return Math.acos((double)oDir * dist / 160.0) - (double)oDir * 1.5707963267948966;
        }
        return angle;
    }

    private void manageWaves() {
        if (this.bot.target.energyDrop > 0.0 && this.bot.target.energyDrop <= 3.0) {
            int clockwise = this.bot.oldOldVelocity * Math.sin(this.bot.heading - Util.absoluteBearing(this.bot.oldOldLocation, this.bot.target.oldOldLocation)) > 0.0 ? -1 : 1;
            double bestFitness = 0.0;
            int bestSegmentation = 0;
            int bestSegment = 0;
            int s = 0;
            while (s < segments.length) {
                double fit = segments[s].getFitness(indices[s]);
                if (fit > bestFitness) {
                    bestSegmentation = s;
                    bestFitness = fit;
                    bestSegment = indices[s];
                }
                ++s;
            }
            Wave newest = new Wave(this.bot.target, this.bot.oldOldLocation, clockwise, bestSegmentation, indices, bestSegment);
            this.bot.lastIncomingBulletFlightTime = (int)(this.bot.target.distance / this.bot.target.energyDrop);
            this.waves.add(newest);
        }
        long time = this.bot.time;
        Iterator<Wave> i = this.waves.iterator();
        while (i.hasNext()) {
            Wave w = i.next();
            if (!((double)(time - w.ctime) * w.velocity > w.origin.distance(this.bot.location) + 20.0)) continue;
            segments[w.segmentation].registerSuccess(w.bestSegment);
            if (w.getHit() == BulletCondition.ARRIVING) {
                w.setHit(BulletCondition.MISSED_TARGET);
            }
            i.remove();
        }
        int[] newIndices = new int[segments.length];
        int i2 = 0;
        while (i2 < segments.length) {
            newIndices[i2] = segments[i2].getIndex(this.bot);
            ++i2;
        }
        indices = newIndices;
    }

    private void adjustParameters() {
        if (BaseBot.shotsFiredBattleEnemy > 50L) {
            boolean isBad;
            if (flattenerEnabled) {
                isBad = (float)BaseBot.shotsHitBattleEnemy / (float)BaseBot.shotsFiredBattleEnemy > 0.08f;
            } else {
                boolean bl = isBad = (float)BaseBot.shotsHitBattleEnemy / (float)BaseBot.shotsFiredBattleEnemy > 0.15f;
            }
            if (flattenerEnabled != isBad) {
                flattenerEnabled = isBad;
                System.out.println("Flattener " + (flattenerEnabled ? "on." : "off."));
            }
            currentPreferredDistance = normalPreferredDistance * Util.limit(1.0, 0.4 + 2.0 * (double)BaseBot.shotsHitBattleEnemy / (double)BaseBot.shotsFiredBattleEnemy, 1.25);
            this.bot.preferredDistance = normalPreferredDistance;
        }
    }

    @Override
    public void useEvent(Event e) {
        if (!(e instanceof HitRobotEvent)) {
            if (e instanceof HitByBulletEvent) {
                this.registerHit(((HitByBulletEvent)e).getBullet(), BulletCondition.HIT_TARGET);
            } else if (e instanceof BulletHitBulletEvent) {
                this.registerHit(((BulletHitBulletEvent)e).getHitBullet(), BulletCondition.HIT_BULLET);
            } else if (e instanceof DeathEvent || e instanceof WinEvent) {
                System.out.println("New distance: " + Math.floor(100.0 * normalPreferredDistance) / 100.0);
            }
        }
    }

    private void registerHit(Bullet bullet, BulletCondition bulletCondition) {
        for (Wave w : this.waves) {
            if (!Utils.isNear((double)bullet.getVelocity(), (double)w.velocity) || !Utils.isNear((double)bullet.getPower(), (double)w.power) || !(Math.abs(w.origin.distance(bullet.getX(), bullet.getY()) - (double)(this.bot.time - w.ctime) * w.velocity) < 50.0)) continue;
            w.setHit(bulletCondition);
            int i = 0;
            Segmentation[] segmentationArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                Segmentation s = segmentationArray[n2];
                s.registerHit((float)Wave.getGuessFactor(w, bullet.getX(), bullet.getY()), w.indices[i], true, 1.0f, 1.75f);
                ++i;
                ++n2;
            }
            break block0;
        }
    }

    @Override
    public void doPaint(Graphics2D g) {
        if (!this.active) {
            return;
        }
        g.setStroke(new BasicStroke(0.0f));
        double bright = 0.0;
        if (this.bot.getOthers() == 1) {
            double time = this.bot.getTime();
            for (Wave w : this.waves) {
                double radius = (time - (double)w.ctime) * w.velocity;
                double arcSegment = w.extent / 32.0;
                int i = 0;
                while (i < 32) {
                    Color waveColor;
                    double segmentHeading = w.heading + (double)w.clockwise * (arcSegment * (double)i - w.extent / 2.0);
                    bright = segments[w.segmentation].getBuckets(w.bestSegment)[i] / segments[w.segmentation].getMaximum(w.bestSegment);
                    switch (w.getHit()) {
                        case HIT_TARGET: {
                            waveColor = new Color(0, 255, 0, (int)(255.0 * (0.5 + 0.5 * bright)));
                            break;
                        }
                        case HIT_BULLET: {
                            waveColor = new Color(0, 0, 255, (int)(255.0 * (0.25 + 0.75 * bright)));
                            break;
                        }
                        default: {
                            waveColor = new Color(223, 218, 169, (int)(255.0 * (0.15 + 0.85 * bright)));
                        }
                    }
                    g.setColor(waveColor);
                    bright *= 2.0;
                    int thickness = 3;
                    g.fillPolygon(new int[]{(int)(w.origin.x + (radius + 3.0 + 3.0) * Math.sin(segmentHeading)), (int)(w.origin.x + (radius + 3.0) * Math.sin(segmentHeading)), (int)(w.origin.x + (radius + 3.0) * Math.sin(segmentHeading + arcSegment)), (int)(w.origin.x + (radius + 3.0 + 3.0) * Math.sin(segmentHeading + arcSegment))}, new int[]{(int)(w.origin.y + (radius + 3.0 + 3.0) * Math.cos(segmentHeading)), (int)(w.origin.y + (radius + 3.0) * Math.cos(segmentHeading)), (int)(w.origin.y + (radius + 3.0) * Math.cos(segmentHeading + arcSegment)), (int)(w.origin.y + (radius + 3.0 + 3.0) * Math.cos(segmentHeading + arcSegment))}, 4);
                    ++i;
                }
                g.setColor(new Color(255, 255, 255, 127));
                String[] seg = segments[w.segmentation].toString().split(" / ");
                int i2 = 0;
                while (i2 < seg.length) {
                    g.drawString(seg[i2], (int)(w.origin.x + (radius + 2.0) * Math.sin(w.heading + w.extent / 2.0)), (int)(w.origin.y + (radius + 2.0) * Math.cos(w.heading + w.extent / 2.0)) - 12 * i2);
                    ++i2;
                }
            }
        }
    }
}

