/*
 * Decompiled with CFR 0.152.
 */
package md;

import md.VelociRaptor;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

public class Enemy
extends VelociRaptor {
    private String Name = "\u0000";
    private double Heading = 0.0;
    private double Bearing = 0.0;
    private double Distance = 0.0;
    private double Energy = 100.0;
    private double PrevEnergy = 0.0;
    private double Velocity = 0.0;
    private double RunningAvgVelocity = 0.0;
    public int ShotsMissed = 0;
    public boolean PredictiveTargeting = true;
    public long ScanTime = -1L;
    public long PrevScanTime = 0L;

    public void SetScannedEnemyInfo(ScannedRobotEvent e, long time) {
        this.Name = e.getName();
        this.Heading = e.getHeading();
        this.Bearing = e.getBearing();
        this.Distance = e.getDistance();
        this.PrevEnergy = this.Energy;
        this.Energy = e.getEnergy();
        this.Velocity = e.getVelocity();
        this.RunningAvgVelocity = this.RunningAvgVelocity == 0.0 ? this.Velocity : 0.99 * this.RunningAvgVelocity + 0.01 * this.Velocity;
        this.PrevScanTime = this.ScanTime < 0L ? time : this.ScanTime;
        this.ScanTime = time;
    }

    public void SetRammedEnemyInfo(HitRobotEvent e) {
        this.Name = e.getName();
        this.Bearing = e.getBearing();
    }

    public void SetBulletHitEnemyInfo(BulletHitEvent e) {
        this.Name = e.getName();
        Bullet thisBullet = e.getBullet();
        this.Heading = thisBullet.getHeading();
    }

    public void SetHitByEnemyBulletInfo(HitByBulletEvent e) {
        this.Name = e.getName();
        this.Heading = e.getHeading();
        this.Bearing = e.getBearing();
    }

    public void SetEnemyTargetingInfo() {
        ++this.ShotsMissed;
        if (this.ShotsMissed >= 2) {
            this.ShotsMissed = 0;
        }
    }

    public String getName() {
        return this.Name;
    }

    public double getHeading() {
        return this.Heading;
    }

    public double getBearing() {
        return this.Bearing;
    }

    public double getDistance() {
        return this.Distance;
    }

    public double getEnergy() {
        return this.Energy;
    }

    public double getPrevEnergy() {
        return this.PrevEnergy;
    }

    public double getVelocity() {
        return this.Velocity;
    }

    public double getRunningAvgVelocity() {
        return this.RunningAvgVelocity;
    }

    public boolean wasScannedRecently() {
        return this.ScanTime - this.PrevScanTime <= 5L && this.ScanTime - this.PrevScanTime >= 0L;
    }
}

