/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.data.segmentArray;

import rampancy.util.RRobotState;
import rampancy.util.RUtil;
import rampancy.util.data.segmentArray.RNode;
import rampancy.util.data.segmentArray.RSegmentArray;

public class RLeafSegment
implements RNode {
    public double[] guessFactorArray;
    public int visits;

    public static void updateGuessFactors(RLeafSegment leaf, int guessFactorIndex, double weight, int rollDepth) {
        ++leaf.visits;
        int visits = leaf.visits;
        double[] guessFactors = leaf.guessFactorArray;
        guessFactors[guessFactorIndex] = RUtil.rollingAvg(guessFactors[guessFactorIndex], 1.0, Math.min(visits - 1, rollDepth), weight + 1.0);
        int i = 0;
        while (i < guessFactors.length) {
            if (i != guessFactorIndex) {
                guessFactors[i] = RUtil.rollingAvg(guessFactors[i], 1.0 / (Math.pow(guessFactorIndex - i, 2.0) + 1.0), Math.min(visits, rollDepth), weight);
            }
            ++i;
        }
    }

    public RLeafSegment(int size) {
        this.guessFactorArray = new double[size];
        this.visits = 0;
    }

    public RLeafSegment getSegmentForState(RRobotState state) {
        return this;
    }

    public RNode newInstance(RSegmentArray reference, int depth) {
        return new RLeafSegment(this.guessFactorArray.length);
    }
}

