/*
 * Decompiled with CFR 0.152.
 */
package mb.waves;

import mb.core.Coordinates;
import mb.waves.Segments;
import robocode.Rules;

public class Wave {
    long fireTime;
    double power;
    double gunHeading;
    Segments segment;
    Coordinates start;
    Coordinates target;

    public Wave(long fireTime, double power, Coordinates start, Coordinates target, Segments segment, double gunHeading) {
        this.fireTime = fireTime;
        this.power = power;
        this.start = start;
        this.target = target;
        this.segment = segment;
    }

    public boolean checkHit(Coordinates enemyPosition, long currentTime) {
        return this.start.getDistanceTo(enemyPosition) <= (double)(currentTime - this.fireTime) * Rules.getBulletSpeed((double)this.power);
    }

    public boolean checkHitPrint(Coordinates enemyPosition, long currentTime) {
        if (this.start.getDistanceTo(enemyPosition) <= (double)(currentTime - this.fireTime) * Rules.getBulletSpeed((double)this.power)) {
            System.out.println("Target: " + this.target);
            System.out.println("Actual: " + enemyPosition);
            return true;
        }
        return false;
    }

    public Coordinates getDiffVector(Coordinates enemyPosition) {
        return this.target.getDiffVector(enemyPosition);
    }

    public Segments getSegment() {
        return this.segment;
    }
}

