/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode.targeting;

import com.spp.robocode.BattlefieldModel;
import com.spp.robocode.Enemy;
import com.spp.robocode.Gunner;
import com.spp.robocode.WaveBullet;
import com.spp.robocode.targeting.TargetModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class GuessTargeting
implements TargetModel {
    private final Map<String, List<WaveBullet>> enemyWaves = new HashMap<String, List<WaveBullet>>();
    private int direction = 1;

    @Override
    public double getFiringSolution(Enemy currentTarget, double power, AdvancedRobot robot, double robotHeading) {
        int[] currentStats = currentTarget.getWaveStats();
        int bestindex = 15;
        for (int i = 0; i < 31; ++i) {
            if (currentStats[bestindex] >= currentStats[i]) continue;
            bestindex = i;
        }
        double guessfactor = (double)(bestindex - (currentStats.length - 1) / 2) / (double)((currentStats.length - 1) / 2);
        double maxEscapeAngle = Math.asin(8.0 / (20.0 - power * 3.0));
        double angleOffset = (double)this.direction * guessfactor * maxEscapeAngle;
        double absBearing = robot.getHeadingRadians() + currentTarget.getBearingRadians();
        double gunAdjust = Utils.normalRelativeAngle((double)(absBearing - robot.getGunHeadingRadians() + angleOffset));
        return gunAdjust;
    }

    @Override
    public void onScannedRobot(AdvancedRobot robot, ScannedRobotEvent e, BattlefieldModel model) {
        Enemy enemy;
        if (!this.enemyWaves.containsKey(e.getName())) {
            this.enemyWaves.put(e.getName(), new ArrayList());
        }
        List<WaveBullet> waves = this.enemyWaves.get(e.getName());
        double absBearing = robot.getHeadingRadians() + e.getBearingRadians();
        double ex = robot.getX() + Math.sin(absBearing) * e.getDistance();
        double ey = robot.getY() + Math.cos(absBearing) * e.getDistance();
        for (int i = 0; i < waves.size(); ++i) {
            WaveBullet currentWave = waves.get(i);
            if (!currentWave.checkHit(ex, ey, robot.getTime())) continue;
            waves.remove(currentWave);
            --i;
        }
        if (e.getVelocity() != 0.0) {
            this.direction = Math.sin(e.getHeadingRadians() - absBearing) * e.getVelocity() < 0.0 ? -1 : 1;
        }
        if ((enemy = model.getEnemy(e.getName(), false)) != null) {
            int[] currentStats = model.getEnemy(e.getName(), false).getWaveStats();
            WaveBullet newWave = new WaveBullet(e.getName(), robot.getX(), robot.getY(), absBearing, Gunner.GetPower(e.getDistance()), this.direction, robot.getTime(), currentStats);
            waves.add(newWave);
        }
    }

    @Override
    public String getName() {
        return "GUESS";
    }
}

