/*
 * Decompiled with CFR 0.152.
 */
package grybgoofy;

import grybgoofy.GMath;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class Scanner {
    double bearing;
    double radar;
    double delta;
    double scanDelta;
    double xC;
    double yC;
    double xR;
    double yR;
    double theta;
    double phi;
    double direction;

    public double scan(ScannedRobotEvent e, AdvancedRobot r) {
        this.bearing = GMath.intervalize(e.getBearing() + r.getHeading(), 0.0, 360.0, 360.0);
        this.radar = r.getRadarHeading();
        this.delta = GMath.intervalize(this.bearing - this.radar, -180.0, 180.0);
        this.scanDelta = 22.5 * GMath.sign(this.delta) + this.delta;
        return this.scanDelta;
    }

    public void findOpponent(AdvancedRobot r) {
        this.xR = r.getX();
        this.yR = r.getY();
        this.xC = r.getBattleFieldWidth() / (double)2;
        this.yC = r.getBattleFieldHeight() / (double)2;
        this.theta = GMath.toPhi(GMath.intervalize(GMath.atan2(this.yC - this.yR, this.xC - this.xR), 0.0, Math.PI * 2));
        this.phi = r.getRadarHeadingRadians();
        this.direction = GMath.sign(GMath.intervalize(this.theta - this.phi, -Math.PI, Math.PI));
        r.setTurnRadarRight(720.0 * this.direction);
    }
}

