/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.BattleField;
import florent.Context;
import florent.DynamicDistancing;
import florent.FloatingTadpole;
import florent.MyEnemyWave;
import florent.WaveCommandFloater;
import florent.WaveManagerFloater;
import florent.jUtil;
import florent.move.Mirror;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Floater {
    protected static final boolean DEBUG = false;
    protected WaveManagerFloater manager;
    protected Context target;
    protected BattleField BF;
    protected Rectangle2D.Double innerBF;
    protected AdvancedRobot me;
    protected Point2D.Double nextDestination = new Point2D.Double(300.0, 400.0);
    protected double myBearingDirection;
    protected Point2D.Double enemyLocation;
    protected Point2D.Double myLocation;
    protected double time;
    protected double myHeading;
    protected double dangerForward;
    protected double dangerBack;
    protected double energy;
    protected double lastFireTime;
    protected double lastBulletVelocity;
    protected double distance;
    protected double timeSinceReverse = 0.0;
    protected static boolean keepGoing = true;
    protected boolean ramActive = true;
    protected static DynamicDistancing distancing = DynamicDistancing.getInstance();
    protected static boolean dynamicDistancingActive = false;
    protected Mirror mirror;
    protected boolean mirrorActive = true;
    protected boolean mirrorEngaged = false;

    public Floater(Context target, AdvancedRobot me) {
        this.target = target;
        this.me = me;
        this.manager = new WaveManagerFloater(target, me);
        this.BF = new BattleField(me);
        this.innerBF = new Rectangle2D.Double(75.0, 75.0, me.getBattleFieldWidth() - 150.0, me.getBattleFieldHeight() - 150.0);
        this.mirror = new Mirror(me);
    }

    public void init() {
        this.manager.init();
        distancing.init();
        this.mirror.setAwayFactor(1.0);
    }

    protected void newTick() {
        this.manager.newTick();
    }

    protected void synch() {
        MyEnemyWave.synch();
        if (this.time == (double)this.me.getTime()) {
            return;
        }
        this.timeSinceReverse = this.myBearingDirection == this.target.getMyBearingDirection() ? (this.timeSinceReverse += (double)this.me.getTime() - this.time) : 0.0;
        this.myBearingDirection = this.target.getMyBearingDirection();
        this.time = this.target.getTime();
        this.myHeading = this.target.getMyHeading();
        this.myLocation = this.target.getMyLocation();
        this.enemyLocation = this.target.getEnemyLocation();
        this.energy = this.target.getEnergy();
        this.distance = this.target.getDistance();
    }

    public void newRound() {
        this.manager.newRound();
    }

    public void endRound() {
    }

    public void dump() {
        this.manager.dump();
        System.out.println("headOn avoidance :" + (keepGoing || this.manager.isClearAhead()));
    }

    public void onHitByBullet(HitByBulletEvent e) {
        distancing.onHitByBullet(e);
        this.manager.onHitByBullet(e);
        if (this.distance > 100.0 && this.distance * 1.2 / e.getVelocity() < this.timeSinceReverse) {
            keepGoing = false;
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.manager.onBulletHitBullet(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        distancing.onBulletHit(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.mirror.onScannedRobot(e);
        double energyDrop = this.target.getEnergy() - e.getEnergy();
        if (energyDrop >= 0.1 && energyDrop <= 3.0 && this.me.getEnergy() > 0.0) {
            this.manager.createWave(Math.max(Math.min(energyDrop, 0.1), 3.0), true, new WaveCommandFloater(this));
            this.target.setFirePower(Math.max(Math.min(energyDrop, 0.1), 3.0));
            this.lastFireTime = this.time;
            this.lastBulletVelocity = jUtil.bulletVelocity(energyDrop);
        } else {
            this.manager.createWave(this.target.getFirePower(), false, new WaveCommandFloater(this));
        }
        this.target.onScannedRobot(e);
        distancing.onScannedRobot(e);
        this.synch();
    }

    public void updateDanger(MyEnemyWave wave) {
        this.synch();
        this.dangerForward += this.danger(this.impactLocation(1, 8.0, wave, 0.0), wave);
        this.dangerBack += this.danger(this.impactLocation(-1, 8.0, wave, 5.0), wave);
    }

    protected Point2D.Double impactLocation(int circleDir, double velocity, MyEnemyWave wave, double timeOffset) {
        double d;
        Point2D.Double impact = new Point2D.Double(this.myLocation.x, this.myLocation.y);
        Point2D.Double center = this.getOrbitCenter();
        double cTime = this.time + timeOffset;
        do {
            impact = jUtil.projectMotion(impact, Utils.normalRelativeAngle((double)jUtil.absoluteBearing(impact, this.getNextPoint(circleDir, impact, center))), velocity);
            d = cTime;
            cTime = d + 1.0;
        } while (wave.distanceToImpact(impact, d) > 10.0);
        return impact;
    }

    protected double danger(Point2D.Double impact, MyEnemyWave wave) {
        double val = 0.0;
        double[][] bins = wave.getBins();
        double[] hitBin = bins[0];
        double[] visitBin = bins[1];
        double cHeading = this.myHeading + jUtil.absoluteBearing(this.myLocation, impact);
        if (this.manager.isGood()) {
            double i;
            int gf = wave.getPredictedGf();
            if (this.manager.isHeadOn()) {
                gf = 15;
            }
            if ((i = (double)Math.abs((long)gf - Math.round((1.0 + wave.getGF(impact)) * 15.0))) < Math.ceil(30.0 * (Math.atan(18.0 / impact.distance(wave.getGunLocation())) / Math.asin(8.0 / wave.getBulletVellocity())))) {
                i /= 4.0;
            } else if (!this.BF.contains(impact)) {
                i = 0.4;
            } else if (Math.abs(jUtil.absoluteBearing(impact, this.enemyLocation) - cHeading) < 0.8975979010256552) {
                i /= 2.0;
            }
            val += 1.0 / i / Math.pow(Math.abs(1.0 + wave.distanceToImpact(this.myLocation, this.time) / wave.getBulletVellocity()), 0.3);
        } else {
            val += this.indexValue(hitBin, visitBin, (int)Math.round((1.0 + wave.getGF(impact)) * 15.0)) / Math.pow(1.0 + Math.abs(wave.distanceToImpact(this.myLocation, this.time) / wave.getBulletVellocity()), 0.5);
        }
        return val;
    }

    public Point2D.Double getOrbitCenter() {
        MyEnemyWave wave = this.manager.getClosestBullet(this.myLocation, this.time);
        if (wave == null) {
            return this.enemyLocation;
        }
        return wave.getGunLocation();
    }

    public void doMove() {
        this.synch();
        MyEnemyWave wave = this.manager.getNearestBullet(this.myLocation, this.time);
        double minDistance = 100.0;
        if (this.energy == 0.0 && this.distance < this.lastBulletVelocity * (this.time - this.lastFireTime) && this.ramActive) {
            this.nextDestination = this.enemyLocation;
        } else if (keepGoing || this.manager.isClearAhead()) {
            Point2D.Double newDestination = this.getNextPoint((int)this.myBearingDirection, this.myLocation, this.getOrbitCenter());
            Point2D.Double newDestinationReverse = this.getNextPoint((int)(-this.myBearingDirection), this.myLocation, this.getOrbitCenter());
            this.nextDestination = newDestination.distance(this.enemyLocation) > minDistance ? newDestination : newDestinationReverse;
        } else if (wave == null && this.me.getOthers() > 0 && this.target.isRammer()) {
            Point2D.Double newDestination = this.getNextPoint((int)this.myBearingDirection, this.myLocation, this.getOrbitCenter());
            Point2D.Double newDestinationReverse = this.getNextPoint((int)(-this.myBearingDirection), this.myLocation, this.getOrbitCenter());
            this.nextDestination = newDestination.distance(this.enemyLocation) > newDestinationReverse.distance(this.enemyLocation) ? newDestination : newDestinationReverse;
        } else {
            if (wave == null && this.me.getOthers() > 0 && !this.target.isRammer()) {
                if (this.distance < 100.0) {
                    this.mirror.setAwayFactor(1.01);
                } else {
                    this.mirror.setAwayFactor(1.0);
                }
                this.mirror.doMove();
                this.dangerForward = 0.0;
                this.dangerBack = 0.0;
                return;
            }
            int circleDir = 1;
            if (this.dangerForward > this.dangerBack) {
                circleDir = -circleDir;
            }
            this.nextDestination = this.getNextPoint(circleDir, this.myLocation, this.getOrbitCenter());
        }
        double theta = FloatingTadpole.absoluteBearing(this.target.getMyLocation(), this.nextDestination) - this.me.getHeadingRadians();
        this.me.setAhead(Math.cos(theta) * 100.0);
        this.me.setTurnRightRadians(Math.tan(theta));
        this.dangerForward = 0.0;
        this.dangerBack = 0.0;
    }

    protected Point2D.Double getNextPoint(int circleDir, Point2D.Double start, Point2D.Double center) {
        Point2D.Double nextPoint;
        double blindManStick;
        double desiredDistance = dynamicDistancingActive ? distancing.findDistanceBracket() - 60 : 525;
        double d = blindManStick = this.target.isRammer() ? jUtil.bindToRange(this.distance / 2.0, 60.0, 170.0) : 170.0;
        double desiredAngle = 1.6707963267948966 + (this.target.isRammer() ? 1.6 : (start.distance(center) > desiredDistance ? -0.1 : 0.5));
        if (this.target.isRammer()) {
            while (!this.innerBF.contains(nextPoint = jUtil.projectMotion(start, FloatingTadpole.absoluteBearing(start, center) - (double)circleDir * (desiredAngle -= 0.1), blindManStick))) {
            }
        } else {
            while (!this.BF.contains(nextPoint = jUtil.projectMotion(start, FloatingTadpole.absoluteBearing(start, center) - (double)circleDir * (desiredAngle -= 0.1), blindManStick))) {
            }
        }
        return nextPoint;
    }

    protected double indexValue(double[] hitBin, double[] visitBin, int gf) {
        double tmp = 0.0;
        int i = 1;
        while (i < hitBin.length) {
            tmp += (hitBin[i] + visitBin[i] / 10.0) / Math.pow(Math.abs(i - gf) + 1, 0.5);
            ++i;
        }
        return tmp;
    }
}

