/*
 * Decompiled with CFR 0.152.
 */
package jdw;

import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Hornet
extends AdvancedRobot {
    private double closest_dist = 1.0E9;
    private String closest_name = "";
    private double closest_x;
    private double closest_y;
    private double closest_x_vel;
    private double closest_y_vel;
    private double closest_energy;
    private boolean hitting = false;

    public void run() {
        this.setBodyColor(Color.black);
        this.setGunColor(Color.yellow);
        this.setRadarColor(Color.black);
        this.setScanColor(Color.yellow);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            if (this.hitting) {
                this.setTurnRightRadians(Math.PI);
                this.hitting = false;
            } else if (this.getTime() % 8L == 0L) {
                this.setTurnRight(Math.random() * 200.0 - 100.0);
                this.setMaxVelocity(Math.random() * 4.0 + 4.0);
                this.setAhead(10000.0);
            }
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(this.closest_x - this.getX(), this.closest_y - this.getY()) - this.getGunHeadingRadians())));
            this.setFire(this.closest_energy / 4.0);
            this.execute();
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.RED);
        g.drawOval((int)this.closest_x - 18, (int)this.closest_y - 18, 36, 36);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (e.getDistance() < this.closest_dist || e.getName() == this.closest_name) {
            this.closest_dist = e.getDistance();
            this.closest_x = this.getX() + Math.sin(e.getBearingRadians() + this.getHeadingRadians()) * this.closest_dist;
            this.closest_y = this.getY() + Math.cos(e.getBearingRadians() + this.getHeadingRadians()) * this.closest_dist;
            this.closest_x_vel = Math.sin(e.getHeadingRadians()) * e.getVelocity();
            this.closest_y_vel = Math.cos(e.getHeadingRadians()) * e.getVelocity();
            this.closest_name = e.getName();
            this.closest_energy = e.getEnergy();
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.hitting = true;
    }

    public void onHitRobot(HitRobotEvent e) {
        this.hitting = true;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.getOthers() < 3) {
            this.hitting = true;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.closest_name) {
            this.closest_dist = 1.0E9;
        }
    }
}

