/*
 * Decompiled with CFR 0.152.
 */
package jbot.tracer.techniques;

import java.awt.Color;
import jbot.Rabbit2;
import jbot.tracer.Target;
import jbot.tracer.techniques.TracerTechnique;
import jbot.util.MathUtil;
import jbot.util.Vector2;
import robocode.Rules;

public class SmoothVelocityTechnique
extends TracerTechnique {
    public SmoothVelocityTechnique(String techName, Rabbit2 bot, Target self, Target target, double initialEfficient, double learnFactor) {
        super(techName, bot, self, target, initialEfficient, learnFactor);
        this.mColor = Color.WHITE;
    }

    public double getShotAngleFor(long shootTime, Vector2 shootPos, double shootPower) {
        Target.Data target = this.mTarget.getHistoryAt(shootTime);
        Target.Data targetLast = this.mTarget.getHistoryAt(shootTime - 1L);
        double shootSpeed = Rules.getBulletSpeed((double)shootPower);
        double v0 = this.mTarget.getSmoothSpeed();
        double w0 = this.mTarget.getSmoothAngleVel();
        double d = this.mTarget.getSmoothAcc();
        double a = 0.5 * target.getDirectionAngle() + 0.5 * targetLast.getDirectionAngle();
        Vector2 dir = new Vector2(a);
        Vector2 distance = target.getPosition().sub(shootPos);
        this.mEstimatedPath.clear();
        int t = 0;
        double lv = v0;
        double v = v0;
        double w = w0;
        do {
            if (Math.abs(v = v0 + d * (double)(++t)) > 8.0) {
                v = 8.0 * (double)MathUtil.sign(v);
            }
            if (lv != v) {
                w = w0;
                double max_turn_rate = MathUtil.degreesToRadians(10.0 - 0.75 * v);
                if (Math.abs(w) > max_turn_rate) {
                    w = max_turn_rate * (double)MathUtil.sign(w);
                }
                lv = v;
            }
            dir.rotate(w);
            Vector2 cur_dir = dir.clone();
            cur_dir.multiply(v);
            distance.add(cur_dir);
            this.mEstimatedPath.add(distance.clone().add(shootPos));
        } while (!(distance.getLength() / shootSpeed > (double)t - 1.0 && distance.getLength() / shootSpeed < (double)t + 1.0) && t <= 40);
        distance.add(shootPos);
        if (distance.getX() < 20.0) {
            distance.setX(20.0);
        } else if (distance.getX() > this.mBot.getBattleFieldWidth() - 20.0) {
            distance.setX(this.mBot.getBattleFieldWidth() - 20.0);
        }
        if (distance.getY() < 20.0) {
            distance.setY(20.0);
        } else if (distance.getY() > this.mBot.getBattleFieldHeight() - 20.0) {
            distance.setY(this.mBot.getBattleFieldHeight() - 20.0);
        }
        distance.sub(shootPos);
        return distance.getAngle();
    }
}

