/*
 * Decompiled with CFR 0.152.
 */
package EH;

import ags.surreptitious.info.EnemyInfo;
import ags.surreptitious.info.StatusInfo;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RobotStatus;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Eagle
extends AdvancedRobot {
    private Map<String, EnemyInfo> enemies = new HashMap<String, EnemyInfo>();
    private StatusInfo status = new StatusInfo();
    AbsolutePoint gGoal;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.gray, Color.orange, Color.black);
        this.setScanColor(Color.red);
        while (true) {
            this.move();
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            this.execute();
        }
    }

    public void onPaint(Graphics2D g) {
        RelativePoint r1 = RelativePoint.fromDM(this.status.velocity.direction + 1.5707963267948966, 114.55);
        RelativePoint r2 = RelativePoint.fromDM(this.status.velocity.direction - 1.5707963267948966, 114.55);
        AbsolutePoint a1 = this.status.location.addRelativePoint(r1);
        AbsolutePoint a2 = this.status.location.addRelativePoint(r2);
        g.setColor(Color.blue);
        g.drawOval((int)a1.x - 114, (int)a1.y - 114, 229, 229);
        g.drawOval((int)a2.x - 114, (int)a2.y - 114, 229, 229);
        g.setColor(Color.green);
        g.fillOval((int)a1.x - 2, 16, 5, 5);
        g.fillOval((int)a1.x - 2, (int)this.getBattleFieldHeight() - 18 - 2, 5, 5);
        g.fillOval(16, (int)a1.y - 2, 5, 5);
        g.fillOval((int)this.getBattleFieldHeight() - 18 - 2, (int)a1.y - 2, 5, 5);
        g.fillOval((int)a2.x - 2, 16, 5, 5);
        g.fillOval((int)a2.x - 2, (int)this.getBattleFieldHeight() - 18 - 2, 5, 5);
        g.fillOval(16, (int)a2.y - 2, 5, 5);
        g.fillOval((int)this.getBattleFieldHeight() - 18 - 2, (int)a2.y - 2, 5, 5);
        g.setColor(Color.red);
        if (this.gGoal != null) {
            g.fillOval((int)this.gGoal.getX() - 2, (int)this.gGoal.getY() - 2, 5, 5);
        }
    }

    private void move() {
        double bestDanger = Double.POSITIVE_INFINITY;
        RelativePoint bestGoal = null;
        AbsolutePoint momentumPoint = this.status.location.addRelativePoint(this.status.velocity);
        AbsolutePoint.fromXY(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
        double a = 0.0;
        while (a < Math.PI * 2) {
            double d = 100.0;
            while (d < 300.0) {
                RelativePoint rGoal = RelativePoint.fromDM(a, d);
                AbsolutePoint aGoal = this.status.location.addRelativePoint(rGoal);
                double danger = 0.0;
                for (EnemyInfo e : this.enemies.values()) {
                    double angle = Utils.normalAbsoluteAngle((double)Math.atan2(aGoal.getX() - e.getLocation().getX(), aGoal.getY() - e.getLocation().getY()));
                    double p = Math.abs(Math.cos(a - angle));
                    double dist = e.getLocation().distance(aGoal);
                    danger += (1.0 + p) / (dist * dist);
                }
                danger -= 0.005 / aGoal.distance(momentumPoint);
                danger += 7.0E-4 / Math.pow(Math.max(0.0, aGoal.getX() - 18.0), 4.0);
                danger += 7.0E-4 / Math.pow(Math.max(0.0, aGoal.getY() - 18.0), 4.0);
                danger += 7.0E-4 / Math.pow(Math.max(0.0, this.getBattleFieldWidth() - aGoal.getX() - 18.0), 4.0);
                if ((danger += 7.0E-4 / Math.pow(Math.max(0.0, this.getBattleFieldHeight() - aGoal.getY() - 18.0), 4.0)) < bestDanger) {
                    bestDanger = danger;
                    bestGoal = rGoal;
                    this.gGoal = aGoal;
                }
                d += 20.0;
            }
            a += 0.06283185307179587;
        }
        if (bestGoal != null) {
            this.goToPoint(bestGoal);
        }
    }

    public void goToPoint(RelativePoint goal) {
        double ahead;
        double turn = goal.getDirDist(this.status.velocity.direction);
        if (Math.abs(turn) > 1.5707963267948966) {
            turn = Utils.normalRelativeAngle((double)(turn + Math.PI));
            ahead = -goal.getMagnitude();
        } else {
            ahead = goal.getMagnitude();
        }
        double maxV = Math.max(0.0, Math.min(8.0, (10.0 - Math.toDegrees(turn / 10.0)) / 0.75));
        double velocity = Math.max(Math.min(maxV, ahead), -maxV);
        this.setAhead(ahead);
        this.setMaxVelocity(Math.abs(velocity));
        this.setTurnRightRadians(turn);
    }

    public void onStatus(StatusEvent e) {
        RobotStatus s = e.getStatus();
        this.status.location = AbsolutePoint.fromXY(s.getX(), s.getY());
        this.status.velocity = RelativePoint.fromDM(s.getHeadingRadians(), s.getVelocity());
        for (EnemyInfo enemy : this.enemies.values()) {
            enemy.isNew = false;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
        double bulletPower = this.getEnergy() / 28.0;
        double headOnBearing = this.getHeadingRadians() + e.getBearingRadians();
        double linearBearing = headOnBearing + Math.asin(e.getVelocity() / Rules.getBulletSpeed((double)bulletPower) * Math.sin(e.getHeadingRadians() - headOnBearing));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(linearBearing - this.getGunHeadingRadians())));
        this.setFire(bulletPower);
        EnemyInfo enemy = this.enemies.get(e.getName());
        if (enemy == null) {
            enemy = new EnemyInfo(e.getName());
            this.enemies.put(e.getName(), enemy);
        }
        enemy.handleEvent(this.status, e);
        enemy.isNew = true;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.enemies.remove(e.getName());
    }

    public void onWin(WinEvent e) {
        this.setColors(Color.red, Color.red, Color.red);
        this.turnRadarRight(360.0);
        this.setColors(Color.green, Color.green, Color.green);
        this.turnRadarRight(360.0);
        this.setColors(Color.blue, Color.blue, Color.blue);
        this.turnRadarRight(360.0);
        this.setColors(Color.black, Color.black, Color.black);
        this.out.println("Come on!");
        this.setBulletColor(Color.green);
    }

    public void onDeath(DeathEvent e) {
        this.setBulletColor(Color.red);
        this.out.println("I died when there were " + this.getOthers() + " robots left.");
        this.out.println("AAAAURGH");
    }

    public void onHitWall(HitWallEvent e) {
        this.out.println("HIT WALL ON TURN " + e.getTime());
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.out.println("SKIPPED TURN ON TURN " + e.getTime());
    }
}

