/*
 * Decompiled with CFR 0.152.
 */
package spinnercat.mega;

import java.awt.geom.Point2D;
import robocode.util.Utils;

public class Wave {
    private double startX;
    private double startY;
    private double startBearing;
    private double power;
    private long fireTime;
    private int direction;
    private int[] returnSegment;
    int weight;
    public int radius = 0;

    public Wave(double x, double y, double b, double pow, long time, int dir, int[] seg, int w) {
        this.startX = x;
        this.startY = y;
        this.startBearing = b;
        this.power = pow;
        this.fireTime = time;
        this.direction = dir;
        this.returnSegment = seg;
        this.weight = w;
    }

    public double getBulletSpeed() {
        return 20.0 - 3.0 * this.power;
    }

    public double maxEscapeAngle() {
        return Math.asin(8.0 / this.getBulletSpeed());
    }

    public void expand() {
        this.radius = (int)((double)this.radius + this.getBulletSpeed());
    }

    public boolean checkHit(double ex, double ey, long time) {
        if (Point2D.Double.distance(this.startX, this.startY, ex, ey) <= (double)(time - this.fireTime) * this.getBulletSpeed()) {
            int index;
            double dd = this.absoluteBearing(this.startX, this.startY, ex, ey);
            double offset = Utils.normalRelativeAngle((double)(dd - this.startBearing));
            double gf = Math.min(Math.max(offset / this.maxEscapeAngle(), -1.0), 1.0) * (double)this.direction;
            int n = index = (int)Math.round((gf + 1.0) * (double)(this.returnSegment.length - 1) / 2.0);
            this.returnSegment[n] = this.returnSegment[n] + this.weight;
            return true;
        }
        return false;
    }

    private double absoluteBearing(double x1, double y1, double x2, double y2) {
        return Math.atan2(x2 - x1, y2 - y1);
    }
}

