/*
 * Decompiled with CFR 0.152.
 */
package cb.ml;

import cb.ml.Features;
import cb.ml.ObservationType;
import cb.ml.Targeting;
import cb.util.KdTree;
import java.util.List;

public class DomogledTargeting
implements Targeting {
    private static final int BINS = 31;
    private static final int DIMENSIONS = 7;
    private KdTree<Double> tree = new KdTree.Manhattan<Double>(7, 500);

    @Override
    public void addPoint(Features features, double guessFactor, ObservationType observationType) {
        if (observationType != ObservationType.BULLETHITBULLET) {
            this.tree.addPoint(this.getLocation(features), guessFactor);
        }
    }

    @Override
    public double aim(Features features) {
        List<KdTree.Entry<Double>> entries = this.tree.nearestNeighbor(this.getLocation(features), 13, false);
        double[] c = new double[31];
        for (KdTree.Entry<Double> entry : entries) {
            int index = (int)Math.round(15.0 * ((Double)entry.value + 1.0));
            for (int i = 0; i < 31; ++i) {
                int n = i;
                c[n] = c[n] + 1.0 / (1.0 + Math.pow(i - index, 2.0)) / (1.0 + entry.distance);
            }
        }
        int best = 15;
        for (int i = 0; i < 31; ++i) {
            if (!(c[i] > c[best])) continue;
            best = i;
        }
        return (double)(best - 15) / 15.0;
    }

    private double[] getLocation(Features features) {
        double[] location = new double[]{features.getFeature("opponentAdvancingVelocity") / 16.0, features.getFeature("myBulletPower") / 3.0, 1.0 / (1.0 + features.getFeature("distance") / 160.0), features.getFeature("opponentLateralVelocity") / 8.0, 1.0 / (1.0 + features.getFeature("opponentTimeSinceLastDeceleration") / 10.0), features.getFeature("opponentForwardWall"), features.getFeature("opponentBackwardWall")};
        return location;
    }
}

