/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import morbid.BrokeredObject;
import morbid.IEnemySelectionStrategy;
import morbid.IEventListener;
import morbid.IMotionManager;
import morbid.IMotionStrategy;
import morbid.IObject;
import morbid.IRobotController;
import morbid.IRobotPositionManager;
import morbid.Utils;
import robocode.Event;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;

class BasicRandomMotionStrategy
extends BrokeredObject
implements IEventListener,
IMotionStrategy {
    protected final Random m_random;
    protected final double[] m_xy = new double[2];
    protected final double m_size;
    protected final double m_field_width;
    protected final double m_field_height;
    protected final List m_obstacleEvents;
    protected final Set m_robotIDs;
    protected final List m_collisionHeadings;
    private static final Class[] ACCEPTABLE_EVENTS = new Class[]{class$robocode$HitRobotEvent == null ? (class$robocode$HitRobotEvent = BasicRandomMotionStrategy.class$("robocode.HitRobotEvent")) : class$robocode$HitRobotEvent, class$robocode$HitWallEvent == null ? (class$robocode$HitWallEvent = BasicRandomMotionStrategy.class$("robocode.HitWallEvent")) : class$robocode$HitWallEvent};
    private static final double RANDOM_SHIFT = 100.0;
    private static final double TR_DISTANCE_TO_DESTINATION = 10.0;
    private static final long TR_ENROUTE_TIME = 4L;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$robocode$HitRobotEvent;
    static /* synthetic */ Class class$robocode$HitWallEvent;

    public BasicRandomMotionStrategy(IRobotController controller) {
        super("MOTION_STRATEGY", controller);
        this.m_random = new Random(System.currentTimeMillis());
        this.m_size = Math.ceil(0.5 * Utils.relativeDistance(0.0, 0.0, this.m_robot.getWidth(), this.m_robot.getHeight()));
        this.m_field_width = this.m_robot.getBattleFieldWidth();
        this.m_field_height = this.m_robot.getBattleFieldHeight();
        this.m_obstacleEvents = new ArrayList();
        this.m_robotIDs = new HashSet();
        this.m_collisionHeadings = new ArrayList();
    }

    public Class[] getAcceptableEventTypes() {
        return ACCEPTABLE_EVENTS;
    }

    public void acceptEvent(Event event) {
        if (this.isActive()) {
            this.m_obstacleEvents.add(event);
        }
    }

    public double getGoToX() {
        if (!this.isUpdated()) {
            if (!this.handleObstacleEvents(this.m_xy)) {
                this.computeNextGoTo(this.m_xy);
            }
            this.markAsUpdated();
        }
        return this.m_xy[0];
    }

    public double getGoToY() {
        if (!this.isUpdated()) {
            if (!this.handleObstacleEvents(this.m_xy)) {
                this.computeNextGoTo(this.m_xy);
            }
            this.markAsUpdated();
        }
        return this.m_xy[1];
    }

    protected void activate() {
        super.activate();
        this.clearEvents();
        this.m_xy[0] = this.m_robot.getX();
        this.m_xy[1] = this.m_robot.getY();
    }

    protected void passivate() {
        this.clearEvents();
        super.passivate();
    }

    protected double bid() {
        return 0.0;
    }

    protected boolean handleObstacleEvents(double[] out) {
        if (!this.m_obstacleEvents.isEmpty()) {
            this.m_robotIDs.clear();
            this.m_collisionHeadings.clear();
            int e = this.m_obstacleEvents.size() - 1;
            while (e >= 0) {
                HitRobotEvent event;
                Event _event = (Event)this.m_obstacleEvents.get(e);
                if (_event instanceof HitRobotEvent) {
                    event = (HitRobotEvent)_event;
                    if (!this.m_robotIDs.contains(event.getName())) {
                        this.m_robotIDs.add(event.getName());
                        this.m_collisionHeadings.add(new Double(event.getBearingRadians()));
                    }
                } else if (_event instanceof HitWallEvent) {
                    event = (HitWallEvent)_event;
                    this.m_collisionHeadings.add(new Double(event.getBearingRadians()));
                }
                --e;
            }
            double netHeadingX = 0.0;
            double netHeadingY = 0.0;
            int h = 0;
            int hSize = this.m_collisionHeadings.size();
            while (h < hSize) {
                double heading = (Double)this.m_collisionHeadings.get(h) + this.m_robot.getHeadingRadians();
                netHeadingX += Math.sin(heading);
                netHeadingY += Math.cos(heading);
                ++h;
            }
            double netHeading = Utils.reversePhi(Utils.relativeHeading(0.0, 0.0, netHeadingX, netHeadingY));
            out[0] = this.m_robot.getX() + this.m_size * Math.sin(netHeading += 0.15 * (0.5 - this.m_random.nextDouble()));
            out[1] = this.m_robot.getY() + this.m_size * Math.cos(netHeading);
            this.clearEvents();
            return true;
        }
        return false;
    }

    protected void computeNextGoTo(double[] out) {
        switch (this.m_controller.getRobotPositionManager().getKnownAliveObjectCount()) {
            case 0: {
                out[0] = 0.5 * this.m_robot.getBattleFieldWidth();
                out[1] = 0.5 * this.m_robot.getBattleFieldHeight();
                break;
            }
            case 1: {
                IEnemySelectionStrategy enemySelectionStrategy = this.m_controller.getEnemySelectionStrategy();
                IRobotPositionManager.ITrackedRobot enemy = enemySelectionStrategy.selectEnemy();
                if (enemy == null) {
                    this.defaultNextGoTo(out, false);
                    break;
                }
                this.sidestepNextGoTo(out, enemy);
                break;
            }
            default: {
                IEnemySelectionStrategy enemySelectionStrategy = this.m_controller.getEnemySelectionStrategy();
                IRobotPositionManager.ITrackedRobot enemy = enemySelectionStrategy.selectEnemy();
                if (enemy == null) {
                    this.defaultNextGoTo(out, false);
                    break;
                }
                this.sidestepNextGoTo(out, enemy);
            }
        }
    }

    protected void sidestepNextGoTo(double[] out, IRobotPositionManager.ITrackedRobot enemy) {
        IMotionManager motionManager = this.m_controller.getMotionManager();
        if (motionManager.isStationary() || motionManager.distanceToDestination() < 10.0 || motionManager.onRouteTime() > 4L) {
            double enemy_relative_distance;
            IObject.ITrackedObjectTimeSeries enemy_series = enemy.getTimeSeries();
            double[] interpolated_enemy = new double[5];
            interpolated_enemy[0] = -1.0;
            if (enemy_series.size() >= 2) {
                Utils.interpolate2(this.m_robot.out, interpolated_enemy, enemy_series, this.m_robot.getTime() - 3L, this.m_robot.getTime() + 1L, this.m_robot.getBattleFieldWidth(), this.m_robot.getBattleFieldHeight());
            }
            if (interpolated_enemy[0] < 0.0) {
                double[] interpolated_enemy_xy = new double[2];
                Utils.interpolate(interpolated_enemy_xy, enemy.getX(), enemy.getY(), enemy.getHeadingRadians(), enemy.getVelocity(), 1.0);
                interpolated_enemy[1] = interpolated_enemy_xy[0];
                interpolated_enemy[2] = interpolated_enemy_xy[1];
                interpolated_enemy[3] = enemy.getHeadingRadians();
                interpolated_enemy[4] = enemy.getVelocity();
            }
            double new_enemy_relative_distance = (enemy_relative_distance = Utils.relativeDistance(this.m_robot.getX(), this.m_robot.getY(), interpolated_enemy[1], interpolated_enemy[2])) < 80.0 ? 2.0 * enemy_relative_distance + 10.0 : 0.8 * enemy_relative_distance + (double)this.m_random.nextInt(20);
            double relative_heading_from_enemy = Utils.relativeHeading(interpolated_enemy[1], interpolated_enemy[2], this.m_robot.getX(), this.m_robot.getY());
            double random_relative_heading_change = 0.17453292519943295 * this.m_random.nextDouble() + Math.atan(this.m_size / enemy_relative_distance);
            if (this.m_random.nextBoolean()) {
                random_relative_heading_change = -random_relative_heading_change;
            }
            double new_relative_heading_from_enemy = relative_heading_from_enemy + random_relative_heading_change;
            out[0] = enemy.getX() + new_enemy_relative_distance * Math.sin(new_relative_heading_from_enemy);
            out[1] = enemy.getY() + new_enemy_relative_distance * Math.cos(new_relative_heading_from_enemy);
            this.avoidWalls(out);
        }
    }

    protected void defaultNextGoTo(double[] out, boolean force) {
        IMotionManager motionManager = this.m_controller.getMotionManager();
        if (force || motionManager.isStationary() || motionManager.distanceToDestination() < 10.0 || motionManager.onRouteTime() > 4L) {
            out[0] = this.m_robot.getX() + 100.0 * (0.5 - this.m_random.nextDouble());
            out[1] = this.m_robot.getY() + 100.0 * (0.5 - this.m_random.nextDouble());
            this.avoidWalls(out);
        }
    }

    protected void avoidWalls(double[] out) {
        double nextX = out[0];
        double nextY = out[1];
        if (nextX < this.m_size) {
            nextX = this.m_size * (1.0 + 2.0 * this.m_random.nextDouble());
        } else if (nextX > this.m_field_width - this.m_size) {
            nextX = this.m_field_width - this.m_size * (1.0 + 2.0 * this.m_random.nextDouble());
        }
        if (nextY < this.m_size) {
            nextY = this.m_size * (1.0 + 2.0 * this.m_random.nextDouble());
        } else if (nextY > this.m_field_height - this.m_size) {
            nextY = this.m_field_height - this.m_size * (1.0 + 2.0 * this.m_random.nextDouble());
        }
        out[0] = nextX;
        out[1] = nextY;
    }

    protected void clearEvents() {
        this.m_obstacleEvents.clear();
        this.m_robotIDs.clear();
        this.m_collisionHeadings.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

