/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import morbid.FieldAwareObject;
import morbid.IRobotController;
import morbid.IWeaponManager;
import morbid.IWeaponStrategy;
import morbid.Utils;
import robocode.Bullet;

class WeaponManager
extends FieldAwareObject
implements IWeaponManager {
    private Bullet m_firedBullet;
    private static final boolean DEBUG = false;

    public void update() {
        this.m_firedBullet = null;
    }

    public void act() {
        IWeaponStrategy weaponStrategy = this.m_controller.getWeaponStrategy();
        this.rotateGunTo(weaponStrategy.getGunPosition());
        double firePower = weaponStrategy.getFirePower();
        if (firePower > 0.0) {
            this.m_firedBullet = this.m_robot.setFireBullet(firePower);
        }
    }

    public void rotateGunTo(double phi) {
        double gunphi = this.m_robot.getGunHeadingRadians();
        double deltaphi = Utils.deltaPhi(phi, gunphi);
        this.setTurnGun(deltaphi);
    }

    public Bullet getFiredBullet() {
        return this.m_firedBullet;
    }

    public int getTimeToGunCool() {
        double gunHeat = this.m_robot.getGunHeat();
        double gunCoolingRate = this.m_robot.getGunCoolingRate();
        double ticks = Math.ceil(gunHeat / gunCoolingRate);
        return (int)ticks;
    }

    WeaponManager(IRobotController controller) {
        super(controller);
    }

    void setTurnGun(double phi) {
        if (phi > 0.0) {
            this.m_robot.setTurnGunRightRadians(phi);
        } else if (phi < 0.0) {
            this.m_robot.setTurnGunLeftRadians(-phi);
        }
    }
}

