/*
 * Decompiled with CFR 0.152.
 */
package pedersen.debug;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.core.Conversions;
import pedersen.debug.RenderableLineSegment;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;

public class GraphicalDebugger {
    public static final GraphicalDebugger singleton = new GraphicalDebugger();
    private static final List renderableLineSegmentsBattle = new ArrayList();
    private static final List renderableLineSegmentsRound = new ArrayList();
    private static final List renderableLineSegmentsTurn = new ArrayList();
    private static final List markersTurn1 = new ArrayList();
    private static final List markersTurn2 = new ArrayList();

    private GraphicalDebugger() {
    }

    public void drawVehicleHitBox(Graphics2D console, StaticPosition center) {
        console.draw(Conversions.getRectangle2DForRobot(center));
    }

    public void drawVehicleHitBox(Graphics2D console, Rectangle2D.Double hitbox) {
        console.draw(hitbox);
    }

    public void drawVehicleHitBoxes(Graphics2D console, List lines) {
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            this.drawVehicleHitBox(console, (StaticPosition)iterator.next());
        }
    }

    public void drawMarker(Graphics2D console, StaticPosition center) {
        console.draw(new Rectangle2D.Double(center.getX() - 2.0, center.getY() - 2.0, 4.0, 4.0));
    }

    public void drawMarkers(Graphics2D console, List lines, Color color) {
        console.setColor(color);
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            this.drawMarker(console, (StaticPosition)iterator.next());
        }
    }

    public void drawMarkerRing(Graphics2D console, StaticPosition center) {
        this.drawRing(console, center, 2.0);
    }

    public void drawRing(Graphics2D console, StaticPosition center, double radius) {
        console.draw(new Ellipse2D.Double(center.getX() - radius, center.getY() - radius, radius + radius, radius + radius));
    }

    public void drawRings(Graphics2D console, List centers, double radius) {
        Iterator iterator = centers.iterator();
        while (iterator.hasNext()) {
            this.drawRing(console, (StaticPosition)iterator.next(), radius);
        }
    }

    public void drawLine(Graphics2D console, StaticPosition a, StaticPosition b) {
        console.draw(Conversions.getLine2D(a, b));
    }

    public void drawRenderableLineSegment(Graphics2D console, RenderableLineSegment line) {
        console.setColor(line.color);
        console.draw(new Line2D.Double(line.x1, line.y1, line.x2, line.y2));
    }

    public void drawRenderableLineSegments(Graphics2D console, List lines) {
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            this.drawRenderableLineSegment(console, (RenderableLineSegment)iterator.next());
        }
    }

    public static void addRenderableLineSegmentBattleScope(StaticPosition a, StaticPosition b, Color c) {
        renderableLineSegmentsBattle.add(new RenderableLineSegment(a, b, c));
    }

    public static void addRenderableLineSegmentRoundScope(StaticPosition a, StaticPosition b, Color c) {
        renderableLineSegmentsRound.add(new RenderableLineSegment(a, b, c));
    }

    public static void addRenderableLineSegmentTurnScope(StaticPosition a, StaticPosition b, Color c) {
        renderableLineSegmentsTurn.add(new RenderableLineSegment(a, b, c));
    }

    public static void addRenderableLineSegmentBattleScope(Line2D.Double line, Color c) {
        renderableLineSegmentsBattle.add(new RenderableLineSegment(line, c));
    }

    public static void addRenderableLineSegmentRoundScope(Line2D.Double line, Color c) {
        renderableLineSegmentsRound.add(new RenderableLineSegment(line, c));
    }

    public static void addRenderableLineSegmentTurnScope(Line2D.Double line, Color c) {
        renderableLineSegmentsTurn.add(new RenderableLineSegment(line, c));
    }

    public static void addMarkerTurnScope1(StaticPosition a) {
        markersTurn1.add(a);
    }

    public static void addMarkerTurnScope2(StaticPosition a) {
        markersTurn2.add(a);
    }

    public static void addMarkerTurnScope1(double x, double y) {
        markersTurn1.add(new StaticPositionImpl(x, y));
    }

    public static void addMarkerTurnScope2(double x, double y) {
        markersTurn2.add(new StaticPositionImpl(x, y));
    }

    public void onRoundSetup() {
        renderableLineSegmentsRound.clear();
    }

    public void onTurnSetup() {
        renderableLineSegmentsTurn.clear();
        markersTurn1.clear();
        markersTurn2.clear();
    }

    public void onPaint(Graphics2D console) {
        this.drawRenderableLineSegments(console, renderableLineSegmentsBattle);
        this.drawRenderableLineSegments(console, renderableLineSegmentsRound);
        this.drawRenderableLineSegments(console, renderableLineSegmentsTurn);
        this.drawMarkers(console, markersTurn2, Color.orange);
    }
}

