/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.weapon;

import rampancy.util.REnemyRobot;
import rampancy.util.wave.RBulletWave;
import rampancy.util.weapon.RFiringSolution;
import rampancy.util.weapon.RGunStatistic;

public abstract class RGun {
    protected String name;
    protected RGunStatistic stat = new RGunStatistic();

    public RGun(String name) {
        this.name = name;
    }

    public abstract RFiringSolution getFiringSolution(REnemyRobot var1);

    public void update(RBulletWave wave) {
        if (wave.didHitEnemy()) {
            this.noteHit(!wave.isVirtual());
        }
    }

    public void updateNewRound() {
    }

    public void noteShot(boolean real) {
        if (real) {
            this.stat.realShotsFired += 1.0;
        } else {
            this.stat.simulatedShotsFired += 1.0;
        }
    }

    public void noteHit(boolean real) {
        if (real) {
            this.stat.realShotsHit += 1.0;
        } else {
            this.stat.simulatedShotsHit += 1.0;
        }
    }

    public RGunStatistic getStats() {
        return this.stat;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.name) + " real " + this.stat.getRealHitPercent() + "%, virtual " + this.stat.getVirtualHitPercent() + "%";
    }

    public String getOverview() {
        return this.toString();
    }
}

