/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

import wcsv.mega.Location;
import wcsv.mega.ScanInfo;

public class Utils {
    public static double PI = Math.PI;
    public static double TWOPI = Math.PI * 2;
    public static double HALFPI = 1.5707963267948966;
    public static double f_width;
    public static double f_height;

    public static double bulletVel(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static int wallIndex(Location center, ScanInfo scan, double[] segs, double dir) {
        int i = 0;
        while (i < segs.length) {
            if (Utils.outside_field(center.project(scan.last().getBearing() + segs[i] * dir, scan.last().getDistance()))) {
                return i;
            }
            ++i;
        }
        return segs.length;
    }

    public static boolean outside_field(Location loc) {
        return loc.getX() < 0.0 || loc.getX() > f_width || loc.getY() < 0.0 || loc.getY() > f_height;
    }

    public static boolean outside_border(Location loc, double border) {
        return loc.getX() < border || loc.getX() > f_width - border || loc.getY() < border || loc.getY() > f_height - border;
    }

    public static double max_escape(double b_vel) {
        return Math.asin(8.0 / b_vel);
    }

    public static double maxTurnRate(double vel) {
        return PI / 18.0 - PI / 240.0 * Math.abs(vel);
    }

    public static double relAngle(double angle) {
        if (angle > -PI && angle <= PI) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -PI) {
            fixedAngle += TWOPI;
        }
        while (fixedAngle > PI) {
            fixedAngle -= TWOPI;
        }
        return fixedAngle;
    }

    public static double absAngle(double angle) {
        if (angle >= 0.0 && angle < TWOPI) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += TWOPI;
        }
        while (fixedAngle >= TWOPI) {
            fixedAngle -= TWOPI;
        }
        return fixedAngle;
    }

    public static int getIndex(double val, double[] segs) {
        int i = 0;
        while (i < segs.length) {
            if (val <= segs[i]) {
                return i;
            }
            ++i;
        }
        return segs.length;
    }

    public static double bindRange(double val, double low, double high) {
        if (val < low) {
            return low;
        }
        if (val > high) {
            return high;
        }
        return val;
    }

    public static double rollingAvg(double value, double newValue, double readings, double depth) {
        readings = Math.min(readings, depth);
        return (value * readings + newValue) / (readings + 1.0);
    }
}

