/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Engineer.Utilities;

import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.ListIterator;
import wcsv.Engineer.Utilities.Target;
import wcsv.Engineer.Utilities.Utilities;

public class Wave {
    public Target targetRobot;
    public Target sourceRobot;
    public int startTime;
    public double velocity;
    public boolean isRealBullet;

    public Wave cloneWave() {
        Wave w = new Wave();
        w.targetRobot = this.targetRobot.cloneTarget();
        w.sourceRobot = this.sourceRobot.cloneTarget();
        w.velocity = this.velocity;
        w.startTime = this.startTime;
        w.isRealBullet = this.isRealBullet;
        return w;
    }

    public double radius(int time) {
        return (double)(time - this.startTime) * this.velocity;
    }

    public double distanceToPoint(Point2D.Double loc, int time) {
        return Utilities.distance(loc, this.sourceRobot.location) - this.radius(time);
    }

    public int timeToPoint(Point2D.Double loc, int time) {
        return (int)(this.distanceToPoint(loc, time) / this.velocity);
    }

    public double computeCentralBearingChange(Point2D.Double newLocation) {
        return Utilities.relativeAngle(Utilities.absoluteAngleToPoint(this.sourceRobot.location, newLocation) - Utilities.absoluteAngleToPoint(this.sourceRobot.location, this.targetRobot.location));
    }

    public double absoluteBearingFromSource(Point2D.Double newLocation) {
        return Utilities.absoluteAngleToPoint(this.sourceRobot.location, newLocation);
    }

    public static Wave getClosestWave(Point2D.Double loc, LinkedList waves, int time) {
        ListIterator it = waves.listIterator();
        double closestDist = Double.MAX_VALUE;
        Wave w = null;
        Wave closest = null;
        while (it.hasNext()) {
            w = (Wave)it.next();
            double currDist = Math.abs(w.distanceToPoint(loc, time));
            if (!(currDist < closestDist)) continue;
            closest = w;
            closestDist = currDist;
        }
        return closest;
    }

    public Wave() {
    }

    public Wave(Target src, Target targ, double bulletPower, int time, boolean real) {
        this.targetRobot = targ.cloneTarget();
        this.sourceRobot = src.cloneTarget();
        this.velocity = Utilities.bulletPowerToVelocity(bulletPower);
        this.startTime = time;
        this.isRealBullet = real;
    }
}

