/*
 * Decompiled with CFR 0.152.
 */
package bing2;

import bing2.MathUtils;
import bing2.Position;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public abstract class MyRobot
extends AdvancedRobot {
    static final double RobotSize = 36.0;
    static final int DEFAULT_OUTPUT_LEVEL = 3;
    boolean debug = true;
    int outputLevel = 3;
    long lastTime;
    double timeSinceLastScan = 9999.0;
    double enemyAbsoluteBearing;
    static double SCAN_ANGLE = 0.02;
    static Random rand = new Random();

    public void run() {
        this.initRobot();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.doScanner();
            this.doMove();
            this.doGun();
            this.doLog("Execute", 1);
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.enemyAbsoluteBearing = this.getHeadingRadians() + scannedRobotEvent.getBearingRadians();
        this.timeSinceLastScan = 0.0;
    }

    void doScanner() {
        this.timeSinceLastScan += 1.0;
        double d = Double.POSITIVE_INFINITY;
        if (this.getOthers() == 1 && this.timeSinceLastScan < 3.0) {
            d = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - this.enemyAbsoluteBearing));
            d += (double)MathUtils.sign(d) * SCAN_ANGLE;
        }
        this.setTurnRadarLeftRadians(d);
    }

    public final void doLog(Object object) {
        this.doLog(object, 3);
    }

    public final void doLog(Object object, int n) {
        if (!this.debug || n < this.outputLevel) {
            return;
        }
        if (this.lastTime != this.getTime()) {
            System.out.println("-------------------------");
            this.lastTime = this.getTime();
        }
        System.out.println("[" + this.getTime() + "]: " + object.toString());
    }

    public final void assertMsg(boolean bl, String string) {
        if (!bl) {
            this.doLog(string, 5);
        }
    }

    public String toString() {
        return this.getName() + ": " + "\n+ position: " + new Position(this.getX(), this.getY()) + "\n+ heading: " + MathUtils.normalizeDegrees(this.getHeading(), -180.0) + "\n+ velocity: " + this.getVelocity() + "\n+ energy: " + this.getEnergy() + "\n+ turn remaining: " + this.getTurnRemaining() + "\n+ move remaining: " + this.getDistanceRemaining() + "\n+ gun heading: " + MathUtils.normalizeDegrees(this.getGunHeading(), -180.0) + "\n+ radar heading: " + MathUtils.normalizeDegrees(this.getRadarHeading(), -180.0) + "\n+ gun turn remaining: " + this.getGunTurnRemaining() + "\n+ radar turn remaining: " + this.getRadarTurnRemaining() + "\n";
    }

    public final double getRobotTurnRate() {
        return 0.17453292519943295 - 0.01308996938995747 * Math.abs(this.getVelocity());
    }

    public Position getPosition() {
        return new Position(this.getX(), this.getY());
    }

    abstract void initRobot();

    abstract void doGun();

    abstract void doMove();
}

