/*
 * Decompiled with CFR 0.152.
 */
package barontrozo;

import barontrozo.BulletFollower;
import java.awt.geom.Point2D;
import robocode.Rules;
import robocode.util.Utils;

public class StatusBuilder {
    static final int dimensions_ = 7;
    static double fieldWidth_;
    static double fieldHeight_;

    static int GetDimension() {
        return 7;
    }

    public static void SetDimesions(double fieldWidth, double fieldHeight) {
        fieldWidth_ = fieldWidth;
        fieldHeight_ = fieldHeight;
    }

    public static double[] GetStatusArrayFromBulletFollower(BulletFollower follower) {
        return StatusBuilder.GetStatusArray(follower.targetPos_, follower.velTarget_, follower.headingTarget_, follower.firePos_, follower.bulletPower_, follower.angleBegin_, follower.angleArc_);
    }

    public static double[] GetStatusArray(Point2D.Double targetPos, double vel, double heading, Point2D.Double firePos, double power, double angleBegin, double angleArc) {
        double[] ret = new double[7];
        if (vel < 0.0) {
            vel = -vel;
            heading = Utils.normalRelativeAngle((double)(heading + Math.PI));
        }
        double dist = targetPos.distance(firePos) / Rules.getBulletSpeed((double)power);
        double ang1 = Utils.normalAbsoluteAngle((double)(Math.atan2(targetPos.getX() - firePos.getX(), targetPos.getX() - firePos.getX()) - angleBegin));
        double ang2 = angleArc - ang1;
        ret[0] = vel;
        ret[1] = dist;
        if (heading >= 0.0) {
            ret[2] = heading;
            ret[3] = ang1;
            ret[4] = ang2;
            ret[5] = StatusBuilder.GetDistanceTurnToWall(targetPos, heading, 1.0);
            ret[6] = StatusBuilder.GetDistanceTurnToWall(targetPos, heading, -1.0);
        } else {
            ret[2] = -heading;
            ret[3] = ang2;
            ret[4] = ang1;
            ret[5] = StatusBuilder.GetDistanceTurnToWall(targetPos, -heading, 1.0);
            ret[6] = StatusBuilder.GetDistanceTurnToWall(targetPos, -heading, -1.0);
        }
        return ret;
    }

    public static void FillMaxAndMin(double[] max, double[] min) {
        max[0] = 8.0;
        min[0] = 0.0;
        double maxDist = Math.sqrt(fieldWidth_ * fieldWidth_ + fieldHeight_ * fieldHeight_);
        max[1] = maxDist / Rules.getBulletSpeed((double)3.0);
        min[1] = 0.0;
        max[2] = Math.PI;
        min[2] = 0.0;
        max[3] = Math.PI;
        min[3] = 0.0;
        max[4] = Math.PI;
        min[4] = 0.0;
        max[5] = maxDist;
        min[5] = 0.0;
        max[6] = maxDist;
        min[6] = 0.0;
    }

    static boolean IsOut(Point2D.Double pos) {
        return pos.getX() < 0.0 || pos.getY() < 0.0 || pos.getX() > fieldWidth_ || pos.getY() > fieldHeight_;
    }

    static double GetDistanceTurnToWall(Point2D.Double pos, double heading, double sense) {
        double turn = 0.0;
        double vel = 8.0 * sense;
        Point2D.Double wPos = new Point2D.Double(pos.getX(), pos.getY());
        while (!StatusBuilder.IsOut(wPos)) {
            wPos.setLocation(wPos.getX() + Math.sin(heading) * vel, wPos.getY() + Math.cos(heading) * vel);
            turn += 1.0;
        }
        return turn;
    }

    public static double GetValueOfPositionOnBulletFollower(BulletFollower follower, Point2D.Double movilPos) {
        double vel = follower.velTarget_;
        double heading = follower.headingTarget_;
        Point2D.Double firePos = follower.firePos_;
        Point2D.Double targetPos = follower.targetPos_;
        if (vel < 0.0) {
            vel = -vel;
            heading = Utils.normalRelativeAngle((double)(heading + Math.PI));
        }
        double ang = Utils.normalAbsoluteAngle((double)Math.atan2(targetPos.getX() - firePos.getX(), targetPos.getY() - firePos.getY()));
        double angMovil = Utils.normalAbsoluteAngle((double)Math.atan2(movilPos.getX() - firePos.getX(), movilPos.getY() - firePos.getY()));
        double angDiff = Utils.normalRelativeAngle((double)(ang - angMovil));
        if (heading >= 0.0) {
            return angDiff;
        }
        return -angDiff;
    }

    public static double GetAbsoluteValueRelativeToAngle(BulletFollower follower, double val) {
        double vel = follower.velTarget_;
        double heading = follower.headingTarget_;
        Point2D.Double firePos = follower.firePos_;
        Point2D.Double targetPos = follower.targetPos_;
        double angleBegin = follower.angleBegin_;
        double angleArc = follower.angleArc_;
        if (vel < 0.0) {
            vel = -vel;
            heading = Utils.normalRelativeAngle((double)(heading + Math.PI));
        }
        double ang = Utils.normalAbsoluteAngle((double)Math.atan2(targetPos.getX() - firePos.getX(), targetPos.getY() - firePos.getY()));
        double ang1 = Utils.normalAbsoluteAngle((double)(ang - angleBegin));
        if (heading >= 0.0) {
            return (ang1 - val) / angleArc;
        }
        return (ang1 + val) / angleArc;
    }
}

