/*
 * Decompiled with CFR 0.152.
 */
package TNT;

import TNT.AvoidWallCondition;
import TNT.CustomTNTEvent;
import TNT.FightingManager;
import TNT.FinishedMovingGunCondition;
import TNT.FinishedScanningCondition;
import TNT.MoveManager;
import TNT.MultiFightStrategy;
import TNT.MultiMovementStrategy;
import TNT.PatternAnalyzer;
import TNT.RadarManager;
import TNT.SingleFightStrategy;
import TNT.SingleMovementStrategy;
import TNT.VictoryDance;
import java.awt.Color;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class TNT
extends AdvancedRobot {
    public static final short FORWARD = 1;
    public static final short BACKWARDS = -1;
    public static double FIELD_WIDTH;
    public static double FIELD_HEIGHT;
    protected static RadarManager m_radarManager;
    protected static Hashtable m_scannedInformation;
    protected static boolean debugMode;
    protected static Random random;
    protected static List m_bulletsShots;
    protected static PatternAnalyzer m_analyzer;
    protected static PrintStream TNTStream;
    boolean movingForward;
    double maxmove = -1.0;
    double mysize = -1.0;
    double myhyp = -1.0;
    protected FightingManager m_fightManager = null;
    protected MoveManager m_moveManager = null;
    protected short m_direction = 1;

    public void run() {
        try {
            TNTStream = ((Robot)this).out;
            m_bulletsShots = new ArrayList();
            this.setAdjustGunForRobotTurn(true);
            this.setAdjustRadarForGunTurn(false);
            FIELD_WIDTH = this.getBattleFieldWidth();
            FIELD_HEIGHT = this.getBattleFieldHeight();
            this.m_fightManager = new FightingManager(this);
            this.m_moveManager = new MoveManager(this);
            this.populateFightManager();
            this.populateMoveManager();
            this.setColors(Color.white, Color.orange, Color.blue);
            this.setEventPriority("ScannedRobotEvent", 90);
            this.setEventPriority("HitByBulletEvent", 85);
            if (m_scannedInformation == null) {
                m_scannedInformation = new Hashtable(this.getOthers());
                TNT.debug("Init Enemy Information Hash...");
            }
            if (m_analyzer == null) {
                m_analyzer = new PatternAnalyzer(this);
            }
            if (m_radarManager == null) {
                m_radarManager = new RadarManager(this);
            }
            this.addCustomEvent(new FinishedScanningCondition(this));
            this.addCustomEvent(new AvoidWallCondition(this));
            this.addCustomEvent((Condition)new FinishedMovingGunCondition(this));
            m_analyzer.startAnalyzer();
            this.m_fightManager.selectBestStrategy();
            this.m_moveManager.selectBestStrategy();
            while (true) {
                this.maxmove = Math.max(this.getBattleFieldWidth(), this.getBattleFieldHeight());
                this.mysize = Math.max(this.getWidth(), this.getHeight());
                this.myhyp = Math.sqrt(2.0) * this.mysize;
                this.movingForward = true;
                this.setAhead(this.maxmove - 60.0);
                this.setTurnLeft(26.0);
                this.setBack(this.mysize + 50.0);
                this.m_moveManager.operate();
                this.execute();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (m_analyzer != null) {
                m_analyzer.stopAnalyzer();
            }
            this.printStats();
            throw throwable;
        }
    }

    public void populateMoveManager() {
        TNT.debug("Addin' some...Michael Jackson & Paula Abdul Moves..");
        this.m_moveManager.addStrategy(new SingleMovementStrategy(this));
        this.m_moveManager.addStrategy(new MultiMovementStrategy(this));
        this.m_moveManager.addStrategy(new VictoryDance(this));
    }

    public void populateFightManager() {
        TNT.debug("Loading Kill Behavior");
        TNT.debug("T-Rex Loaded");
        TNT.debug("Raptor Loaded");
        TNT.debug("Woman in her periode...:-)");
        this.m_fightManager.addStrategy(new SingleFightStrategy(this));
        this.m_fightManager.addStrategy(new MultiFightStrategy(this));
    }

    public void reverseDirection() {
        this.m_direction = (short)(this.m_direction * -1);
        this.setAhead(Math.abs(this.getDistanceRemaining()));
    }

    public static void debug(String in_message) {
        if (debugMode) {
            TNTStream.println(in_message);
        }
    }

    public void printStats() {
        double bulletsShot = m_bulletsShots.size();
        double bulletsHit = 0.0;
        double bulletsMissed = 0.0;
        double lifeLostFromShot = 0.0;
        double stillInMotion = 0.0;
        double netDamage = 0.0;
        Bullet tempBullet = null;
        int iCounter = 0;
        while ((double)iCounter < bulletsShot) {
            tempBullet = (Bullet)m_bulletsShots.get(iCounter);
            if (tempBullet != null) {
                lifeLostFromShot += tempBullet.getPower();
                if (!tempBullet.isActive()) {
                    if (tempBullet.getVictim() == null) {
                        bulletsMissed += 1.0;
                    } else {
                        netDamage += 4.0 * tempBullet.getPower() + (tempBullet.getPower() > 1.0 ? 2.0 * tempBullet.getPower() - 1.0 : 0.0);
                        bulletsHit += 1.0;
                    }
                } else {
                    stillInMotion += 1.0;
                }
            }
            ++iCounter;
        }
        TNT.debug("\n----------- TNT Stats ------------");
        TNT.debug("Bullets Shot: " + bulletsShot);
        TNT.debug("Bullets Hit: " + bulletsHit + " (" + Math.round(bulletsHit / bulletsShot * 100.0) + "%)");
        TNT.debug("Bullets Missed: " + bulletsMissed + " (" + Math.round(bulletsMissed / bulletsShot * 100.0) + "%)");
        TNT.debug("Bullets Still In Action: " + stillInMotion + " (" + Math.round(stillInMotion / bulletsShot * 100.0) + "%)");
        TNT.debug("Life Gained From Hitting: " + Math.round(netDamage));
        TNT.debug("Life Lost From Shooting: " + Math.round(lifeLostFromShot));
        TNT.debug("Net Life Lost/Gained From Shots Fired: " + Math.round(netDamage - lifeLostFromShot));
        TNT.debug("Net Damage Inflicted: " + Math.round(netDamage));
        TNT.debug("--------------------------------------\n");
    }

    public void onCustomEvent(CustomEvent in_event) {
        ((CustomTNTEvent)in_event.getCondition()).handleEvent();
    }

    public void onScannedRobot(ScannedRobotEvent in_event) {
        m_radarManager.onScannedRobot(in_event);
    }

    public void onHitRobot(HitRobotEvent in_event) {
        this.m_fightManager.getStrategy().gotCollision(in_event);
        this.m_moveManager.getStrategy().gotCollision(in_event);
    }

    public void onHitByBullet(HitByBulletEvent in_event) {
        this.m_fightManager.getStrategy().gotShot(in_event);
        this.m_moveManager.getStrategy().gotShot(in_event);
    }

    public void onHitWall(HitWallEvent e) {
        if (this.movingForward) {
            this.setBack(30.0);
            this.movingForward = false;
            this.stop();
        } else {
            this.setAhead(50.0);
            this.movingForward = true;
            this.stop();
        }
    }

    public void setAhead(double distance) {
        super.setAhead(distance *= (double)this.m_direction);
    }

    public void setBack(double distance) {
        super.setBack(distance *= (double)this.m_direction);
    }

    public String getName() {
        return " 5-4-3-2-1...Booom ";
    }

    static {
        m_radarManager = null;
        m_scannedInformation = null;
        debugMode = true;
        random = new Random();
        m_bulletsShots = null;
        m_analyzer = null;
        TNTStream = null;
    }
}

