/*
 * Decompiled with CFR 0.152.
 */
package eem.misc;

import eem.misc.logger;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.util.Utils;

public class physics {
    public static int robotHalfSize = 0;
    public static double robotRadius = 0.0;
    public static Point2D.Double BattleField = new Point2D.Double(0.0, 0.0);
    public static double gunCoolingRate = 0.0;
    public static double minimalAllowedBulletEnergy = 0.0;
    public static double maximalAllowedBulletEnergy = 0.0;
    public static long maxTurnsInRound = 100000L;

    public static void init(AdvancedRobot advancedRobot) {
        robotHalfSize = (int)advancedRobot.getWidth() / 2;
        robotRadius = (double)robotHalfSize * Math.sqrt(2.0);
        BattleField = new Point2D.Double(advancedRobot.getBattleFieldWidth(), advancedRobot.getBattleFieldHeight());
        gunCoolingRate = advancedRobot.getGunCoolingRate();
        minimalAllowedBulletEnergy = 0.1;
        maximalAllowedBulletEnergy = 3.0;
    }

    public static long ticTimeFromTurnAndRound(long l, long l2) {
        return l + (l2 + 1L) * maxTurnsInRound;
    }

    public static long getRoundStartTime(long l) {
        return (long)Math.floor(l / maxTurnsInRound) * maxTurnsInRound;
    }

    public static boolean isTimeInSameRound(long l, long l2) {
        return physics.getRoundStartTime(l) == physics.getRoundStartTime(l2);
    }

    public static int gunCoolingTime(double d) {
        return (int)Math.ceil(d / gunCoolingRate);
    }

    public static double bulletSpeed(double d) {
        if (d > maximalAllowedBulletEnergy) {
            logger.warning("bulletSpeed(): Forbiden bullet energy requested: " + d + " > " + maximalAllowedBulletEnergy);
        }
        double d2 = Rules.getBulletSpeed((double)d);
        logger.noise("bullet speed = " + d2 + " for firePower = " + d);
        return d2;
    }

    public static double bulletEnergy(double d) {
        double d2 = (20.0 - d) / 3.0;
        return d2;
    }

    public static double bulletDamageByEnergy(double d) {
        double d2 = Rules.getBulletDamage((double)d);
        return d2;
    }

    public static double minReqBulEnergyToKillTarget(double d) {
        double d2 = 0.1;
        double d3 = (d += d2) / 4.0;
        if (d3 > 1.0) {
            d3 = (d + 2.0) / 6.0;
        }
        d3 = Math.max(d3, minimalAllowedBulletEnergy);
        return d3;
    }

    public static double calculateMEA(double d) {
        double d2 = 8.0;
        double d3 = 57.29577951308232 * Math.asin(d2 / d);
        return d3;
    }

    public static boolean isBotOutOfBorders(Point2D.Double double_) {
        if (double_.x < (double)robotHalfSize || double_.x > physics.BattleField.x - (double)robotHalfSize) {
            return true;
        }
        return double_.y < (double)robotHalfSize || double_.y > physics.BattleField.y - (double)robotHalfSize;
    }

    public static double dist2LeftOrRightWall(Point2D.Double double_) {
        double d = double_.x;
        double d2 = physics.BattleField.x - double_.x;
        if (d <= 0.0 || d2 <= 0.0) {
            return 0.0;
        }
        return Math.min(d, d2);
    }

    public static double dist2BottomOrTopWall(Point2D.Double double_) {
        double d = double_.y;
        double d2 = physics.BattleField.y - double_.y;
        if (d2 <= 0.0 || d <= 0.0) {
            return 0.0;
        }
        return Math.min(d, d2);
    }

    public static double shortestDist2wall(Point2D.Double double_) {
        return Math.min(physics.dist2LeftOrRightWall(double_), physics.dist2BottomOrTopWall(double_));
    }

    public static String whichWallAhead(Point2D.Double double_, double d, double d2) {
        double d3;
        double d4 = 1.0;
        double d5 = double_.x;
        double d6 = double_.y;
        double d7 = 1.0E100;
        String string = "";
        if (Utils.isNear((double)d, (double)0.0)) {
            double d8 = d5;
            double d9 = 0.0;
            string = "left";
            d9 = d6;
            if (d9 < d8) {
                d8 = d6;
                string = "bottom";
            }
            if ((d9 = physics.BattleField.x - d5) < d8) {
                d8 = d9;
                string = "right";
            }
            if ((d9 = physics.BattleField.y - d6) < d8) {
                d8 = d9;
                string = "top";
            }
            return string;
        }
        double d10 = Math.sin(d2) * d;
        double d11 = Math.cos(d2) * d;
        double d12 = Utils.isNear((double)d10, (double)0.0) ? d7 : (d10 < 0.0 ? -(d5 - (double)robotHalfSize + d4) / d10 : (physics.BattleField.x - d5 - (double)robotHalfSize + d4) / d10);
        string = d12 < (d3 = Utils.isNear((double)d11, (double)0.0) ? d7 : (d11 < 0.0 ? -(d6 - (double)robotHalfSize + d4) / d11 : (physics.BattleField.y - d6 - (double)robotHalfSize + d4) / d11)) ? (d10 < 0.0 ? "left" : "right") : (d11 < 0.0 ? "bottom" : "top");
        return string;
    }

    public static double distanceToWallAhead(Point2D.Double double_, double d, double d2) {
        double d3 = 0.0;
        String string = physics.whichWallAhead(double_, d, d2);
        if (string.equals("left")) {
            d3 = double_.x;
        }
        if (string.equals("right")) {
            d3 = physics.BattleField.x - double_.x;
        }
        if (string.equals("bottom")) {
            d3 = double_.y;
        }
        if (string.equals("top")) {
            d3 = physics.BattleField.y - double_.y;
        }
        d3 -= (double)robotHalfSize;
        if ((d3 = Math.max(d3, 0.0)) < 0.0) {
            d3 = 0.0;
        }
        logger.noise("distance to closest wall ahead " + d3);
        return d3;
    }

    public double stopDistance(double d) {
        double d2 = Math.abs(d);
        int n = 0;
        d2 -= 2.0;
        while (d2 > 0.0) {
            n = (int)((double)n + d2);
            d2 -= 2.0;
        }
        return n;
    }
}

