/*
 * Decompiled with CFR 0.152.
 */
package jmcd;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import jmcd.Enemy;
import jmcd.OpSet;
import jmcd.VBullet;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TurnCompleteCondition;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BeoWulf
extends AdvancedRobot {
    static boolean reset = false;
    static boolean resetOpp = false;
    static boolean EnemySave = false;
    static int win = 0;
    static int second = 0;
    static int third = 0;
    static int loss = 0;
    static float DTaken = 0.0f;
    static float DGiven = 0.0f;
    static float DGained = 0.0f;
    static long BHit = 0L;
    static long BTotal = 0L;
    static int wallHit = 0;
    static int VBMissScan = 0;
    static Hashtable EBots = null;
    static Enemy TrkBot;
    static Enemy Ebot;
    static int Optimise;
    static int OpRounds;
    static int OpSize;
    static double OldScore;
    static Vector Pop;
    static int Popi;
    static double ScoreDist;
    static double ScoreEnergy;
    static double ScoreWall;
    static double FightProb;
    static double AttackProb;
    static int ForwardTime;
    static int ReverseTime;
    static double FPDistGain;
    static double FPProbGain;
    static double FPProbTarget;
    static int searchDepth;
    static int LockSize;
    static int PattSize;
    static int ScanLimit;
    int Melee;
    double BFWidth;
    double BFHeight;
    int movingForward;
    boolean bounce;
    boolean moveChange;
    boolean headChange;
    double moveHeading;
    double wiggle;
    int RandHeading;
    double moveDist;
    double MoveX;
    double MoveY;
    double FX;
    double FY;
    int moveFlip;
    double moveTime;
    int TimeAdj;
    double MeOldHead;
    double turnFactor;
    int Sector;
    boolean Search;
    boolean SearchStart;
    boolean Searching;
    int raDir;
    int ScanCount;
    String trackName;
    double TargetDistance;
    double TargetBearing;
    double TargetHeading;
    long TargetTime;
    double TurnRate;
    double TargetSpeed;
    double TargetAvgSpeed;
    double TargetAcc;
    double TargetPower;
    double previousPower;
    double TargetX;
    double TargetY;
    int fight;
    Vector VBs;
    int distanceIndex;
    int fireMethod;
    double gunHeading;
    float AimOffset;
    float AimProb;
    double AimX;
    double AimY;
    double firePower;
    boolean fire;
    boolean fired;
    long fireTime;
    boolean pattLock;
    double FireDist;

    public void run() {
        this.setColors(Color.darkGray, Color.darkGray, Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.BFWidth = this.getBattleFieldWidth();
        this.BFHeight = this.getBattleFieldHeight();
        this.addCustomEvent(new Condition(this, "WallClose"){
            final /* synthetic */ BeoWulf this$0;

            public final boolean test() {
                boolean bl = false;
                if (this.this$0.getX() > this.this$0.getBattleFieldWidth() - 40.0 || this.this$0.getX() < 40.0 || this.this$0.getY() > this.this$0.getBattleFieldHeight() - 40.0 || this.this$0.getY() < 40.0) {
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = beoWulf;
            }
        });
        this.addCustomEvent(new Condition(this, "WallFar"){
            final /* synthetic */ BeoWulf this$0;

            public final boolean test() {
                boolean bl = false;
                if (this.this$0.getX() < this.this$0.getBattleFieldWidth() - 80.0 && this.this$0.getX() > 80.0 && this.this$0.getY() < this.this$0.getBattleFieldHeight() - 80.0 && this.this$0.getY() > 80.0 && this.this$0.bounce) {
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = beoWulf;
            }
        });
        if (!reset && EBots == null) {
            try {
                FileInputStream fi = new FileInputStream(this.getDataFile("enemy.dat"));
                ObjectInputStream si = new ObjectInputStream(fi);
                EBots = (Hashtable)si.readObject();
                si.close();
                this.out.println("Data Read Successfully");
            }
            catch (Exception e) {
                e.printStackTrace();
                EBots = null;
            }
        }
        if (EBots == null) {
            EBots = new Hashtable();
        }
        this.VBs = new Vector();
        this.Search = true;
        this.SearchStart = true;
        this.ScanCount = 0;
        this.trackName = null;
        this.bounce = false;
        this.fire = false;
        this.fired = false;
        this.movingForward = 1;
        this.moveFlip = 1;
        this.moveTime = 0.0;
        this.TargetTime = 0L;
        this.AimProb = 0.0f;
        this.TimeAdj = 0;
        if (Pop == null && !resetOpp) {
            try {
                FileInputStream fiOP = new FileInputStream(this.getDataFile("Optim.dat"));
                ObjectInputStream siOP = new ObjectInputStream(fiOP);
                Pop = (Vector)siOP.readObject();
                siOP.close();
                this.out.println("Optimisation Data Read Successfully");
            }
            catch (Exception exc) {
                this.out.println("Optimisation Data Read Problem");
                exc.printStackTrace();
                Pop = null;
            }
        }
        if (Pop == null) {
            this.OpSetSetup();
        }
        this.OpSetLoad(Popi);
        while (true) {
            this.doStrat();
            this.doScanner();
            this.doMovement();
            this.doAim();
            if (this.fire) {
                this.fireTime = this.getTime();
                this.out.println(" * Fired: " + BeoWulf.Ebot.Name + " M-D-FM: " + this.Melee + '-' + this.distanceIndex + '-' + this.fireMethod + " BD|Off|Prob|n: " + (float)this.FireDist + '|' + this.AimOffset + '|' + this.AimProb + '|' + BeoWulf.Ebot.AimData[this.Melee][this.distanceIndex][this.fireMethod][2] + " Power/Time: " + (float)this.firePower + '/' + this.getTime() + " Fight " + this.fight);
                this.fire = false;
                this.fired = true;
                ++BTotal;
                this.fire(this.firePower);
                continue;
            }
            this.execute();
        }
    }

    public void doStrat() {
        this.Melee = this.getOthers() > 1 ? 1 : 0;
        if (this.trackName == null) {
            return;
        }
        this.fight = this.Melee == 0 ? 2 : (this.AimProb == 0.0f || (double)this.AimProb > FightProb || this.getEnergy() / this.TargetPower > 1.2 || this.TargetDistance < 100.0 ? 1 : 0);
    }

    void doScanner() {
        double radarOffset;
        if (this.Search) {
            if (!this.SearchStart) {
                TrkBot = null;
                Enumeration enn = EBots.keys();
                while (enn.hasMoreElements()) {
                    String s = (String)enn.nextElement();
                    Enemy ScanBot = (Enemy)EBots.get(s);
                    if (ScanBot == null || !ScanBot.Alive || ScanBot.Name.equals(this.trackName)) continue;
                    ScanBot.Seen = false;
                    if (TrkBot != null && ScanBot.ScanTime >= BeoWulf.TrkBot.ScanTime) continue;
                    TrkBot = ScanBot;
                }
                if (TrkBot != null) {
                    double TrkBear = this.normalRelativeAngle(this.getAbsAngle(this.getX(), this.getY(), BeoWulf.TrkBot.X, BeoWulf.TrkBot.Y) - this.getRadarHeading());
                    this.raDir = TrkBear > 0.0 ? 1 : -1;
                }
                this.SearchStart = true;
            }
            radarOffset = this.raDir * 360;
        } else {
            this.SearchStart = false;
            double TargetBear = this.getAbsAngle(this.getX(), this.getY(), BeoWulf.Ebot.X, BeoWulf.Ebot.Y);
            radarOffset = this.normalRelativeAngle(TargetBear - this.getRadarHeading());
            radarOffset = radarOffset < 0.0 ? (radarOffset -= 15.0) : (radarOffset += 15.0);
        }
        this.setTurnRadarRight(radarOffset);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy bot = (Enemy)EBots.get(e.getName());
        if (bot == null) {
            bot = new Enemy(e.getName());
            EBots.put(e.getName(), bot);
            this.out.println("Creating " + bot.Name);
        }
        bot.setup();
        bot.Energy = e.getEnergy();
        bot.Distance = e.getDistance();
        bot.Bearing = this.normalAbsoluteAngle(this.getHeading() + e.getBearing());
        bot.Heading = e.getHeading();
        bot.Speed = e.getVelocity();
        bot.ScanTime = this.getTime();
        bot.X = this.getX() + bot.Distance * Math.sin(Math.toRadians(bot.Bearing));
        bot.Y = this.getY() + bot.Distance * Math.cos(Math.toRadians(bot.Bearing));
        bot.AimScore = bot.Distance > 0.0 && bot.Energy > 0.0 ? 1000.0 / bot.Distance + 100.0 / bot.Energy : 100.0;
        this.BulletTrack(bot);
        if (!bot.Alive) {
            bot.Alive = true;
            ++this.ScanCount;
            this.out.println("Scanned " + bot.Name + "  " + this.ScanCount + " of " + this.getOthers());
        }
        if (this.ScanCount < this.getOthers() && this.getTime() - this.TargetTime < 50L) {
            this.Search = true;
            return;
        }
        if (this.Search && this.Melee == 1 && TrkBot != null && bot.Name.equals(BeoWulf.TrkBot.Name) && !bot.Seen) {
            this.raDir *= -1;
            bot.Seen = true;
        }
        if (this.trackName == null || this.Searching) {
            String SearchName = null;
            double MaxScore = 0.0;
            this.Search = true;
            Enumeration ennum = EBots.keys();
            while (ennum.hasMoreElements()) {
                String st = (String)ennum.nextElement();
                Enemy SearchBot = (Enemy)EBots.get(st);
                if (!SearchBot.Alive || !(SearchBot.AimScore > MaxScore)) continue;
                SearchName = SearchBot.Name;
                MaxScore = SearchBot.AimScore;
            }
            if (Ebot != null && !BeoWulf.Ebot.Name.equals(SearchName)) {
                Enemy SearchBot = (Enemy)EBots.get(SearchName);
                SearchBot.ScanTime = 0L;
            }
            if (!bot.Name.equals(SearchName)) {
                return;
            }
        }
        if (this.trackName != null && this.Melee == 1 && !bot.Name.equals(this.trackName) && !this.Searching) {
            if (BeoWulf.Ebot.Energy < 10.0) {
                return;
            }
            if (bot.Distance > 150.0) {
                if (BeoWulf.Ebot.Distance < (double)ScanLimit) {
                    if (bot.Distance > BeoWulf.Ebot.Distance || bot.Energy > BeoWulf.Ebot.Energy * 0.9) {
                        return;
                    }
                } else {
                    if (this.getGunHeat() <= 0.5 && (double)this.AimProb > FightProb) {
                        return;
                    }
                    this.Searching = true;
                    return;
                }
            }
        }
        if (!bot.Name.equals(this.trackName)) {
            this.trackName = bot.Name;
            this.previousPower = bot.Energy;
            Ebot = (Enemy)EBots.get(this.trackName);
            this.out.println("Tracking " + BeoWulf.Ebot.Name);
        }
        if (this.getTime() > this.TargetTime) {
            this.EnemyParam(Ebot);
            this.PatternLog(Ebot);
        }
        this.Searching = false;
        if (this.Melee == 0) {
            this.Search = false;
            return;
        }
        if (this.fired || this.getGunHeat() > 1.0) {
            this.Search = true;
            this.fired = false;
            this.scan();
            return;
        }
        this.Search = false;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy bot = (Enemy)EBots.get(e.getName());
        if (bot != null) {
            bot.Alive = false;
        }
        if (e.getName().equals(this.trackName)) {
            this.Search = true;
            this.trackName = null;
        }
    }

    public void EnemyParam(Enemy bot) {
        this.TargetBearing = bot.Bearing;
        this.TargetDistance = bot.Distance;
        this.TargetHeading = bot.Heading;
        this.TargetSpeed = bot.Speed;
        this.TargetPower = bot.Energy;
        this.TargetTime = bot.ScanTime;
        if (bot.AvgChange(this.TargetSpeed, this.TargetHeading, this.TargetTime)) {
            this.TurnRate = bot.TurnRate;
            this.TargetAvgSpeed = bot.AvgVel;
            this.TargetAcc = bot.Accel;
        }
        this.TargetX = bot.X;
        this.TargetY = bot.Y;
        this.distanceIndex = this.DistIndex(this.TargetDistance);
    }

    public int DistIndex(double TargDist) {
        if (TargDist <= 150.0) {
            return 0;
        }
        if (TargDist <= 250.0) {
            return 1;
        }
        if (TargDist <= 350.0) {
            return 2;
        }
        if (TargDist <= 450.0) {
            return 3;
        }
        if (TargDist <= 550.0) {
            return 4;
        }
        if (TargDist <= 650.0) {
            return 5;
        }
        if (TargDist <= 750.0) {
            return 6;
        }
        return 7;
    }

    void doMovement() {
        this.moveDist = 10000.0;
        if (this.moveChange) {
            this.headChange = true;
            this.moveTime = this.getTime();
            this.TimeAdj = (int)Math.round(Math.random() * 20.0) - 10;
            if (Math.random() > 0.3 && !this.bounce) {
                this.movingForward *= -1;
            }
            this.moveChange = false;
        }
        if (this.bounce) {
            this.moveHeading = this.getHeading();
            this.Sector = 9;
            if ((double)this.getTime() - this.moveTime >= 10.0) {
                this.moveHeading = this.getAbsAngle(this.getX(), this.getY(), this.BFWidth / (double)2, this.BFHeight / (double)2);
                if (this.movingForward * this.moveFlip < 0) {
                    this.moveHeading = this.normalAbsoluteAngle(this.moveHeading + 180.0);
                }
            }
        } else if (this.fight == 2) {
            this.FireDist = 100 * (Ebot.BestDI(this.Melee) + 1);
            if (this.TargetDistance > this.FireDist + 150.0) {
                this.RandCloser();
                this.Sector = 8;
            } else {
                this.StrafeMovement();
                this.Sector = 9;
            }
        } else {
            if (this.headChange) {
                this.Sector = this.BestSector(this.getX(), this.getY());
            }
            this.RandSector(this.Sector);
        }
        if (this.movingForward > 0 && (double)this.getTime() - this.moveTime >= (double)(ForwardTime + this.TimeAdj) && !this.bounce) {
            this.moveChange = true;
        }
        if (this.movingForward < 0 && (double)this.getTime() - this.moveTime >= (double)(ReverseTime + this.TimeAdj) && !this.bounce) {
            this.moveChange = true;
        }
        double wiggleTime = this.getTime() % 25L;
        this.wiggle = 15.0;
        this.wiggle = wiggleTime >= (double)5 && wiggleTime <= 10.0 ? (this.wiggle *= 1.0) : (wiggleTime >= 15.0 && wiggleTime <= 20.0 ? (this.wiggle *= -1.0) : 0.0);
        double moveHead = this.normalRelativeAngle(this.moveHeading - this.getHeading());
        if (!this.bounce) {
            if (this.moveFlip < 0) {
                if (moveHead < 90.0 && moveHead > -90.0) {
                    this.moveFlip = 1;
                } else {
                    moveHead = this.normalRelativeAngle(moveHead - 180.0);
                }
            } else if (moveHead > 90.0 || moveHead < -90.0) {
                moveHead = this.normalRelativeAngle(moveHead - 180.0);
                this.moveFlip = -1;
            }
        }
        this.setTurnRight(moveHead + this.wiggle);
        this.setAhead((double)(this.moveFlip * this.movingForward) * this.moveDist);
        this.FX = this.getX() + (double)(this.movingForward * 8) * Math.sin(Math.toRadians(this.moveHeading));
        this.FY = this.getY() + (double)(this.movingForward * 8) * Math.cos(Math.toRadians(this.moveHeading));
    }

    public int SectorCalc(double Bearing) {
        if (Bearing >= 30.0 && Bearing < 90.0) {
            return 1;
        }
        if (Bearing >= 90.0 && Bearing < 150.0) {
            return 2;
        }
        if (Bearing >= 150.0 && Bearing < 210.0) {
            return 3;
        }
        if (Bearing >= 210.0 && Bearing < 270.0) {
            return 4;
        }
        if (Bearing >= 270.0 && Bearing < 330.0) {
            return 5;
        }
        return 0;
    }

    public int BestSector(double MeX, double MeY) {
        float[] ESector = new float[6];
        Enumeration enn = EBots.keys();
        while (enn.hasMoreElements()) {
            String s = (String)enn.nextElement();
            Enemy Sectbot = (Enemy)EBots.get(s);
            if (!Sectbot.Alive) continue;
            int ESect = this.SectorCalc(Sectbot.Bearing);
            double MoveScore = Sectbot.Distance > 0.0 ? ScoreDist / Sectbot.Distance * Sectbot.Energy / ScoreEnergy : 100.0;
            int n = ESect;
            ESector[n] = (float)((double)ESector[n] + MoveScore);
        }
        if (this.getDist(MeX, MeY, MeX, this.BFHeight) < 250.0) {
            ESector[0] = (float)((double)ESector[0] + ScoreWall / this.getDist(MeX, MeY, MeX, this.BFHeight));
            ESector[1] = (float)((double)ESector[1] + ScoreWall / (double)2 / this.getDist(MeX, MeY, MeX, this.BFHeight));
            ESector[5] = (float)((double)ESector[5] + ScoreWall / (double)2 / this.getDist(MeX, MeY, MeX, this.BFHeight));
        }
        if (this.getDist(MeX, MeY, MeX, 0.0) < 250.0) {
            ESector[2] = (float)((double)ESector[2] + ScoreWall / (double)2 / this.getDist(MeX, MeY, MeX, 0.0));
            ESector[3] = (float)((double)ESector[3] + ScoreWall / this.getDist(MeX, MeY, MeX, 0.0));
            ESector[4] = (float)((double)ESector[4] + ScoreWall / (double)2 / this.getDist(MeX, MeY, MeX, 0.0));
        }
        if (this.getDist(MeX, MeY, this.BFWidth, MeY) < 250.0) {
            ESector[1] = (float)((double)ESector[1] + ScoreWall / (double)2 / this.getDist(MeX, MeY, this.BFWidth, MeY));
            ESector[2] = (float)((double)ESector[2] + ScoreWall / (double)2 / this.getDist(MeX, MeY, this.BFWidth, MeY));
        }
        if (this.getDist(MeX, MeY, 0.0, MeY) < 250.0) {
            ESector[4] = (float)((double)ESector[4] + ScoreWall / (double)2 / this.getDist(MeX, MeY, 0.0, MeY));
            ESector[5] = (float)((double)ESector[5] + ScoreWall / (double)2 / this.getDist(MeX, MeY, 0.0, MeY));
        }
        if (this.getDist(MeX, MeY, this.BFWidth / (double)2, this.BFHeight / (double)2) < 250.0) {
            int CentSect;
            int n = CentSect = this.SectorCalc(this.getAbsAngle(MeX, MeY, this.BFWidth / (double)2, this.BFHeight / (double)2));
            ESector[n] = (float)((double)ESector[n] + ScoreWall / this.getDist(MeX, MeY, this.BFWidth / (double)2, this.BFHeight / (double)2));
        }
        float MinSector = 10000.0f;
        int BestSector = 0;
        int i = 0;
        while (i <= 5) {
            if (ESector[i] < MinSector) {
                MinSector = ESector[i];
                BestSector = i;
            }
            ++i;
        }
        return BestSector;
    }

    public void RandSector(int Sector) {
        if (this.headChange) {
            this.RandHeading = (int)Math.round(Math.random() * 60.0) - 30;
            this.headChange = false;
        }
        this.moveHeading = this.movingForward > 0 ? this.normalAbsoluteAngle(60 * Sector + this.RandHeading) : this.normalAbsoluteAngle(60 * Sector + this.RandHeading - 180);
    }

    public void RandCloser() {
        if (this.headChange) {
            this.RandHeading = (int)Math.round(Math.random() * 30.0) - 15;
            this.headChange = false;
        }
        this.moveHeading = this.movingForward > 0 ? this.normalAbsoluteAngle(this.TargetBearing + 45.0 + (double)this.RandHeading) : this.normalAbsoluteAngle(this.TargetBearing - 180.0 - 45.0 + (double)this.RandHeading);
    }

    public void StrafeMovement() {
        this.moveDist = 10000.0;
        double attackAngle = 30.0 * (this.TargetDistance - this.FireDist) / 150.0;
        if (attackAngle > 30.0) {
            attackAngle = 30.0;
        }
        if (attackAngle < -30.0) {
            attackAngle = -30.0;
        }
        this.moveHeading = this.normalAbsoluteAngle(this.TargetBearing - 90.0 + (double)this.movingForward * attackAngle);
    }

    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition().getName().equals("WallClose")) {
            if (this.bounce) {
                return;
            }
            this.bounce = true;
            this.moveTime = this.getTime();
            this.movingForward *= -1;
            this.setAhead(this.moveFlip * this.movingForward * 10000);
        }
        if (e.getCondition().getName().equals("WallFar")) {
            this.bounce = false;
            this.moveTime = this.getTime();
            this.headChange = true;
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.bounce = true;
        this.out.println(" Wall Hit #: " + ++wallHit);
        this.doScanner();
        this.setMaxVelocity(0.0);
        double CenterAng = this.getAbsAngle(this.getX(), this.getY(), this.BFWidth / (double)2, this.BFHeight / (double)2);
        this.setTurnRight(this.normalRelativeAngle(CenterAng - this.getHeading()));
        this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
        this.movingForward = 1;
        this.moveFlip = 1;
        this.setMaxVelocity(8.0);
        this.setAhead(this.moveFlip * this.movingForward * 10000);
        this.execute();
    }

    public void onHitRobot(HitRobotEvent e) {
        if (e.isMyFault()) {
            this.movingForward *= -1;
        }
        this.setAhead(this.moveFlip * this.movingForward * 10000);
        this.trackName = null;
        double hitAngle = this.normalAbsoluteAngle(this.getHeading() + e.getBearing());
        this.setTurnGunRight(this.normalRelativeAngle(hitAngle - this.getGunHeading()));
        this.setTurnRadarRight(this.normalRelativeAngle(hitAngle - this.getRadarHeading()));
        if (this.getGunHeat() == 0.0 && Math.abs(this.normalRelativeAngle(hitAngle - this.getGunHeading())) < 60.0) {
            this.setFire(Math.min((double)3, this.getEnergy() / (double)3));
        }
        this.out.println(" **** Hit Robot Fire: " + BeoWulf.Ebot.Name + " Power: " + (float)this.firePower + " FireTime " + this.getTime());
        this.execute();
    }

    public void doAim() {
        if (this.trackName == null) {
            return;
        }
        double PowerAdjust = 0.0;
        if (this.AimProb > 0.0f) {
            PowerAdjust = FPProbGain * ((double)this.AimProb - FPProbTarget);
        }
        if (PowerAdjust > 1.5) {
            PowerAdjust = 1.5;
        }
        if (PowerAdjust < -1.5) {
            PowerAdjust = -1.5;
        }
        this.firePower = Math.min(FPDistGain / this.TargetDistance + PowerAdjust, this.getEnergy() / 10.0);
        if (this.firePower < 0.1) {
            this.firePower = 0.1;
        }
        if (this.firePower > (double)3) {
            this.firePower = 3;
        }
        if ((this.getEnergy() >= 0.2 || BeoWulf.Ebot.Energy == 0.0) && ((double)this.AimProb > FightProb || BeoWulf.Ebot.Energy < 10.0 || this.getTime() - this.fireTime > 50L) && this.getGunHeat() == 0.0 && Math.abs(this.normalRelativeAngle(this.gunHeading - this.getGunHeading())) < (double)5 && !this.Search) {
            this.fire = true;
        }
        if (this.getGunHeat() <= 0.5) {
            this.doVBAim();
        } else {
            this.gunHeading = this.TargetBearing;
        }
        if (this.TargetPower == 0.0) {
            this.gunHeading = this.TargetBearing;
            this.AimOffset = 0.0f;
        }
        this.gunHeading = this.normalAbsoluteAngle(this.gunHeading + (double)this.AimOffset);
        this.setTurnGunRight(this.normalRelativeAngle(this.gunHeading - this.getGunHeading()));
    }

    public void BulletTrack(Enemy SeenBot) {
        Iterator vbi = this.VBs.iterator();
        while (vbi.hasNext()) {
            double TrueAng;
            VBullet vb = (VBullet)vbi.next();
            Enemy VBbot = (Enemy)EBots.get(vb.targetName);
            if (VBbot == null || !VBbot.Alive) {
                vbi.remove();
                continue;
            }
            if (!vb.targetName.equals(SeenBot.Name) || !((TrueAng = vb.TrueAimAngle(SeenBot.X, SeenBot.Y, SeenBot.ScanTime)) > 0.0)) continue;
            if (TrueAng == 999.9) {
                ++VBMissScan;
                vbi.remove();
                continue;
            }
            double TrueOffset = this.normalRelativeAngle(TrueAng - vb.absBearing);
            SeenBot.AddOffset(this.Melee, vb.distanceIndex, vb.fireMethod, (float)TrueOffset, (float)vb.power);
            EBots.put(vb.targetName, SeenBot);
            vbi.remove();
        }
    }

    void doVBAim() {
        this.AimProb = 0.0f;
        this.AimOffset = 0.0f;
        double gunHeading0 = 0.0;
        double gunHeading1 = 0.0;
        double gunHeading2 = 0.0;
        double gunHeading3 = 0.0;
        double VBHeading = 0.0;
        int j = 0;
        while (j <= 3) {
            VBHeading = j == 0 ? (gunHeading0 = this.doLinearTarget(this.getX(), this.getY(), this.TargetX, this.TargetY, this.TargetHeading, this.TargetAvgSpeed, this.firePower)) : (j == 1 ? (gunHeading1 = this.TargetBearing) : (j == 2 ? (gunHeading2 = this.doCircularTarget(this.getX(), this.getY(), this.TargetX, this.TargetY, this.TargetHeading, this.TargetAvgSpeed, this.TurnRate, this.firePower)) : (gunHeading3 = this.doPatternMatch(Ebot))));
            if (this.fire && (j <= 2 || j == 3 && this.pattLock && this.Melee == 0)) {
                VBullet vb = new VBullet(BeoWulf.Ebot.Name, this.distanceIndex, j, 0, this.getX(), this.getY(), VBHeading, this.TargetTime, this.firePower);
                this.VBs.add(vb);
            }
            float MethodOffset = Ebot.BestOffset(this.Melee, this.distanceIndex, j);
            if ((j <= 2 || j == 3 && this.pattLock && this.Melee == 0) && Ebot.AimProb(this.Melee, this.distanceIndex, j) > this.AimProb) {
                this.fireMethod = j;
                this.AimOffset = MethodOffset;
                this.AimProb = Ebot.AimProb(this.Melee, this.distanceIndex, j);
            }
            ++j;
        }
        if (this.fireMethod == 0) {
            this.gunHeading = gunHeading0;
        } else if (this.fireMethod == 1) {
            this.gunHeading = gunHeading1;
        } else if (this.fireMethod == 2) {
            this.gunHeading = gunHeading2;
        } else {
            this.gunHeading = gunHeading3;
            this.AimOffset = 0.0f;
        }
    }

    public double doLinearTarget(double originX, double originY, double TargX, double TargY, double TargH, double TargV, double BEng) {
        double x0 = TargX;
        double y0 = TargY;
        int i = 0;
        while (i <= 5) {
            double t0 = Math.sqrt((x0 - originX) * (x0 - originX) + (y0 - originY) * (y0 - originY)) / (20.0 - (double)3 * BEng);
            if ((x0 = TargX + TargV * t0 * Math.sin(Math.toRadians(TargH))) > this.BFWidth) {
                x0 = this.BFWidth;
            } else if (x0 < 0.0) {
                x0 = 0.0;
            }
            y0 = TargY + TargV * t0 * Math.cos(Math.toRadians(TargH));
            if (y0 > this.BFHeight) {
                y0 = this.BFHeight;
            } else if (y0 < 0.0) {
                y0 = 0.0;
            }
            ++i;
        }
        this.AimX = x0;
        this.AimY = y0;
        return this.getAbsAngle(this.getX(), this.getY(), this.AimX, this.AimY);
    }

    public double doCircularTarget(double originX, double originY, double TargX, double TargY, double TargH, double TargV, double TargTR, double BEng) {
        double x0 = TargX;
        double y0 = TargY;
        int i = 0;
        while (i <= 5) {
            double t0 = Math.sqrt((x0 - originX) * (x0 - originX) + (y0 - originY) * (y0 - originY)) / (20.0 - (double)3 * BEng);
            if (Math.abs(TargTR) > 0.5) {
                x0 = TargX + TargV / Math.toRadians(TargTR) * (Math.cos(Math.toRadians(TargH)) - Math.cos(Math.toRadians(this.normalAbsoluteAngle(TargH + t0 * TargTR))));
                y0 = TargY + TargV / Math.toRadians(TargTR) * (-Math.sin(Math.toRadians(TargH)) + Math.sin(Math.toRadians(this.normalAbsoluteAngle(TargH + t0 * TargTR))));
            } else {
                x0 = TargX + TargV * t0 * Math.sin(Math.toRadians(TargH));
                y0 = TargY + TargV * t0 * Math.cos(Math.toRadians(TargH));
            }
            if (x0 > this.BFWidth) {
                x0 = this.BFWidth;
            } else if (x0 < 0.0) {
                x0 = 0.0;
            }
            if (y0 > this.BFHeight) {
                y0 = this.BFHeight;
            } else if (y0 < 0.0) {
                y0 = 0.0;
            }
            ++i;
        }
        this.AimX = x0;
        this.AimY = y0;
        return this.getAbsAngle(this.getX(), this.getY(), this.AimX, this.AimY);
    }

    public void PatternLog(Enemy bot) {
        float PrevAng = 0.0f;
        float PrevDist = 0.0f;
        double TargD = bot.Distance;
        double TargB = bot.Bearing;
        double TargH = bot.Heading;
        double TargV = bot.Speed;
        float DelAng = (float)(TargV * Math.sin(Math.toRadians(this.normalAbsoluteAngle(TargH - TargB))));
        float DelDist = (float)(TargV * Math.cos(Math.toRadians(this.normalAbsoluteAngle(TargH - TargB))));
        if (bot.CumAngle.size() > 0) {
            PrevAng = ((Float)bot.CumAngle.lastElement()).floatValue();
        }
        bot.CumAngle.add(new Float(PrevAng + DelAng));
        if (bot.CumAngle.size() > PattSize) {
            bot.CumAngle.remove(0);
        }
        if (bot.CumDist.size() > 0) {
            PrevDist = ((Float)bot.CumDist.lastElement()).floatValue();
        }
        bot.CumDist.add(new Float(PrevDist + DelDist));
        if (bot.CumDist.size() > PattSize) {
            bot.CumDist.remove(0);
        }
        bot.pattern.append((char)DelAng);
        if (bot.pattern.length() > PattSize) {
            bot.pattern.deleteCharAt(0);
        }
    }

    public double doPatternMatch(Enemy bot) {
        int PatternMatch = searchDepth;
        int BulletBuffer = searchDepth + 90;
        float matchDist = 0.0f;
        float matchAng = 0.0f;
        int matchIndex = 0;
        double TarDist = this.TargetDistance;
        int t0 = 0;
        double AimAng = 0.0;
        double gunHead = 0.0;
        int historyIndex = bot.CumAngle.size() - 1;
        while (--PatternMatch * (matchIndex = bot.pattern.lastIndexOf(bot.pattern.substring(Math.max(historyIndex - PatternMatch, 0)), historyIndex - BulletBuffer)) < -1) {
        }
        this.pattLock = PatternMatch >= Math.max(LockSize, 2);
        matchIndex += PatternMatch;
        int i = 0;
        while (i <= 5) {
            t0 = (int)((TarDist + (double)matchDist) / (20.0 - (double)3 * this.firePower));
            if (matchIndex + t0 < historyIndex) {
                matchDist = ((Float)bot.CumDist.get(matchIndex + t0)).floatValue() - ((Float)bot.CumDist.get(matchIndex)).floatValue();
            }
            ++i;
        }
        if (matchIndex + t0 < historyIndex) {
            matchAng = ((Float)bot.CumAngle.get(matchIndex + t0)).floatValue() - ((Float)bot.CumAngle.get(matchIndex)).floatValue();
            AimAng = Math.toDegrees(Math.asin((double)matchAng / (TarDist + (double)matchDist)));
        } else {
            this.pattLock = false;
        }
        gunHead = this.pattLock ? this.normalAbsoluteAngle(AimAng + this.TargetBearing) : this.TargetBearing;
        return gunHead;
    }

    public void onBulletHit(BulletHitEvent e) {
        Bullet Bull = e.getBullet();
        float BP = (float)Bull.getPower();
        float damage = BP > 1.0f ? (float)4 * BP + 2.0f * (BP - 1.0f) : (float)4 * BP;
        DGiven += damage;
        DGained += (float)3 * BP;
        ++BHit;
        Enemy bot = (Enemy)EBots.get(Bull.getVictim());
        if (bot != null) {
            double BullDist = this.getDist(this.getX(), this.getY(), bot.X, bot.Y);
            int BullIndex = this.DistIndex(BullDist);
            bot.DamGiven(this.Melee, BullIndex, damage);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Bullet Bull = e.getBullet();
        float BP = (float)Bull.getPower();
        float damage = BP > 1.0f ? (float)4 * BP + 2.0f * (BP - 1.0f) : (float)4 * BP;
        DTaken += damage;
        Enemy bot = (Enemy)EBots.get(Bull.getName());
        if (bot != null) {
            double BullDist = this.getDist(this.getX(), this.getY(), bot.X, bot.Y);
            int BullIndex = this.DistIndex(BullDist);
            bot.DamTaken(this.Melee, BullIndex, damage);
        }
    }

    public void onWin(WinEvent e) {
        ++win;
        this.WriteData();
        if (++OpRounds >= OpSize) {
            this.OpSetScore();
        }
        int i = 0;
        while (i < 50) {
            this.turnRight(90.0);
            this.turnGunLeft(90.0);
            this.fire(0.1);
            this.turnLeft(90.0);
            this.turnGunRight(90.0);
            this.fire(0.1);
            ++i;
        }
    }

    public void onDeath(DeathEvent e) {
        if (this.getOthers() == 0) {
            ++win;
        } else if (this.getOthers() == 1) {
            ++second;
        } else if (this.getOthers() == 2) {
            ++third;
        } else {
            ++loss;
        }
        this.WriteData();
        if (++OpRounds >= OpSize) {
            this.OpSetScore();
        }
    }

    public void WriteData() {
        EnemySave = this.getNumRounds() - (this.getRoundNum() + 1) < 1 || (this.getRoundNum() + 1) % 10 == 0;
        if (EnemySave) {
            this.out.println(" ********** ENEMY LIST **************************");
        }
        Enumeration enn = EBots.keys();
        while (enn.hasMoreElements()) {
            String s = (String)enn.nextElement();
            Enemy bot = (Enemy)EBots.get(s);
            bot.Alive = false;
            bot.Seen = false;
            int i = 0;
            while (i <= 1) {
                int FM = 0;
                float FP = 0.0f;
                float MO = 10.0f;
                double BDist = 999.0;
                int BI = 2;
                if (bot.Active) {
                    BI = bot.BestDI(i);
                }
                int j = 0;
                while (j <= 3) {
                    if (bot.AimProb(i, BI, j) > FP) {
                        FM = j;
                        MO = bot.BestOffset(i, BI, j);
                        FP = bot.AimProb(i, BI, j);
                    }
                    ++j;
                }
                if (EnemySave) {
                    if (i == 0) {
                        System.out.println(s + " 1v1 Best Method/DI: " + FM + '/' + BI + " Offset/Prob " + MO + '/' + FP);
                    } else {
                        System.out.println(s + " Melee Best Method/DI: " + FM + '/' + BI + " Offset/Prob " + MO + '/' + FP);
                    }
                }
                ++i;
            }
            if (!EnemySave || this.getNumRounds() - (this.getRoundNum() + 1) >= 1 || s.indexOf("sample.") == -1) continue;
            EBots.remove(s);
            System.out.println(s + " **Removed**");
        }
        this.out.println(" ****************************************");
        this.out.println(" Round " + (this.getRoundNum() + 1) + " of " + this.getNumRounds() + " Save=" + EnemySave);
        this.out.println(" " + win + ':' + second + ':' + third + " Wins:2nd:3rd & " + loss + " Losses : Damage Given/Taken " + DGiven + '/' + DTaken);
        this.out.println(" Wall Hits: " + wallHit + " VB Misses: " + VBMissScan + " Hit% " + (float)(BHit / BTotal * 100L));
        this.out.println(" ****************************************");
        if (EnemySave) {
            try {
                RobocodeFileOutputStream fo = new RobocodeFileOutputStream(this.getDataFile("enemy.dat"));
                ObjectOutputStream so = new ObjectOutputStream((OutputStream)fo);
                so.writeObject(EBots);
                so.flush();
                so.close();
                this.out.println("Data Written Successfully");
            }
            catch (IOException exc) {
                this.out.println("IOException trying to write: " + exc);
            }
        }
    }

    public void OpSetSetup() {
        Pop = new Vector();
        OpSet OS = new OpSet(0);
        OS.Score = 0.0;
        this.out.println("Creating New Base ");
        OS.ScoreDist = ScoreDist;
        OS.ScoreEnergy = ScoreEnergy;
        OS.ScoreWall = ScoreWall;
        OS.FightProb = FightProb;
        OS.AttackProb = AttackProb;
        OS.ForwardTime = ForwardTime;
        OS.ReverseTime = ReverseTime;
        OS.FPDistGain = FPDistGain;
        OS.FPProbGain = FPProbGain;
        OS.FPProbTarget = FPProbTarget;
        OS.searchDepth = searchDepth;
        OS.LockSize = LockSize;
        OS.PattSize = PattSize;
        OS.ScanLimit = ScanLimit;
        Pop.add(OS);
        Popi = 0;
        this.OpSetSave();
        if (Optimise == 1) {
            this.OpSetMove(0.1);
        } else if (Optimise == 2) {
            this.OpSetFire(0.1);
        }
    }

    public void OpSetMove(double HiLowPC) {
        Vector<OpSet> NewPop = new Vector<OpSet>();
        this.out.println("Movement Gradient Optimisation");
        OpSet TopOS = (OpSet)Pop.get(0);
        TopOS.Index = 0;
        TopOS.Score = 0.0;
        NewPop.add(TopOS);
        int HiLow = 0;
        int i = 1;
        while (i <= 10) {
            OpSet NewOS = new OpSet(i);
            NewOS.Score = 0.0;
            this.out.println("New Move OpSet " + i);
            HiLow = i <= 5 ? -1 : 1;
            NewOS.ScoreDist = i == 1 || i == 6 ? TopOS.ScoreDist * (1.0 + HiLowPC * (double)HiLow) : TopOS.ScoreDist;
            NewOS.ScoreEnergy = i == 2 || i == 7 ? TopOS.ScoreEnergy * (1.0 + HiLowPC * (double)HiLow) : TopOS.ScoreEnergy;
            NewOS.ScoreWall = i == 3 || i == 8 ? TopOS.ScoreWall * (1.0 + HiLowPC * (double)HiLow) : TopOS.ScoreWall;
            NewOS.FightProb = i == 4 || i == 9 ? TopOS.FightProb * (1.0 + HiLowPC * (double)HiLow) : TopOS.FightProb;
            NewOS.AttackProb = i == 5 || i == 10 ? TopOS.AttackProb * (1.0 + HiLowPC * (double)HiLow) : TopOS.AttackProb;
            NewOS.ForwardTime = TopOS.ForwardTime;
            NewOS.ReverseTime = TopOS.ReverseTime;
            NewOS.FPDistGain = TopOS.FPDistGain;
            NewOS.FPProbGain = TopOS.FPProbGain;
            NewOS.FPProbTarget = TopOS.FPProbTarget;
            NewOS.searchDepth = TopOS.searchDepth;
            NewOS.ScanLimit = TopOS.ScanLimit;
            NewOS.LockSize = TopOS.LockSize;
            NewOS.PattSize = TopOS.PattSize;
            NewPop.add(NewOS);
            ++i;
        }
        Pop = NewPop;
        this.OpSetSave();
    }

    public void OpSetFire(double HiLowPC) {
        Vector<OpSet> NewPop = new Vector<OpSet>();
        this.out.println("Fire Gradient Optimisation");
        OpSet TopOS = (OpSet)Pop.get(0);
        TopOS.Index = 0;
        TopOS.Score = 0.0;
        NewPop.add(TopOS);
        int HiLow = 0;
        int i = 1;
        while (i <= 10) {
            OpSet NewOS = new OpSet(i);
            NewOS.Score = 0.0;
            this.out.println("New Fire OpSet " + i);
            HiLow = i <= 5 ? -1 : 1;
            NewOS.FPDistGain = i == 1 || i == 6 ? TopOS.FPDistGain * (1.0 + HiLowPC * (double)HiLow) : TopOS.FPDistGain;
            NewOS.FPProbGain = i == 2 || i == 7 ? TopOS.FPProbGain * (1.0 + HiLowPC * (double)HiLow) : TopOS.FPProbGain;
            NewOS.FPProbTarget = i == 3 || i == 8 ? TopOS.FPProbTarget * (1.0 + HiLowPC * (double)HiLow) : TopOS.FPProbTarget;
            NewOS.searchDepth = i == 4 || i == 9 ? (int)Math.round((double)TopOS.searchDepth * (1.0 + HiLowPC * (double)HiLow)) : TopOS.searchDepth;
            NewOS.ScanLimit = i == 5 || i == 10 ? (int)Math.round((double)TopOS.ScanLimit * (1.0 + HiLowPC * (double)HiLow)) : TopOS.ScanLimit;
            NewOS.LockSize = TopOS.LockSize;
            NewOS.PattSize = TopOS.PattSize;
            NewOS.ScoreDist = TopOS.ScoreDist;
            NewOS.ScoreEnergy = TopOS.ScoreEnergy;
            NewOS.ScoreWall = TopOS.ScoreWall;
            NewOS.FightProb = TopOS.FightProb;
            NewOS.AttackProb = TopOS.AttackProb;
            NewOS.ForwardTime = TopOS.ForwardTime;
            NewOS.ReverseTime = TopOS.ReverseTime;
            NewPop.add(NewOS);
            ++i;
        }
        Pop = NewPop;
        this.OpSetSave();
    }

    public void OpSetLoad(int i) {
        OpSet OS = (OpSet)Pop.get(i);
        ScoreDist = OS.ScoreDist;
        ScoreEnergy = OS.ScoreEnergy;
        ScoreWall = OS.ScoreWall;
        FightProb = OS.FightProb;
        AttackProb = OS.AttackProb;
        ForwardTime = OS.ForwardTime;
        ReverseTime = OS.ReverseTime;
        FPDistGain = OS.FPDistGain;
        FPProbGain = OS.FPProbGain;
        FPProbTarget = OS.FPProbTarget;
        searchDepth = OS.searchDepth;
        ScanLimit = OS.ScanLimit;
        LockSize = OS.LockSize;
        PattSize = OS.PattSize;
        this.out.println("Using OpSet " + Popi);
        this.out.println("**** Move Parameters **** ");
        this.out.println("ScoreDist: " + ScoreDist);
        this.out.println("ScoreEnergy: " + ScoreEnergy);
        this.out.println("ScoreWall: " + ScoreWall);
        this.out.println("FightProb: " + FightProb);
        this.out.println("AttackProb: " + AttackProb);
        this.out.println("ForwardTime: " + ForwardTime);
        this.out.println("ReverseTime: " + ReverseTime);
        this.out.println("**** Fire Parameters **** ");
        this.out.println("FPDistGain: " + FPDistGain);
        this.out.println("FPProbGain: " + FPProbGain);
        this.out.println("FPProbTarget: " + FPProbTarget);
        this.out.println("searchDepth: " + searchDepth);
        this.out.println("ScanLimit: " + ScanLimit);
        this.out.println("LockSize: " + LockSize);
        this.out.println("PattSize: " + PattSize);
        this.out.println("************************");
    }

    public void OpSetScore() {
        OpSet SetOS = (OpSet)Pop.get(Popi);
        SetOS.Score = (double)(DGiven - DTaken) - OldScore;
        OldScore = DGiven - DTaken;
        OpRounds = 0;
        this.out.println("**** OpSet " + Popi + " **** ");
        this.out.println("**SCORE: " + SetOS.Score + "  (Total Score: F/A) " + OldScore + ": " + DGiven + '/' + DTaken);
        if (Optimise > 0) {
            this.OpSetSave();
            if (++Popi >= Pop.size()) {
                this.OpSetSort();
                this.OpSetLoad(0);
                this.OpSetSetup();
            }
        }
    }

    public void OpSetSort() {
        Vector<OpSet> SortPop = new Vector<OpSet>();
        int PopSize = Pop.size() - 1;
        int SIndex = 0;
        int SMaxIndex = 0;
        int k = 0;
        while (k <= PopSize) {
            OpSet SortOS = new OpSet(k);
            SortOS.Score = -10000.0;
            SIndex = 0;
            SMaxIndex = 0;
            Iterator SOSi = Pop.iterator();
            while (SOSi.hasNext()) {
                OpSet SrtOS = (OpSet)SOSi.next();
                if (SrtOS.Score > SortOS.Score) {
                    SortOS = SrtOS;
                    SMaxIndex = SIndex;
                }
                ++SIndex;
            }
            this.out.println("OpSet Rank " + k + " Score/Index:" + (float)SortOS.Score + '/' + SortOS.Index);
            SortPop.add(SortOS);
            Pop.remove(SMaxIndex);
            ++k;
        }
        Pop = SortPop;
    }

    public void OpSetSave() {
        try {
            RobocodeFileOutputStream foPOP = new RobocodeFileOutputStream(this.getDataFile("Optim.dat"));
            ObjectOutputStream soPOP = new ObjectOutputStream((OutputStream)foPOP);
            soPOP.writeObject(Pop);
            soPOP.flush();
            soPOP.close();
            this.out.println("Optimisation Data Written Successfully");
        }
        catch (IOException exc) {
            this.out.println("IOException trying to write: " + exc);
            exc.printStackTrace();
        }
    }

    public double normalAbsoluteAngle(double angle) {
        if (angle >= 0.0 && angle < 360.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle >= 360.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public double getDist(double x0, double y0, double x1, double y1) {
        double dist = Math.sqrt((x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1));
        if (dist < 1.0) {
            dist = 0.001;
        }
        return dist;
    }

    public double getAbsAngle(double x0, double y0, double x1, double y1) {
        if (y1 == y0) {
            if (x1 == x0) {
                return this.getHeading();
            }
            if (x1 < x0) {
                return 270.0;
            }
            return 90.0;
        }
        if (y1 < y0) {
            return this.normalAbsoluteAngle(Math.toDegrees(Math.atan((x1 - x0) / (y1 - y0))) - 180.0);
        }
        return this.normalAbsoluteAngle(Math.toDegrees(Math.atan((x1 - x0) / (y1 - y0))));
    }

    private final /* synthetic */ void this() {
        this.headChange = true;
        this.wiggle = 0.0;
        this.RandHeading = 30;
        this.Sector = 0;
        this.SearchStart = false;
        this.Searching = false;
        this.raDir = 1;
        this.AimOffset = 0.0f;
        this.FireDist = 400.0;
    }

    public BeoWulf() {
        this.this();
    }

    static {
        Optimise = 1;
        OpRounds = 0;
        OpSize = 30;
        OldScore = 0.0;
        Pop = null;
        Popi = 0;
        ScoreDist = 990.0;
        ScoreEnergy = 19.8;
        ScoreWall = 1210.0;
        FightProb = 9.7;
        AttackProb = 24.0;
        ForwardTime = 20;
        ReverseTime = 20;
        FPDistGain = 441.0;
        FPProbGain = 0.098;
        FPProbTarget = 11.34;
        searchDepth = 15;
        LockSize = 5;
        PattSize = 3000;
        ScanLimit = 600;
    }
}

