/*
 * Decompiled with CFR 0.152.
 */
package arthord.micro;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Apoptygma
extends AdvancedRobot {
    static final int GUESS_FACTORS = 101;
    static final int FACTOR_OFFSET = 50;
    static final int VIRTUAL_GUNS = 2;
    static final int DIST_FACTORS = 12;
    static final int DIST_SIZE = 100;
    static final int BUFFER_SIZE = 500000;
    static final int PATTERN_OFFSET = 249999;
    static final int PATTERN_WINDOW = 110;
    static int index = 0;
    static double eX;
    static double eY;
    static double eLastBearing;
    static double[] patternBuffer;
    static double[][] guessFactors;

    public void run() {
        eLastBearing = -1.0;
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        int x = 0;
        int bestx = 50;
        int matchx = 0;
        int distFactor = (int)e.getDistance() / 100;
        double best = 0.0;
        double targetBearing = e.getBearingRadians() + this.getHeadingRadians();
        double eDir = e.getVelocity() * Math.sin(e.getHeadingRadians() - d) > 0.0 ? 1 : -1;
        double patternOffset = 0.0;
        Apoptygma.patternBuffer[Apoptygma.index] = e.getVelocity();
        if (eLastBearing >= 0.0) {
            Apoptygma.patternBuffer[Apoptygma.index + 249999] = targetBearing - eLastBearing;
        }
        eLastBearing = targetBearing;
        double X = this.getX();
        eX = X + e.getDistance() * Math.sin(targetBearing);
        double Y = this.getY();
        eY = Y + e.getDistance() * Math.cos(targetBearing);
        do {
            if (patternBuffer[x] != patternBuffer[index] || patternBuffer[x + 249999] != patternBuffer[index + 249999]) continue;
            matchx = x;
        } while (++x < index - 110);
        x = 0;
        do {
            if ((double)x < e.getDistance() / 11.0) {
                patternOffset += patternBuffer[x + matchx + 249999];
            }
            VirtualBullet vb = new VirtualBullet();
            vb.x = X;
            vb.y = Y;
            vb.distFactor = distFactor;
            vb.heading = targetBearing + eDir * Math.toRadians(x - 50);
            vb.guessFactor = x;
            if (this.getGunHeat() == 0.0) {
                this.addCustomEvent(vb);
            }
            double[] dArray = guessFactors[distFactor];
            int n = x;
            double d2 = dArray[n] = dArray[n] * 0.99;
            if (!(d2 > best)) continue;
            best = guessFactors[distFactor][x];
            bestx = x;
        } while (++x < 101);
        VirtualBullet vg = new VirtualBullet();
        vg.x = X;
        vg.y = Y;
        vg.distFactor = distFactor;
        vg.heading = patternOffset += targetBearing;
        vg.guessFactor = 102;
        this.addCustomEvent(vg);
        vg = new VirtualBullet();
        vg.x = X;
        vg.y = Y;
        vg.distFactor = distFactor;
        vg.heading = targetBearing += eDir * Math.toRadians(bestx - 50);
        vg.guessFactor = 101;
        this.addCustomEvent(vg);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)((guessFactors[distFactor][101] > guessFactors[distFactor][102] ? targetBearing : patternOffset) - this.getGunHeadingRadians())));
        this.setTurnRightRadians(Math.cos(e.getBearingRadians()));
        if (this.getDistanceRemaining() == 0.0) {
            this.setAhead(Math.random() * 400.0 - 200.0);
        }
        this.setFire(3);
        ++index;
        this.setTurnRadarLeft(this.getRadarTurnRemaining());
    }

    static {
        patternBuffer = new double[500000];
        guessFactors = new double[12][103];
    }

    private class VirtualBullet
    extends Condition {
        int distFactor;
        int guessFactor;
        double x;
        double y;
        double heading;

        public boolean test() {
            this.x += Math.sin(this.heading) * 11.0;
            this.y += Math.cos(this.heading) * 11.0;
            if (Point2D.Double.distance(this.x, this.y, eX, eY) < 20.0) {
                double[] dArray = guessFactors[this.distFactor];
                int n = this.guessFactor;
                dArray[n] = dArray[n] + 0.01;
                Apoptygma.this.removeCustomEvent(this);
            }
            if (!new Rectangle2D.Double(0.0, 0.0, 800.0, 600.0).contains(this.x, this.y)) {
                Apoptygma.this.removeCustomEvent(this);
            }
            return false;
        }
    }
}

