/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Utils;

import rdt.Wraith.IRobot;
import rdt.Wraith.Utils.FastOutsideOfBattlefield;

public class RuleUtils {
    private static double _battleWidth;
    private static double _battleHeight;
    private static FastOutsideOfBattlefield _fastOutsideBattlefield;

    public static void Initialise(IRobot robot) {
        _battleWidth = robot.getBattleFieldWidth();
        _battleHeight = robot.getBattleFieldHeight();
        _fastOutsideBattlefield = new FastOutsideOfBattlefield(robot, 0);
    }

    public static double GetBulletVelocity(double bulletFirepower) {
        return 20.0 - 3.0 * bulletFirepower;
    }

    public static double GetClosestWallDistance(double x, double y) {
        return Math.min(Math.min(x, _battleWidth - x), Math.min(y, _battleHeight - y));
    }

    public static double GetDistanceToFurthestCorner(double x, double y) {
        double largestXDiff = Math.max(x, _battleWidth - x);
        double largestYDiff = Math.max(y, _battleHeight - y);
        return Math.sqrt(largestXDiff * largestXDiff + largestYDiff * largestYDiff);
    }

    public static boolean IsOutsideBattlefield(double x, double y, double padding) {
        if (x < padding) {
            return true;
        }
        if (y < padding) {
            return true;
        }
        if (x > _battleWidth - padding) {
            return true;
        }
        return y > _battleHeight - padding;
    }

    public static double GetDistanceToWall(double sourceX, double sourceY, double directionX, double directionY, double accuracy) {
        boolean outsideOfBattlefield = false;
        double x = sourceX;
        double y = sourceY;
        double dX = directionX * accuracy;
        double dY = directionY * accuracy;
        double distance = 0.0;
        do {
            distance += accuracy;
        } while (_fastOutsideBattlefield.Check(x += dX, y += dY) != 1.0);
        return distance;
    }
}

