/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Conversions;
import pedersen.core.Snapshot;
import pedersen.debug.Debug;
import pedersen.physics.DynamicHeading;
import pedersen.physics.DynamicHeadingImpl;
import pedersen.physics.DynamicPosition;
import pedersen.physics.DynamicPositionImpl;
import pedersen.physics.DynamicVelocity;
import pedersen.physics.DynamicVelocityImpl;
import pedersen.physics.StaticHeading;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import pedersen.physics.StaticVelocity;

public class Projection
implements DynamicPosition,
DynamicHeading,
DynamicVelocity {
    private DynamicPosition position = null;
    private DynamicHeading heading = null;
    private DynamicVelocity velocity = null;

    public Projection(Snapshot snapshot) {
        this.position = new DynamicPositionImpl(snapshot);
        this.heading = new DynamicHeadingImpl(snapshot);
        this.velocity = new DynamicVelocityImpl(snapshot);
    }

    public Projection(double x, double y, double newHeading, double newVelocity) {
        this.position = new DynamicPositionImpl(x, y);
        this.heading = new DynamicHeadingImpl(newHeading);
        this.velocity = new DynamicVelocityImpl(newVelocity);
    }

    public Projection(StaticPosition newPosition, double newHeading, double newVelocity) {
        this.position = new DynamicPositionImpl(newPosition);
        this.heading = new DynamicHeadingImpl(newHeading);
        this.velocity = new DynamicVelocityImpl(newVelocity);
    }

    public Projection(Projection other) {
        this.position = new DynamicPositionImpl(other.getStaticPosition());
        this.heading = new DynamicHeadingImpl(other.getHeading());
        this.velocity = new DynamicVelocityImpl(other.getVelocity());
    }

    public Projection project() {
        this.heading.setHeading(this.heading.projectHeading(Conversions.getAbsMaxTurnRateFromVelocity(this.getVelocity())));
        this.velocity.setVelocity(this.velocity.projectVelocity());
        this.position.add(new StaticVectorImpl(this.heading.getHeading(), this.velocity.getVelocity()));
        return this;
    }

    public void debug() {
        Debug.debug("Projection: ");
        this.position.debug();
        this.heading.debug();
        this.velocity.debug();
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public boolean equalsPosition(StaticPosition other) {
        return this.position.equalsPosition(other);
    }

    public StaticPosition getStaticPosition() {
        return this.position.getStaticPosition();
    }

    public void add(StaticPosition offset) {
        this.position.add(offset);
    }

    public void add(StaticVector vector) {
        this.position.add(vector);
    }

    public StaticPosition getRelativePosition(StaticPosition other) {
        return this.position.getRelativePosition(other);
    }

    public StaticVector getRelativeVector(StaticPosition other, double relativeHeading) {
        return this.position.getRelativeVector(other, relativeHeading);
    }

    public double getBearing(StaticPosition other) {
        return this.position.getBearing(other);
    }

    public double getDistance(StaticPosition other) {
        return this.position.getDistance(other);
    }

    public double getHeading() {
        return this.heading.getHeading();
    }

    public boolean equalsAngle(double other) {
        return this.heading.equalsAngle(other);
    }

    public double getRelativeAngle(double other) {
        return this.heading.getRelativeAngle(other);
    }

    public double getCompoundAngle(double other) {
        return this.heading.getCompoundAngle(other);
    }

    public StaticHeading getStaticHeading() {
        return this.heading.getStaticHeading();
    }

    public void setHeading(double newHeading) {
        this.heading.setHeading(newHeading);
    }

    public void setAbsoluteTargetHeading(double newHeading) {
        this.heading.setAbsoluteTargetHeading(newHeading);
    }

    public void setRelativeTargetHeading(double newHeading) {
        this.heading.setRelativeTargetHeading(newHeading);
    }

    public double projectHeading(double maxTurnRate) {
        return this.heading.projectHeading(maxTurnRate);
    }

    public double getVelocity() {
        return this.velocity.getVelocity();
    }

    public double getRelativeVelocity(double other) {
        return this.velocity.getRelativeVelocity(other);
    }

    public double getCompoundVelocity(double other) {
        return this.velocity.getCompoundVelocity(other);
    }

    public StaticVelocity getStaticVelocity() {
        return this.velocity.getStaticVelocity();
    }

    public void setVelocity(double newVelocity) {
        this.velocity.setVelocity(newVelocity);
    }

    public void setAbsoluteTargetVelocity(double newVelocity) {
        this.velocity.setAbsoluteTargetVelocity(newVelocity);
    }

    public void setRelativeTargetVelocity(double newVelocity) {
        this.velocity.setRelativeTargetVelocity(newVelocity);
    }

    public double projectVelocity() {
        return this.velocity.projectVelocity();
    }
}

