/*
 * Decompiled with CFR 0.152.
 */
package xander.core;

import java.util.ArrayList;
import java.util.List;
import xander.core.Component;
import xander.core.ComponentScenario;
import xander.core.ComponentSet;
import xander.core.DefaultScenario;
import xander.core.RegisteredComponentListener;
import xander.core.Resources;
import xander.core.Scenario;

public class ComponentChain {
    private List<ComponentScenario> componentScenarios = new ArrayList<ComponentScenario>();
    private List<RegisteredComponentListener> registeredComponentListeners = new ArrayList<RegisteredComponentListener>();

    public void addComponents(Scenario scenario, Component ... components) {
        this.componentScenarios.add(new ComponentScenario(scenario, components));
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            Resources.getRobotEvents().addRoundBeginListener(component);
            for (RegisteredComponentListener listener : this.registeredComponentListeners) {
                listener.componentRegistered(component);
            }
            ++n2;
        }
    }

    public void addDefaultComponents(Component ... components) {
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            this.addComponents(new DefaultScenario(), component);
            ++n2;
        }
    }

    void loadComponents(ComponentSet componentSet) {
        componentSet.clear();
        int i = 0;
        while (!componentSet.isComplete() && i < this.componentScenarios.size()) {
            ComponentScenario componentScenario = this.componentScenarios.get(i);
            componentScenario.loadComponents(componentSet);
            ++i;
        }
    }

    public void addRegisteredComponentListener(RegisteredComponentListener listener) {
        this.registeredComponentListeners.add(listener);
    }
}

