/*
 * Decompiled with CFR 0.152.
 */
package ouroboros;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Dragon
extends AdvancedRobot {
    static final int GUN_BINS = 230;
    static final int MAX_MATCHES = 50;
    static ArrayList hitScans = new ArrayList();
    public static Point2D.Double myLocation;
    public static Point2D.Double enemyLocation;
    public static ArrayList enemyWaves;
    public static ArrayList pastWaves;
    public static EnemyWaveDC _surfWave;
    public static double enemyEnergy;
    public static final Rectangle2D.Double fieldRect;
    public static final double WALL_STICK = 160.0;
    static StringBuilder data;
    static double lastLatVel;

    static {
        enemyEnergy = 100.0;
        fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        data = new StringBuilder();
    }

    public void run() {
        enemyWaves = new ArrayList();
        pastWaves = new ArrayList();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absBearing = e.getBearingRadians();
        double latVel = this.getVelocity() * Math.sin(absBearing);
        double advVel = this.getVelocity() * Math.cos(absBearing);
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)((absBearing += this.getHeadingRadians()) - this.getRadarHeadingRadians())) * 2.0);
        myLocation = new Point2D.Double(this.getX(), this.getY());
        EnemyWaveDC ew = new EnemyWaveDC();
        new EnemyWaveDC().direction = (int)Math.signum(latVel + 1.0E-10);
        ew.directAngle = absBearing + Math.PI;
        double[] dArray = new double[5];
        dArray[0] = 0.0;
        double eDistance = e.getDistance();
        dArray[1] = eDistance * 0.001;
        dArray[2] = advVel / 2.0;
        dArray[3] = lastLatVel / 2.0;
        dArray[4] = lastLatVel = Math.abs(latVel);
        ew.scan = dArray;
        pastWaves.add(0, ew);
        double d = enemyEnergy;
        enemyEnergy = e.getEnergy();
        Dragon.addWave(d - enemyEnergy);
        enemyLocation = Dragon.project(myLocation, absBearing, eDistance);
        Dragon.updateWaves();
        int direction = 1;
        if (this.checkDanger(-1) < this.checkDanger(1)) {
            direction = -1;
        }
        double goAngle = Dragon.wallSmoothing(myLocation, ew.directAngle + (double)direction * Dragon.offset(eDistance), direction) - this.getHeadingRadians();
        this.setAhead(Math.cos(goAngle) * Double.POSITIVE_INFINITY);
        this.setTurnRightRadians(Math.tan(goAngle));
        latVel = e.getHeadingRadians() - absBearing;
        data.insert(0, (char)((int)Math.round(e.getVelocity() * Math.sin(latVel)) << 8 | 0xFF & (byte)(e.getVelocity() * Math.cos(latVel))));
        double bulletPower = eDistance < 150.0 ? 3.0 : Math.min(2.0, Math.min(this.getEnergy() / 40.0, enemyEnergy / 2.0));
        this.setFire(bulletPower);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing + 0.005 + Dragon.getGunAngle(Math.min(66, Math.min(data.length(), pastWaves.size())), eDistance, bulletPower) - this.getGunHeadingRadians())));
    }

    public static double getGunAngle(int keyLength, double distance, double bulletPower) {
        int indexSize = 0;
        int[] index = new int[50];
        int tempIndex = 0;
        int[] bins = new int[230];
        while (true) {
            char comboChar;
            double d;
            if (tempIndex < 0) {
                keyLength = keyLength * 3 / 4;
            }
            if (((tempIndex = data.indexOf(data.substring(0, keyLength), tempIndex + 2)) < 0 || Arrays.binarySearch(index, tempIndex) >= 0) && keyLength > 0) continue;
            if (keyLength == 0) break;
            int iterateIndex = index[0] = tempIndex;
            Arrays.sort(index);
            double tempDist = distance;
            double absBearing = 0.0;
            double db = 0.0;
            do {
                comboChar = data.charAt(iterateIndex--);
                absBearing += (double)((byte)(comboChar >> 8)) / tempDist;
                db += Rules.getBulletSpeed((double)bulletPower);
            } while (d < (tempDist += (double)((byte)(comboChar & 0xFF))) && iterateIndex > 0);
            int n = (int)(Utils.normalAbsoluteAngle((double)absBearing) * 36.44648196804403);
            bins[n] = bins[n] + keyLength;
            if (++indexSize >= 50) break;
        }
        keyLength = 229;
        tempIndex = 0;
        do {
            if (bins[keyLength] <= bins[tempIndex]) continue;
            tempIndex = keyLength;
        } while (keyLength-- > 0);
        return (double)tempIndex * 0.027437490424365007;
    }

    public static void addWave(double deltaEnergy) {
        if (pastWaves.size() > 2 && deltaEnergy < 3.0001 && deltaEnergy > 0.009) {
            EnemyWaveDC ew = (EnemyWaveDC)pastWaves.get(2);
            ew.bulletVelocity = Rules.getBulletSpeed((double)deltaEnergy);
            ew.fireLocation = enemyLocation;
            enemyWaves.add(ew);
        }
    }

    public static void updateWaves() {
        double minTime = Double.NEGATIVE_INFINITY;
        _surfWave = null;
        Iterator it = enemyWaves.iterator();
        while (it.hasNext()) {
            double d;
            EnemyWaveDC ew = (EnemyWaveDC)it.next();
            double timeTillHit = ((ew.distanceTraveled += ew.bulletVelocity) - myLocation.distance(ew.fireLocation)) / ew.bulletVelocity;
            if (d > 50.0) {
                it.remove();
                continue;
            }
            if (!(timeTillHit > minTime) || !(timeTillHit < -1.0)) continue;
            _surfWave = ew;
            minTime = timeTillHit;
        }
    }

    public static double getFactor(EnemyWaveDC ew, Point2D.Double targetLocation) {
        return Utils.normalRelativeAngle((double)(Dragon.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle)) * (double)ew.direction / Math.asin(8.0 / ew.bulletVelocity);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Dragon.logEnemyBullet(e.getHitBullet());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Dragon.logEnemyBullet(e.getBullet());
        enemyEnergy += 3.0 * e.getBullet().getPower();
    }

    public void onBulletHit(BulletHitEvent e) {
        enemyEnergy -= Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    public static void logEnemyBullet(Bullet b) {
        Point2D.Double hitLocation = new Point2D.Double(b.getX(), b.getY());
        Iterator it = enemyWaves.iterator();
        while (it.hasNext()) {
            EnemyWaveDC ew = (EnemyWaveDC)it.next();
            if (!(Math.abs(ew.distanceTraveled - hitLocation.distance(ew.fireLocation)) <= 40.0)) continue;
            ew.scan[0] = Dragon.getFactor(ew, hitLocation);
            hitScans.add(ew.scan);
            it.remove();
        }
    }

    public double checkDanger(int direction) {
        Point2D.Double predictedPosition = myLocation;
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        EnemyWaveDC surfWave = _surfWave;
        int counter = 0;
        do {
            double moveAngle = Dragon.wallSmoothing(predictedPosition, Dragon.absoluteBearing(enemyLocation, predictedPosition) + (double)direction * Dragon.offset(predictedPosition.distance(enemyLocation)), direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + Dragon.posNegLimit(Utils.normalRelativeAngle((double)moveAngle), Rules.getTurnRateRadians((double)Math.abs(predictedVelocity)))));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
        } while (fieldRect.contains(predictedPosition = Dragon.project(predictedPosition, predictedHeading, predictedVelocity = Dragon.posNegLimit(predictedVelocity, 8.0))) && surfWave != null && predictedPosition.distance(surfWave.fireLocation) - 18.0 > surfWave.distanceTraveled + (double)(++counter) * surfWave.bulletVelocity);
        predictedVelocity = 1.0;
        if (surfWave != null) {
            predictedVelocity = Dragon.getDanger(Dragon.getFactor(surfWave, predictedPosition), surfWave.scan);
        }
        return predictedVelocity / predictedPosition.distanceSq(enemyLocation);
    }

    static final double getDanger(double GF, double[] location) {
        double danger = 0.0;
        for (double[] scan : hitScans) {
            double dist = 0.0;
            int j = 1;
            while (j < location.length) {
                dist += Math.abs(location[j] - scan[j]);
                ++j;
            }
            danger += 1.0 / (dist * (0.2 + Math.abs(GF - scan[0])));
        }
        return danger;
    }

    public static double offset(double distance) {
        return 0.5707963267948966 + 0.0016666666666666668 * distance;
    }

    public static double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!fieldRect.contains(Dragon.project(botLocation, angle += (double)orientation * 0.05, 160.0))) {
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double posNegLimit(double value, double max) {
        return Math.max(-max, Math.min(value, max));
    }

    static class EnemyWaveDC {
        Point2D.Double fireLocation;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
        double[] scan;

        EnemyWaveDC() {
        }
    }
}

