/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataIndex {
    protected Map<String, String[]> indexes = new HashMap<String, String[]>();
    protected List<String> names = new ArrayList<String>();

    public boolean addIndex(String name, int segments) {
        if (this.indexes.containsKey(name)) {
            return false;
        }
        String[] indexedNames = new String[segments];
        int i = 0;
        while (i < segments) {
            indexedNames[i] = String.valueOf(name) + ":" + i;
            ++i;
        }
        this.indexes.put(name, indexedNames);
        this.names.add(name);
        return true;
    }

    public List<String> getIndexNames() {
        return this.names;
    }

    public int getSegmentsByName(String name) {
        return this.indexes.get(name).length;
    }

    public DataQuery createQuery() {
        return new DataQuery();
    }

    protected String getSegmentForQuery(String name, int segment) {
        return this.indexes.get(name)[segment];
    }

    public class DataQuery {
        protected List<String> querySegments = new ArrayList<String>();

        protected DataQuery() {
        }

        public DataQuery addSegment(String name, int segment) {
            this.querySegments.add(DataIndex.this.getSegmentForQuery(name, segment));
            return this;
        }

        public DataQuery addSegment(String name, double value, double minValue, double maxValue) {
            return this.addSegment(name, (int)((value - minValue) * (double)(DataIndex.this.indexes.get(name).length - 1) / (maxValue - minValue)));
        }

        public List<String> getQuerySegments() {
            return this.querySegments;
        }
    }
}

