/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.data;

import java.util.HashMap;
import java.util.Map;
import lazarecki.data.DataIndex;

public class DataSegmentation {
    protected DataIndex index;
    protected Map segments;

    public DataSegmentation(DataIndex index) {
        this.index = index;
        this.segments = this.createSegments(index.getIndexNames().get(0));
    }

    public DataQueryResult queryData(DataIndex.DataQuery query) {
        Map retVal = this.segments;
        if (query != null) {
            for (String segment : query.getQuerySegments()) {
                retVal = (Map)retVal.get(segment);
            }
        }
        return new DataQueryResult(retVal);
    }

    protected Map createSegments(String name) {
        int currentNameIndex = this.index.getIndexNames().indexOf(name);
        if (currentNameIndex == this.index.getIndexNames().size() - 1) {
            HashMap<Integer, Double> segs = new HashMap<Integer, Double>();
            int i = 0;
            while (i < this.index.getSegmentsByName(name)) {
                segs.put(i, 0.0);
                ++i;
            }
            return segs;
        }
        HashMap<String, Map> segs = new HashMap<String, Map>();
        int i = 0;
        while (i < this.index.getSegmentsByName(name)) {
            segs.put(String.valueOf(name) + ":" + i, this.createSegments(this.index.getIndexNames().get(currentNameIndex + 1)));
            ++i;
        }
        return segs;
    }

    public class DataQueryResult {
        protected Map<Integer, Double> segs;

        protected DataQueryResult(Map segs) {
            this.segs = segs;
        }

        public int getIndexFor(double value, double minValue, double maxValue) {
            return (int)((value - minValue) * ((double)this.segs.size() - 1.0) / (maxValue - minValue));
        }

        public double getValueAt(int i) {
            return this.segs.get(i);
        }

        public double getValueFor(double value, double minValue, double maxValue) {
            return this.getValueAt(this.getIndexFor(value, minValue, maxValue));
        }

        public double setValueAt(int i, double newValue) {
            return this.segs.put(i, newValue);
        }

        public double setValueFor(double value, double minValue, double maxValue, double newValue) {
            return this.setValueAt(this.getIndexFor(value, minValue, maxValue), newValue);
        }

        public double modifyValueAt(int i, double increment) {
            return this.segs.put(i, this.segs.get(i) + increment);
        }

        public double modifyValueFor(double value, double minValue, double maxValue, double increment) {
            return this.modifyValueAt(this.getIndexFor(value, minValue, maxValue), increment);
        }

        public int getSegments() {
            return this.segs.size();
        }

        public Object clone() {
            return new DataQueryResult(new HashMap<Integer, Double>(this.segs));
        }
    }
}

