/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.mega.index;

import lazarecki.mega.index.Index;
import lazarecki.robot.RobotInfo;

public class LateralVelocityIndex
implements Index {
    private int segments;
    private boolean inverted;

    public LateralVelocityIndex(int segments, boolean inverted) {
        this.segments = segments;
        this.inverted = inverted;
    }

    public LateralVelocityIndex(boolean inverted) {
        this(5, inverted);
    }

    @Override
    public String getName() {
        return "LateralVelocity";
    }

    @Override
    public int getSegmentIndex(RobotInfo me, RobotInfo enemy) {
        double velocity = !this.inverted ? Math.abs(enemy.getVelocity() * Math.sin(enemy.getHeadingRadians() - me.absoluteAngle(enemy))) : Math.abs(me.getVelocity() * Math.sin(me.getHeadingRadians() - enemy.absoluteAngle(me)));
        return (int)(velocity / (double)this.getSegments());
    }

    @Override
    public int getSegments() {
        return this.segments;
    }
}

