/*
 * Decompiled with CFR 0.152.
 */
package rdt199.movement;

import rdt199.util.BotFuncs;
import rdt199.util.Location;

public class GravityPoint {
    protected Location m_Location;
    protected double m_dStrength;

    public GravityPoint(Location loc, double strength) {
        this.m_Location = loc;
        this.m_dStrength = strength;
    }

    public double getGravity(Location loc) {
        double dDistance = BotFuncs.getDistanceBetween(this.m_Location, loc);
        return this.m_dStrength / (dDistance * dDistance);
    }

    public Location calcGravity() {
        double dDistance = BotFuncs.getDistanceBetween(new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY()), this.m_Location);
        double dAngle = BotFuncs.getAbsBearing(this.m_Location.getX(), this.m_Location.getY(), BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY());
        double dForce = this.m_dStrength / (dDistance * dDistance);
        double dGX = Math.sin(dAngle) * dForce;
        double dGY = Math.cos(dAngle) * dForce;
        return new Location(dGX, dGY);
    }

    public Location calcWallGravity() {
        double dDistance = BotFuncs.getDistanceBetween(new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY()), this.m_Location);
        double dAngle = BotFuncs.getAbsBearing(this.m_Location.getX(), this.m_Location.getY(), BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY());
        double dForce = this.m_dStrength / (dDistance * dDistance * dDistance);
        double dGX = Math.sin(dAngle) * dForce;
        double dGY = Math.cos(dAngle) * dForce;
        return new Location(dGX, dGY);
    }
}

