/*
 * Decompiled with CFR 0.152.
 */
package kid.robot;

import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import kid.communication.RobotMessage;
import kid.communication.ScannedRobotMessage;
import kid.data.Drawable;
import kid.data.Printable;
import kid.data.gravity.GravityObject;
import kid.graphics.Colors;
import kid.graphics.DrawMenu;
import kid.graphics.RGraphics;
import kid.segmentation.Segmentable;
import kid.utils.Utils;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class RobotData
implements Cloneable,
Serializable,
Segmentable,
Printable,
Drawable,
GravityObject {
    private static final long serialVersionUID = 6554353696765554133L;
    public static final String ALIVE = "Alive";
    public static final String DISABLED = "Disabled";
    public static final String DEAD = "Dead";
    public static final String DUMMY = "Dummy";
    protected static final double AVERAGE_WEIGHT = 5.0;
    protected static final double DEAD_ENERGY = -1.0;
    protected String name;
    protected String alias;
    protected double x;
    protected double y;
    protected double energy;
    protected double deltaEnergy;
    protected double heading;
    protected double deltaHeading;
    protected double avgDeltaHeading;
    protected double velocity;
    protected double deltaVelocity;
    protected double avgVelocity;
    protected double avgDeltaVelocity;
    protected long time;

    public RobotData() {
        this.init(new String(), -5000000.0, -5000000.0, -1.0, 0.0, 0.0, -1L);
        this.setAlias(DUMMY);
    }

    public RobotData(String name, double curX, double curY, double curEnergy, double curHeading, double curVelocity, long curTime) {
        this.init(name, curX, curY, curEnergy, curHeading, curVelocity, curTime);
    }

    public RobotData(ScannedRobotEvent sre, Robot myRobot) {
        double curX = Utils.getX(myRobot.getX(), sre.getDistance(), myRobot.getHeading() + sre.getBearing());
        double curY = Utils.getY(myRobot.getY(), sre.getDistance(), myRobot.getHeading() + sre.getBearing());
        this.init(sre.getName(), curX, curY, sre.getEnergy(), sre.getHeading(), sre.getVelocity(), sre.getTime());
    }

    public RobotData(ScannedRobotMessage srm, Robot myRobot) {
        double curX = Utils.getX(myRobot.getX(), srm.getDistance(), srm.getAngle());
        double curY = Utils.getY(myRobot.getY(), srm.getDistance(), srm.getAngle());
        this.init(srm.getName(), curX, curY, srm.getEnergy(), srm.getHeading(), srm.getVelocity(), srm.getTime());
    }

    public RobotData(ScannedRobotEvent sre, RobotData myRobot) {
        double curX = Utils.getX(myRobot.getX(), sre.getDistance(), myRobot.getHeading() + sre.getBearing());
        double curY = Utils.getY(myRobot.getY(), sre.getDistance(), myRobot.getHeading() + sre.getBearing());
        this.init(sre.getName(), curX, curY, sre.getEnergy(), sre.getHeading(), sre.getVelocity(), sre.getTime());
    }

    public RobotData(ScannedRobotMessage srm, RobotData myRobot) {
        double curX = Utils.getX(myRobot.getX(), srm.getDistance(), srm.getAngle());
        double curY = Utils.getY(myRobot.getY(), srm.getDistance(), srm.getAngle());
        this.init(srm.getName(), curX, curY, srm.getEnergy(), srm.getHeading(), srm.getVelocity(), srm.getTime());
    }

    public RobotData(Robot myRobot) {
        this.init(myRobot.getName(), myRobot.getX(), myRobot.getY(), myRobot.getEnergy(), myRobot.getHeading(), myRobot.getVelocity(), myRobot.getTime());
    }

    public RobotData(RobotData robot) {
        this.init(robot.getName(), robot.getAlias(), robot.getX(), robot.getY(), robot.getEnergy(), robot.getDeltaEnergy(), robot.getHeading(), robot.getDeltaHeading(), robot.getAvgDeltaHeading(), robot.getVelocity(), robot.getDeltaVelocity(), robot.getAvgVelocity(), robot.getAvgDeltaVelocity(), robot.getTime());
    }

    protected void init(String name, double curX, double curY, double curEnergy, double curHeading, double curVelocity, long curTime) {
        this.init(name, curEnergy > 0.0 ? ALIVE : DEAD, curX, curY, curEnergy, 0.0, curHeading, 0.0, 0.0, curVelocity, 0.0, curVelocity, 0.0, curTime);
    }

    protected void init(String name, String alias, double x, double y, double energy, double deltaEnergy, double heading, double deltaHeading, double avgDeltaHeading, double velocity, double deltaVelocity, double avgVelocity, double avgDeltaVelocity, long time) {
        this.name = name;
        this.alias = alias;
        this.x = x;
        this.y = y;
        this.energy = energy;
        this.deltaEnergy = deltaEnergy;
        this.heading = heading;
        this.deltaHeading = deltaHeading;
        this.avgDeltaHeading = avgDeltaHeading;
        this.velocity = velocity;
        this.deltaVelocity = deltaVelocity;
        this.avgVelocity = avgVelocity;
        this.avgDeltaVelocity = avgDeltaVelocity;
        this.time = time;
    }

    public void update(double curX, double curY, double curEnergy, double curHeading, double curVelocity, long curTime) {
        long deltaTime = curTime - this.time;
        this.x = curX;
        this.y = curY;
        this.deltaEnergy = (curEnergy - this.energy) / (double)deltaTime;
        this.energy = curEnergy;
        this.deltaHeading = Utils.relative(curHeading - this.heading) / (double)deltaTime;
        this.avgDeltaHeading = Utils.weightedAvg(this.avgDeltaHeading, 5.0, this.deltaHeading, 1.0);
        this.heading = curHeading;
        this.deltaVelocity = (curVelocity - this.velocity) / (double)deltaTime;
        this.avgDeltaVelocity = Utils.weightedAvg(this.avgDeltaVelocity, 5.0, this.deltaVelocity, 1.0);
        this.avgVelocity = Utils.weightedAvg(this.avgVelocity, 5.0, this.velocity, 1.0);
        this.velocity = curVelocity;
        this.time = curTime;
    }

    private void updateFromDeath(double curX, double curY, double curEnergy, double curHeading, double curVelocity, long curTime) {
        this.setAlias(ALIVE);
        this.x = curX;
        this.y = curY;
        this.energy = curEnergy;
        this.deltaEnergy = 0.0;
        this.deltaHeading = 0.0;
        this.avgDeltaHeading = 0.0;
        this.heading = curHeading;
        this.deltaVelocity = 0.0;
        this.avgDeltaVelocity = 0.0;
        this.avgVelocity = 0.0;
        this.velocity = curVelocity;
        this.time = curTime;
    }

    public void update(ScannedRobotEvent sre, Robot myRobot) {
        if (myRobot.getTime() - this.time < 0L && this.isDead()) {
            double curX = Utils.getX(myRobot.getX(), sre.getDistance(), myRobot.getHeading() + sre.getBearing());
            double curY = Utils.getY(myRobot.getY(), sre.getDistance(), myRobot.getHeading() + sre.getBearing());
            this.updateFromDeath(curX, curY, sre.getEnergy(), sre.getHeading(), sre.getVelocity(), sre.getTime());
        } else if (myRobot.getTime() - this.time > 0L && !this.isDead()) {
            double curX = Utils.getX(myRobot.getX(), sre.getDistance(), myRobot.getHeading() + sre.getBearing());
            double curY = Utils.getY(myRobot.getY(), sre.getDistance(), myRobot.getHeading() + sre.getBearing());
            this.update(curX, curY, sre.getEnergy(), sre.getHeading(), sre.getVelocity(), sre.getTime());
        }
    }

    public void update(ScannedRobotMessage srm, Robot myRobot) {
        if (myRobot.getTime() - this.time < 0L && this.isDead()) {
            double curX = Utils.getX(myRobot.getX(), srm.getDistance(), srm.getAngle());
            double curY = Utils.getY(myRobot.getY(), srm.getDistance(), srm.getAngle());
            this.updateFromDeath(curX, curY, srm.getEnergy(), srm.getHeading(), srm.getVelocity(), srm.getTime());
        } else if (myRobot.getTime() - this.time > 0L && !this.isDead()) {
            double curX = Utils.getX(myRobot.getX(), srm.getDistance(), srm.getAngle());
            double curY = Utils.getY(myRobot.getY(), srm.getDistance(), srm.getAngle());
            this.update(curX, curY, srm.getEnergy(), srm.getHeading(), srm.getVelocity(), srm.getTime());
        }
    }

    public void update(RobotMessage rm, Robot myRobot) {
        if (myRobot.getTime() - this.time < 0L && this.isDead()) {
            this.updateFromDeath(rm.getX(), rm.getY(), rm.getEnergy(), rm.getHeading(), rm.getVelocity(), rm.getTime());
        } else if (myRobot.getTime() - this.time > 0L && !this.isDead()) {
            this.update(rm.getX(), rm.getY(), rm.getEnergy(), rm.getHeading(), rm.getVelocity(), rm.getTime());
        }
    }

    public void update(Robot myRobot) {
        if (myRobot.getTime() - this.time < 0L && this.isDead()) {
            this.updateFromDeath(myRobot.getX(), myRobot.getY(), myRobot.getEnergy(), myRobot.getHeading(), myRobot.getVelocity(), myRobot.getTime());
        } else if (myRobot.getTime() - this.time > 0L && !this.isDead()) {
            this.update(myRobot.getX(), myRobot.getY(), myRobot.getEnergy(), myRobot.getHeading(), myRobot.getVelocity(), myRobot.getTime());
        }
    }

    public void setDeath() {
        this.setAlias(DEAD);
        this.energy = -1.0;
    }

    public void setAlias(String newAlias) {
        if (newAlias != null) {
            this.alias = newAlias;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isDead() {
        return this.getEnergy() == -1.0 || this.isDummy();
    }

    public boolean isDummy() {
        return this.getAlias().equals(DUMMY);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Rectangle2D getRectangle() {
        return new Rectangle2D.Double(this.getX() - 18.0, this.getY() - 18.0, 36.0, 36.0);
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getDeltaEnergy() {
        return this.deltaEnergy;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getDeltaHeading() {
        return this.deltaHeading;
    }

    public double getAvgDeltaHeading() {
        return this.avgDeltaHeading;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getDeltaVelocity() {
        return this.deltaVelocity;
    }

    public double getAvgVelocity() {
        return this.avgVelocity;
    }

    public double getAvgDeltaVelocity() {
        return this.avgDeltaVelocity;
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public boolean active(long time) {
        return !this.isDead();
    }

    @Override
    public double angle(double x, double y) {
        return Utils.angle(this.getX(), this.getY(), x, y);
    }

    @Override
    public double deltaX(double x) {
        return this.getX() - x;
    }

    @Override
    public double deltaY(double y) {
        return this.getY() - y;
    }

    @Override
    public double dist(double x, double y) {
        return Utils.sqrt(this.distSq(x, y));
    }

    @Override
    public double distSq(double x, double y) {
        return Utils.distSq(this.deltaX(x), this.deltaY(y));
    }

    @Override
    public double getStrength() {
        return this.getEnergy();
    }

    @Override
    public void print(PrintStream console) {
        console.println(this.toString());
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
        PrintStream file = new PrintStream((OutputStream)output);
        file.println(this.getClass() + ": " + this.getName() + " at Time: " + this.getTime());
        file.println("Current Alias:          " + this.getAlias());
        file.println("Coordinates:           (" + Math.round(this.getX()) + ", " + Math.round(this.getY()) + ")");
        file.println("Energy:                 " + this.getEnergy());
        file.println("Heading:                " + this.getHeading());
        file.println("Delta Heading:          " + this.getDeltaHeading());
        file.println("Average Delta Heading:  " + this.getAvgDeltaHeading());
        file.println("Velocty:                " + this.getVelocity());
        file.println("Delta Velocity:         " + this.getDeltaVelocity());
        file.println("Average Delta Velocity: " + this.getAvgDeltaVelocity());
        file.println();
    }

    @Override
    public void draw(RGraphics grid) {
        if (this.isDead()) {
            return;
        }
        if (DrawMenu.getValue("Square", "Robot")) {
            grid.setColor(Colors.LIGHT_GRAY);
            grid.draw(this.getRectangle());
        }
    }

    public RobotData copy() {
        return new RobotData(this);
    }

    public Object clone() {
        return new RobotData(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RobotData) {
            RobotData robot = (RobotData)obj;
            return robot.getName().equals(this.getName()) && robot.getTime() == this.getTime();
        }
        return false;
    }

    public String toString() {
        return new String(this.getClass() + ": " + this.getName() + ": (" + this.getX() + ", " + this.getY() + ") " + this.getEnergy() + " " + this.getHeading() + " " + this.getVelocity() + " " + this.getTime());
    }

    protected void finalize() throws Throwable {
        this.name = null;
        this.alias = null;
        this.x = 0.0;
        this.y = 0.0;
        this.energy = 0.0;
        this.heading = 0.0;
        this.deltaHeading = 0.0;
        this.avgDeltaHeading = 0.0;
        this.velocity = 0.0;
        this.deltaVelocity = 0.0;
        this.avgDeltaVelocity = 0.0;
        this.time = 0L;
        super.finalize();
    }
}

