/*
 * Decompiled with CFR 0.152.
 */
package ethdsy;

import ethdsy.FireStat;
import ethdsy.Malacka;

public class RobotInfo {
    Malacka me;
    String name;
    public double bearing;
    public double guessedBearing;
    public double head;
    public long ctime;
    public double speed;
    public double x;
    public double y;
    public double distance;
    public double energy;
    public int bulletHit;
    public int bulletTry;
    private double oldHead;
    private long oldTime;
    protected double oldSpeed;
    private double olderSpeed;
    public long period;
    private long periodN;
    private double periodX;
    private double periodY;
    private double periodRange;
    public long periodTime;
    private boolean periodOn = false;
    public boolean usePeriod = false;
    double fireX;
    double fireY;
    public int[] nextVelocity = new int[34];
    public int[] timeDiff = new int[34];
    public double[] nextHead = new double[34];
    public long speedStamp;
    public FireStat[][] fireStat;
    public int[] currentFire;

    public RobotInfo(String string, Malacka malacka) {
        this.name = string;
        this.me = malacka;
        this.fireStat = new FireStat[3][Malacka.fires.size()];
        this.currentFire = new int[3];
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < this.fireStat[0].length) {
                this.fireStat[n][n2] = new FireStat(this);
                ++n2;
            }
            ++this.fireStat[n][0].nb;
            ++n;
        }
    }

    public void setPos(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setHead(double d) {
        this.oldHead = this.head;
        this.head = d;
    }

    public void setTime(long l) {
        this.oldTime = this.ctime;
        this.ctime = l;
    }

    public void setDistance(double d) {
        this.distance = d;
    }

    public void setBearing(double d) {
        this.bearing = d;
    }

    public void setSpeed(double d) {
        if (this.olderSpeed != this.oldSpeed) {
            this.timeDiff[this.speedIndex((double)this.olderSpeed, (double)this.oldSpeed)] = (int)(this.ctime - this.speedStamp);
            this.speedStamp = 0L;
            this.olderSpeed = this.oldSpeed;
        }
        this.oldSpeed = this.speed;
        this.speed = d;
        if (this.oldSpeed != d) {
            int n = this.speedIndex(this.olderSpeed, this.oldSpeed);
            this.nextVelocity[n] = (int)d;
            this.nextHead[n] = this.head - this.oldHead;
        }
        if (!this.periodOn && d == 0.0) {
            if (this.periodTime > 0L) {
                long l = this.ctime - this.periodTime;
                if (this.period == 0L) {
                    this.period = l;
                } else if (Math.abs(l - this.period) > 3L) {
                    this.period = l;
                    this.usePeriod = false;
                } else {
                    this.usePeriod = true;
                }
                this.periodRange = this.me.getrange(this.x, this.y, this.periodX, this.periodY) * 0.75;
            }
            this.periodX = this.x;
            this.periodY = this.y;
            this.periodTime = this.ctime;
        } else if (this.periodOn && d > 0.0) {
            this.periodOn = false;
        }
    }

    public void setEnergy(double d) {
        this.energy = d;
    }

    public void addBulletHit() {
        ++this.bulletHit;
    }

    public void removeBulletHit() {
        if (this.bulletHit > 0) {
            --this.bulletHit;
        }
    }

    public void addBulletTry() {
        ++this.bulletTry;
    }

    public void removeBulletTry() {
        --this.bulletTry;
    }

    public double getValue() {
        if (this.onMyTeam()) {
            return 0.1;
        }
        double d = 200000.0 / this.distance + (double)(this.bulletHit * 300) + 200.0 / this.energy - (double)(this.bulletTry * 20);
        if (this.speed < 0.1) {
            d += 200.0;
        }
        if (d < 0.1) {
            d = 0.1;
        }
        return d;
    }

    double getRadDiff() {
        double d = this.head - this.oldHead;
        return d / (double)(this.ctime - this.oldTime);
    }

    double getSpeedDiff() {
        return (this.speed - this.oldSpeed) / (double)(this.ctime - this.oldTime);
    }

    int speedIndex(double d, double d2) {
        int n = (int)d2 + 8;
        if (d > d2) {
            n += 17;
        }
        return n;
    }

    public boolean onMyTeam() {
        return this.me.isTeammate(this.name);
    }

    public void reset() {
        this.bulletTry = 0;
        this.bulletHit = 0;
        this.ctime = 0L;
    }
}

