/*
 * Decompiled with CFR 0.152.
 */
package et;

abstract class CircularBuf {
    protected long[] tbuf;
    protected int pos = 0;
    protected int siz = 0;

    private CircularBuf() {
    }

    public CircularBuf(int n) {
        this.siz = n;
        this.tbuf = new long[this.siz];
    }

    protected final int relPos(int n) {
        return Math.abs((this.pos - n - 1) % this.siz);
    }

    public final int size() {
        return this.siz;
    }

    public final long getTimeStamp(int n) {
        return this.tbuf[this.relPos(n)];
    }

    public final long deltaT() {
        return this.getTimeStamp(0) - this.getTimeStamp(1);
    }

    public final long deltaT(int n) {
        return this.getTimeStamp(0) - this.getTimeStamp(n);
    }

    public final long deltaTFull() {
        return this.getTimeStamp(0) - this.getTimeStamp(this.siz - 1);
    }

    public int timeToPos(long l) {
        int n = 1;
        while (n < this.size()) {
            if (this.deltaT(n) >= l) break;
            ++n;
        }
        return n;
    }
}

