/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.info.battle;

import dsekercioglu.mega.core.wiki.FastMath;
import dsekercioglu.mega.rMove.MoveUtils;
import dsekercioglu.mega.rMove.info.EnemyTargetingInfo;
import dsekercioglu.mega.rMove.info.battle.BattleSummary;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class BattleInfo {
    private final AdvancedRobot ROBOT;
    private final double BATTLE_FIELD_WIDTH;
    private final double BATTLE_FIELD_HEIGHT;
    private final double GUN_COOLING_RATE;
    private final Point2D.Double BOT_LOCATION = new Point2D.Double();
    private final Point2D.Double ENEMY_LOCATION = new Point2D.Double();
    private EnemyTargetingInfo enemyTargetingInfo;
    private double distance;
    private double absoluteBearing;
    private double botVelocity;
    private double botHeading;
    private double botBearing;
    private double botLateralVelocity;
    private double botLateralDirection = 1.0;
    private double botLateralAcceleration;
    private double botAdvancingVelocity;
    private double botTimeSinceDeceleration;
    private double botTimeSinceDirectionChange;
    private double botEnergy;
    private double enemyEnergy;
    private boolean enemyFired;
    private double enemyFirePower;
    private double enemyGunHeat;
    private double enemyVelocity;
    private double enemyHeading;
    private int enemyFireNum;
    private int enemyHitNum;
    private double enemyWeightedFireRate = 200.0;
    private double enemyWeightedHitRate;

    public BattleInfo(AdvancedRobot advancedRobot) {
        this.ROBOT = advancedRobot;
        this.BATTLE_FIELD_WIDTH = advancedRobot.getBattleFieldWidth();
        this.BATTLE_FIELD_HEIGHT = advancedRobot.getBattleFieldHeight();
        this.GUN_COOLING_RATE = advancedRobot.getGunCoolingRate();
    }

    public void run() {
        this.botTimeSinceDirectionChange = 0.0;
        this.botTimeSinceDeceleration = 0.0;
    }

    public BattleSummary getSummary() {
        BattleSummary battleSummary = new BattleSummary();
        battleSummary.botLocation = (Point2D.Double)this.BOT_LOCATION.clone();
        battleSummary.distance = this.distance;
        battleSummary.botBearing = this.botBearing;
        battleSummary.botVelocity = this.botVelocity;
        battleSummary.botLateralVelocity = this.botLateralVelocity;
        battleSummary.botLateralDirection = this.botLateralDirection;
        battleSummary.botAdvancingVelocity = this.botAdvancingVelocity;
        battleSummary.botLateralAcceleration = this.botLateralAcceleration;
        battleSummary.botTimeSinceDeceleration = this.botTimeSinceDeceleration;
        battleSummary.botTimeSinceDirectionChange = this.botTimeSinceDirectionChange;
        battleSummary.forwardWallMEA = this.getMEA(1);
        battleSummary.backwardWallMEA = this.getMEA(-1);
        battleSummary.enemyWeightedHitRate = this.getEnemyWeightedHitRate();
        battleSummary.battleFieldWidth = this.BATTLE_FIELD_WIDTH;
        battleSummary.battleFieldHeight = this.BATTLE_FIELD_HEIGHT;
        return battleSummary;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.BOT_LOCATION.setLocation(this.ROBOT.getX(), this.ROBOT.getY());
        this.botEnergy = this.ROBOT.getEnergy();
        this.distance = e.getDistance();
        this.botHeading = this.ROBOT.getHeadingRadians();
        this.botBearing = e.getBearingRadians();
        double oldAbsoluteBearing = this.absoluteBearing;
        this.absoluteBearing = this.botHeading + this.botBearing;
        this.ENEMY_LOCATION.setLocation(this.BOT_LOCATION.getX() + FastMath.sin(this.absoluteBearing) * this.distance, this.BOT_LOCATION.getY() + FastMath.cos(this.absoluteBearing) * this.distance);
        this.enemyTargetingInfo = new EnemyTargetingInfo((Point2D.Double)this.ENEMY_LOCATION.clone(), oldAbsoluteBearing + Math.PI);
        double oldEnemyEnergy = this.enemyEnergy;
        this.enemyEnergy = e.getEnergy();
        double deltaEnergy = oldEnemyEnergy - this.enemyEnergy;
        this.enemyGunHeat = Math.max(0.0, this.enemyGunHeat - this.GUN_COOLING_RATE);
        if (deltaEnergy > 0.0999 && deltaEnergy < 3.001 && this.enemyGunHeat <= 0.0) {
            ++this.enemyFireNum;
            this.enemyFired = true;
            this.enemyFirePower = deltaEnergy;
            this.enemyGunHeat = 1.0 + deltaEnergy / 5.0 - this.GUN_COOLING_RATE;
            double bulletVelocity = 20.0 - 3.0 * deltaEnergy;
            double botWidth = 2.0 * FastMath.atan(25.0 / this.distance);
            double hitChance = botWidth / Math.asin(8.0 / bulletVelocity);
            this.enemyWeightedFireRate += 1.0 / hitChance;
        } else {
            this.enemyFired = false;
        }
        this.botVelocity = this.ROBOT.getVelocity();
        double oldLateralVelocity = this.botLateralVelocity;
        this.botLateralVelocity = FastMath.sin(this.botBearing) * this.botVelocity;
        double oldLateralDirection = this.botLateralDirection;
        this.botLateralDirection = this.botLateralVelocity > 0.0 ? 1.0 : (this.botLateralVelocity < 0.0 ? -1.0 : this.botLateralDirection);
        this.botAdvancingVelocity = -FastMath.cos(this.botBearing) * this.botVelocity;
        this.botLateralAcceleration = Math.abs(this.botLateralVelocity) - oldLateralVelocity;
        this.botTimeSinceDeceleration = this.botLateralAcceleration >= 0.0 ? this.botTimeSinceDirectionChange + 1.0 : 0.0;
        this.botTimeSinceDirectionChange = oldLateralDirection == this.botLateralDirection ? this.botTimeSinceDirectionChange + 1.0 : 0.0;
        this.enemyVelocity = e.getVelocity();
        this.enemyHeading = e.getHeadingRadians();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double bulletVelocity = e.getVelocity();
        ++this.enemyHitNum;
        this.enemyEnergy += e.getBullet().getPower() * 3.0;
        if (this.distance > 200.0) {
            double botWidth = 2.0 * FastMath.atan(25.0 / this.distance);
            double hitChance = botWidth / Math.asin(8.0 / bulletVelocity);
            this.enemyWeightedHitRate += 1.0 / hitChance;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        this.enemyEnergy -= Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    public void onHitRobot(HitRobotEvent e) {
        this.enemyEnergy -= 0.6;
    }

    public Point2D.Double getBotLocation() {
        return this.BOT_LOCATION;
    }

    public Point2D.Double getEnemyLocation() {
        return this.ENEMY_LOCATION;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getAbsoluteBearing() {
        return this.absoluteBearing;
    }

    public double getBotVelocity() {
        return this.botVelocity;
    }

    public double getBotHeading() {
        return this.botHeading;
    }

    public double getBotBearing() {
        return this.botBearing;
    }

    public double getBotLateralVelocity() {
        return this.botLateralVelocity;
    }

    public double getBotLateralAcceleration() {
        return this.botLateralAcceleration;
    }

    public double getBotAdvancingVelocity() {
        return this.botAdvancingVelocity;
    }

    public double getEnemyEnergy() {
        return this.enemyEnergy;
    }

    public double getBotEnergy() {
        return this.botEnergy;
    }

    public boolean enemyFired() {
        return this.enemyFired;
    }

    public double getEnemyFirePower() {
        return this.enemyFirePower;
    }

    public double getEnemyGunHeat() {
        return this.enemyGunHeat;
    }

    public double getEnemyVelocity() {
        return this.enemyVelocity;
    }

    public double getEnemyHeading() {
        return this.enemyHeading;
    }

    public int getEnemyFireNum() {
        return this.enemyFireNum;
    }

    public int getEnemyHitNum() {
        return this.enemyHitNum;
    }

    public double getEnemyWeightedHitRate() {
        return this.enemyWeightedHitRate / this.enemyWeightedFireRate;
    }

    public int enemyTimeUntilFire() {
        return (int)Math.ceil(this.enemyGunHeat / this.GUN_COOLING_RATE);
    }

    public EnemyTargetingInfo getEnemyTargetingInfo() {
        return this.enemyTargetingInfo;
    }

    public double getMEA(int direction) {
        double turnPerTick = 8.0 / this.distance;
        double maxIteration = Math.PI * 2 / turnPerTick;
        double angle = this.absoluteBearing + Math.PI;
        double mea = 0.0;
        Point2D.Double predictedPosition = MoveUtils.project(this.ENEMY_LOCATION, angle, this.distance);
        int iteration = 0;
        while (MoveUtils.distanceToWall(predictedPosition.x, predictedPosition.y, this.BATTLE_FIELD_WIDTH, this.BATTLE_FIELD_HEIGHT) >= 18.0) {
            mea += turnPerTick;
            predictedPosition = MoveUtils.project(this.ENEMY_LOCATION, angle += turnPerTick * this.botLateralDirection * (double)direction, this.distance);
            if (!((double)(++iteration) > maxIteration)) continue;
            break;
        }
        return mea;
    }
}

